package cn.myapps.destop.tray.client;

import java.util.Map;

/**
 * 远程文件处理服务
 * @author Happy
 *
 */
public interface RemoteFileService {
	
	/**
	 * 下载远程文件到本地
	 * @param params
	 * @param filePath
	 * @throws ClientException
	 */
	public void download(Map<String,String> params,String filePath) throws ClientException;
	
	/**
	 * 文本地件上传到远程服务器
	 * @param params
	 * @param filePath
	 * @throws ClientException
	 */
	public void upload(Map<String,String> params,String filePath) throws ClientException;
	
	/**
	 * 删除远程文件
	 * @param params
	 * @param filePath
	 * @throws ClientException
	 */
	public void delete(Map<String,String> params,String filePath) throws ClientException;

}
