import instance from './ajax';

/**
 * 多语言模块
 * 获取多语言列表
 */
export const getMultiLanguageList = (params, appId) => {
  return instance({
    url: `${contextPath}/designtime/applications/${appId}/mulitlangs?label=${encodeURIComponent(params.label)}&text=${encodeURIComponent(params.text)}&type=${encodeURIComponent(params.type)}&pageNo=${params.currpage}&linesPerPage=${params.pagelines}`,
    method: 'get',
  })
}
/**
 * 删除多语言（可批量）
 */
export const deleteMultiLanguageList = (data) => {
  return instance({
    url: contextPath + '/designtime/applications/mulitlangs',
    method: 'delete',
    data
  })
}
/**
 * 
 * 获取多语言列表
 */
export const editgetMultiLanguage = (mulitlangId) => {
  return instance({
    url: contextPath + '/designtime/applications/mulitlangs/' + mulitlangId,
    method: 'get',
  })
}
/**
 * 新建多语言保存
 */
export const saveMultiLanguage = (appId, data) => {
  return instance({
    url: contextPath + '/designtime/applications/' + appId + '/mulitlangs',
    method: 'post',
    data
  })
}
/**
 * 更新多语言保存
 */
export const saveEditMultiLanguage = (data) => {
  return instance({
    url: contextPath + '/designtime/applications/mulitlangs',
    method: 'put',
    data
  })
}
/**
 * **重新加载语言属性**
 */
export const reloadMultiLanguage = () => {
  return instance({
    url: contextPath + '/designtime/applications/reloadLanguage',
    method: 'get',
  })
}