import {Api, Helper} from '../../utility';
import Tree from './Tree';
import Modal from './Modal';
import TreeMenu from './TreeMenu';
class PropsPanel {
	
	static instance = null;
	
	static getInstance() {
		if(!PropsPanel.instance || !(PropsPanel.instance instanceof PropsPanel)) {
			PropsPanel.instance = new PropsPanel();
		}

		return PropsPanel.instance;	
	}
	
	constructor() {
		this.container = null;
		this.report = null;
		this.api = new Api();
	}
	
	setProps(newProps) {
		Object.assign(this, newProps);
	}
	
	getProp(prop) {
		return this[prop];
	}

	init(params) {
		this.setProps(params);
		this.render();
	}
	
	/**
	 * 选中元素渲染右侧的属性面板
	 * @returns 
	 */
	render() {
		let that=this;
		const report = this.report;
		const api = this.api;
		const $container = $(this.container);
		//console.log("propRender")
		let $html = '';
		
		if(report) {
			//console.log(report);
			const currToEdit = report.getCurrToEdit();
			if(currToEdit == null) {
				$.when(api.getTemplete('editReport-tmpl')).done((tml) => {
					let width=(report.width/(72/2.54)).toFixed(1);
					let height=(report.height/(72/2.54)).toFixed(1);
					let pageWidth=width;
					let pageHeight=(report.pageHeight/(72/2.54)).toFixed(1);

					const data={
						name: report.reportName,
						canvasWidth:width,
						canvasHeight:height,
						pageWidth:width,
						pageHeight:pageHeight,
						filterexpression:report.filterexpression,
						isIgnorePagination:report.isIgnorePagination,
					};
					$html = Helper.getInstance().handleTemplete(tml, data, 'editReport-tmpl');
					$container.html($html);
				});
			} else if(currToEdit == 'Fields'||currToEdit == 'Variables' || currToEdit =="Parameters"){
				//console.log( typeof currToEdit)
				$.when(api.getTemplete('editForV-tmpl'), api.getJSON()).done((tml, json) => {
					//console.log(tml,json);
					const data = {
						title: currToEdit,
					};
					$html =  Helper.getInstance().handleTemplete(tml[0], data, 'editForV-tmpl');
					$container.html($html);
					
				});
			}else if(currToEdit.scope=="field"){
				$.when(api.getTemplete('editField-tmpl'), api.getJSON()).done((tml, json) => {
					//console.log(tml,json);
					const data = {
						title:currToEdit.name,
						name:currToEdit.name,
						fieldClass:currToEdit.fieldClass,
						description:currToEdit.description,
					};
					$html =  Helper.getInstance().handleTemplete(tml[0], data, 'editField-tmpl');
					$container.html($html);

				});
			}
			else if(currToEdit.scope == 'Variable'){
				let idOne=currToEdit.idOne;
				let str={
					"Nothing":"true",
					"计数":"false",
					"非重复计数":'false',
					"总数":"false",
					"平均数":'false',
					"最低数":'false',
					"最高数":"false",
					"标准偏差":'false',
					"方差":"false",
					"第一个":'false',
				};
				let option;
				switch(currToEdit.option){
					case "Count":
						option="计数"
						break;
					case "DistinctCount":
						option="非重复计数"
						break;
					case "Sum":
						option="总数"
						break;
					case "Average":
						option="平均数"
						break;
					case "Lowest":
						option="最低数"
						break;
					case "Highest":
						option="最高数"
						break;
					case "StandardDeviation":
						option="标准偏差"
						break;
					case "Variance":
						option="方差"
						break;
					case "First":
						option="第一个"
						break;
					default:
						option="Nothing"
						break;
				}
				for(var i in str){
					if(i==option){
						str[i]="true"
					}else{
						str[i]="false"
					}
				}
				let cls={
					"java.lang.String":"true",
					"java.lang.Integer":"false",
					"java.lang.Double":"false",

				}
				for(var j in cls){
					if(j==currToEdit.cls){
						cls[j]="true"
					}else{
						cls[j]="false"
					}
				}
				let resetTypeOption={
					"None":"true",
					"Report":"true",
					"Page":"true",
					"Group":"true",

				}
				for(var k in resetTypeOption){
					if(k==currToEdit.resetType){
						resetTypeOption[k]="true"
					}else{
						resetTypeOption[k]="false"
					}
				}
				let resetGroupNames={
					"":true,
				};

				if(report.chunk.length>7){
					report.chunk.forEach(elm=>{
						if(elm.scope=="GroupHeader"){
							resetGroupNames[elm.name]="false"
						}
					})
				}
				
				for(var l in resetGroupNames){
					if(l==currToEdit.resetGroup){
						resetGroupNames[l]="true"
					}else{
						resetGroupNames[l]="false"
					}
				}
				$.when(api.getTemplete('editVariable-tmpl'), api.getJSON()).done((tml, json) => {
					//console.log(json)
					const data = {
						title: "Variable",
						name: currToEdit.text,
						field:currToEdit.field,
						idOne:idOne,
						str:str,
						cls:cls,
						resetTypeOption:resetTypeOption,
						resetType:currToEdit.resetType,
						initialValueExpression:currToEdit.initialValueExpression,
						resetGroupNames:resetGroupNames,
						varExpression:currToEdit.varExpression,

					};
					//console.log(data);
					//console.log($html)
					$html =  Helper.getInstance().handleTemplete(tml[0], data, 'editVariable-tmpl');
					//console.log($html);
					$container.html($html);
					$container.find("select[name='resetType']").on("change", function(){
						that.changeEditContentPanel(this);
					})
					//console.log($html)
				});
			}else if(currToEdit.scope=="Parameter"){
				$.when(api.getTemplete('editParameter-tmpl'), api.getJSON()).done((tml, json) => {
					
					let cls={
						"java.lang.String":"true",
						"java.lang.Integer":"false",
						"java.lang.Double":"false",
	
					}
					for(var j in cls){
						if(j==currToEdit.cls){
							cls[j]="true"
						}else{
							cls[j]="false"
						}
					}
					//console.log(tml,json);
					const data = {
						title:"Parameter",
						name:currToEdit.text,
						cls:cls,
						idOne:currToEdit.idOne,
					};
					$html =  Helper.getInstance().handleTemplete(tml[0], data, 'editParameter-tmpl');
					$container.html($html);

				});
			}
		else {
				const className = currToEdit.getClassName();
				if(className == 'Title' || className == 'PageHeader' || className == 'ColumnHeader' || className == 'Detail'
				|| className == 'ColumnFooter' || className == 'PageFooter' || className == 'Summary' || className=="GroupFooter") {
					$.when(api.getTemplete('editChunk-tmpl'), api.getJSON()).done((tml, json) => {
						let config = json[0];
						config.splitType[currToEdit.getProp('splitType')] = "true";
						const data = {
							title: className,
							height: parseInt(currToEdit.getProp('height')),
							splitType: config.splitType,
							printWhenExpression:currToEdit.getProp('printWhenExpression'),
						};
						
						$html =  Helper.getInstance().handleTemplete(tml[0], data, 'editChunk-tmpl');
						$container.html($html);
					});
				} else if(className=='GroupHeader'){
					let Groupfields={};
					if(currToEdit.field==""){
						currToEdit.field="$F{"+report.field[0].columnName+"}";
					}
					report.field.forEach(function(val){
						if("$F{"+val.columnName+"}"==currToEdit.field){
							Groupfields["$F{"+val.columnName+"}"]="true";
						}else{
							Groupfields["$F{"+val.columnName+"}"]="false";
						}
					})
					$.when(api.getTemplete('editGroup-tmpl'), api.getJSON()).done((tml, json) => {
						let config = json[0];
						config.splitType[currToEdit.getProp('splitType')] = "true";
						

						const data = {
							title: className,
							height: parseInt(currToEdit.getProp('height')),
							splitType: config.splitType,
							printWhenExpression:currToEdit.getProp('printWhenExpression'),
							name:currToEdit.getProp("name"),
							fields:Groupfields,
						};
						
						$html =  Helper.getInstance().handleTemplete(tml[0], data, 'editChunk-tmpl');
						$container.html($html);
						
					});
				} 
				else {
					
						let reportElementData = {
							x: Math.round(currToEdit.getProp('x')),
							printedY: Math.round(currToEdit.getProp('printedY')),
							height: Math.round(currToEdit.getProp('height')),
							width: Math.round(currToEdit.getProp('width')),
							key: currToEdit.getProp('key'),
							forecolor: currToEdit.getProp('forecolor'),
							backcolor: currToEdit.getProp('backcolor'),
							mode: currToEdit.getProp('mode') == 'Transparent' ? 'true' : 'false',
							isPrintWhenDetailOverflows: currToEdit.getProp('isPrintWhenDetailOverflows') ? 'true' : 'false',
							isPrintRepeatedValues: currToEdit.getProp('isPrintRepeatedValues') ? 'true' : 'false',
							isPrintInFirstWholeBand: currToEdit.getProp('isPrintInFirstWholeBand') ? 'true' : 'false',
							isRemoveLineWhenBlank: currToEdit.getProp('isRemoveLineWhenBlank') ? 'true' : 'false',
							lineWidth: currToEdit.getProp('lineWidth'),
							lineStyle: currToEdit.getProp('lineStyle'),
							lineColor: currToEdit.getProp('lineColor'),
							lineStyleOption:currToEdit.getProp('lineStyleOption'),
						};
						let textElementData = {};
						let selfData = {};
						let evaluationTimeOption={
							"Now":true,
							"Report":false,
							"Page":false,
						}
						let resetTypeOption={
							"None":true,
							"Report":false,
							"Page":false,

						}
						
						switch(className) {
							case 'staticText':
								$.when(api.getTemplete('editStaticText-tmpl'), api.getJSON()).done((tml, json) => {
									let config = json[0];
									config.fontName[currToEdit.getProp('fontName')] = "true";
									config.textAlignment[currToEdit.getProp('textAlignment')] = "true";
									config.verticalAlignment[currToEdit.getProp('verticalAlignment')] = "true";
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									// config.stretchType[currToEdit.getProp('stretchType')] = 'true';
									config.lineSpacing[currToEdit.getProp('lineSpacing')] = 'true';
									config.markup[currToEdit.getProp('markup')] = 'true';
	
									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;
									for(let i in reportElementData.lineStyleOption){
										if(i==reportElementData.lineStyle){
											reportElementData.lineStyleOption[i]=true;
										}else{
											reportElementData.lineStyleOption[i]=false;
										}
									}
									textElementData = {
										fontName: config.fontName,
										textAlignment: config.textAlignment,
										verticalAlignment: config.verticalAlignment,
										size: currToEdit.getProp('size'),
										isBold: currToEdit.getProp('isBold') ? 'true' : 'false',
										isItalic: currToEdit.getProp('isItalic') ? 'true' : 'false',
										markup: config.markup,
										lineSpacing: config.lineSpacing,
										lineSpacingSize: currToEdit.getProp('lineSpacingSize'),
										leftIndent: currToEdit.getProp('leftIndent'),
										rightIndent: currToEdit.getProp('rightIndent'),
										firstLineIndent:currToEdit.getProp('firstLineIndent'),
										printWhenExpression:currToEdit.getProp('printWhenExpression'),
										islineSpacing: currToEdit.getProp('lineSpacing')=="Fixed"? 'false': 'true' ,
									};
									selfData = {
										text: currToEdit.getProp('text'),

									};
									const staticTextData = $.extend({}, reportElementData, textElementData, selfData);
									console.log(staticTextData)
									$html =  Helper.getInstance().handleTemplete(tml[0], staticTextData, 'editStaticText-tmpl');
									$container.html($html);
								});
								break;
							case 'textField':
								// let arr={};
								// let f="";
								let num=0;
								// report.field.forEach(function(val,index){
								// 	num=index;
								// 	//console.log(val.columnName,currToEdit.field)
								// 	if(val.columnName==currToEdit.field){
								// 		arr["$F{"+val.columnName+"}"]="true";
								// 		f="$F{"+val.columnName+"}"
								// 		//TreeMenu.instance.variable.nodes
								// 	}else{
								// 		arr["$F{"+val.columnName+"}"]="false";
								// 	}
								// })
								// if(num==report.field.length-1){
								// 	if(currToEdit.field){
								// 		f=currToEdit.field;
								// 	}else{
								// 		f=currToEdit.text;
								// 	}

								// }
								let cls={
									"java.lang.String":"true",
									"java.lang.Integer":"false",
									"java.lang.Double":"false",

								}
								for(var j in cls){
									if(j==currToEdit.cls){
										cls[j]="true"
									}else{
										cls[j]="false"
									}
								}
								for(let b in evaluationTimeOption){
									if(b==currToEdit.getProp('evaluationTime')){
										evaluationTimeOption[b]=true;
									}else{
										evaluationTimeOption[b]=false;
									}
								}
								$.when(api.getTemplete('editTextField-tmpl'), api.getJSON()).done((tml, json) => {
									let config = json[0];
									config.fontName[currToEdit.getProp('fontName')] = "true";
									config.textAlignment[currToEdit.getProp('textAlignment')] = "true";
									config.verticalAlignment[currToEdit.getProp('verticalAlignment')] = "true";
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									config.stretchType[currToEdit.getProp('stretchType')] = 'true';
									config.lineSpacing[currToEdit.getProp('lineSpacing')] = 'true';
									config.markup[currToEdit.getProp('markup')] = 'true';

									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;
									for(let i in reportElementData.lineStyleOption){
										if(i==reportElementData.lineStyle){
											reportElementData.lineStyleOption[i]=true;
										}else{
											reportElementData.lineStyleOption[i]=false;
										}
									}
									textElementData = {
										fontName: config.fontName,
										textAlignment: config.textAlignment,
										verticalAlignment: config.verticalAlignment,
										size: currToEdit.getProp('size'),
										isBold: currToEdit.getProp('isBold') ? 'true' : 'false',
										isItalic: currToEdit.getProp('isItalic') ? 'true' : 'false',
										printWhenExpression:currToEdit.getProp('printWhenExpression'),
										lineSpacing: config.lineSpacing,
										lineSpacingSize: currToEdit.getProp('lineSpacingSize'),
										leftIndent: currToEdit.getProp('leftIndent'),
										rightIndent: currToEdit.getProp('rightIndent'),
										firstLineIndent:currToEdit.getProp('firstLineIndent'),
										islineSpacing: currToEdit.getProp('lineSpacing')=="Fixed"? 'false': 'true' ,
									};
									selfData = {
										text: currToEdit.text,
										isBlankWhenNull: currToEdit.getProp('isBlankWhenNull') ? 'true' : 'false',
										isStretchWithOverflow: currToEdit.getProp('isStretchWithOverflow') ? 'true' : 'false',
										pattern: currToEdit.getProp('pattern'),
										evaluationTime: currToEdit.getProp('evaluationTime'),
										// splitType:arr,
										// f:f,
										expression:currToEdit.getProp("expression"),
										cls:cls,
										evaluationTimeOption:evaluationTimeOption,

									};
									const textFieldData = $.extend({}, reportElementData, textElementData, selfData);
									$html =  Helper.getInstance().handleTemplete(tml[0], textFieldData, 'editTextField-tmpl');
									$container.html($html);
								});
								break;
							case 'line':
								let directionOption=currToEdit.getProp('directionOption');
								for(let i in directionOption){
									if(i==currToEdit.getProp('direction')){
										directionOption[i]="true";
									}else{
										directionOption[i]="false";
									}
								}

								$.when(api.getTemplete('editLine-tmpl'), api.getJSON()).done((tml, json) => {
									let config = json[0];
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									config.stretchType[currToEdit.getProp('stretchType')] = 'true';
	
									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;

									for(let i in reportElementData.lineStyleOption){
										if(i==reportElementData.lineStyle){
											reportElementData.lineStyleOption[i]=true;
										}else{
											reportElementData.lineStyleOption[i]=false;
										}
									}
									textElementData = {
										printWhenExpression:currToEdit.getProp('printWhenExpression'),
									}


									selfData = {
										direction:currToEdit.getProp('direction'),
										directionOption:directionOption,

									};
									const lineData = $.extend({}, reportElementData,textElementData, selfData, {text: className});
									$html =  Helper.getInstance().handleTemplete(tml[0], lineData, 'editLine-tmpl');
									$container.html($html);
								});
								break;
							case 'rectangle':
								//let lineStyleOptionR=currToEdit.getProp('lineStyleOption');
								// for(let i in lineStyleOptionR){
								// 	if(i==currToEdit.getProp('lineStyle')){
								// 		lineStyleOptionR[i]="true";
								// 	}else{
								// 		lineStyleOptionR[i]="false";
								// 	}
								// }
								$.when(api.getTemplete('editRectangle-tmpl'), api.getJSON()).done((tml, json) => {
									let config = json[0];
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									config.stretchType[currToEdit.getProp('stretchType')] = 'true';

									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;
									for(let i in reportElementData.lineStyleOption){
										if(i==reportElementData.lineStyle){
											reportElementData.lineStyleOption[i]=true;
										}else{
											reportElementData.lineStyleOption[i]=false;
										}
									}

									textElementData = {
										printWhenExpression:currToEdit.getProp('printWhenExpression'),
									}

									selfData = {
										radius:currToEdit.getProp('radius'),
									};

									const rectangleData = $.extend({}, reportElementData,textElementData,selfData, {text: className});
									$html =  Helper.getInstance().handleTemplete(tml[0], rectangleData, 'editRectangle-tmpl');
									$container.html($html);
								});
								break;
							case 'ellipse':
								// let lineStyleOptionE=currToEdit.getProp('lineStyleOption');
								// for(let j in lineStyleOptionE){
								// 	if(j==currToEdit.getProp('lineStyle')){
								// 		lineStyleOptionE[j]="true";
								// 	}else{
								// 		lineStyleOptionE[j]="false";
								// 	}
								// }
								$.when(api.getTemplete('editEllipse-tmpl'), api.getJSON()).done((tml, json) => {
									let config = json[0];
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									config.stretchType[currToEdit.getProp('stretchType')] = 'true';

									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;
									for(let i in reportElementData.lineStyleOption){
										if(i==reportElementData.lineStyle){
											reportElementData.lineStyleOption[i]=true;
										}else{
											reportElementData.lineStyleOption[i]=false;
										}
									}

									textElementData = {
										printWhenExpression:currToEdit.getProp('printWhenExpression'),
									}

									selfData = {
									};
									const ellipseData = $.extend({}, reportElementData,textElementData,selfData, {text: className});
									$html =  Helper.getInstance().handleTemplete(tml[0], ellipseData, 'editEllipse-tmpl');
									$container.html($html);
								});
								break;
							
							case 'variable':
								//选中画布上的variable
								$.when(api.getTemplete('editVari-tmpl'), api.getJSON()).done((tml, json) => {
									//console.log(json)
									let config = json[0];
									config.fontName[currToEdit.getProp('fontName')] = "true";
									config.textAlignment[currToEdit.getProp('textAlignment')] = "true";
									config.verticalAlignment[currToEdit.getProp('verticalAlignment')] = "true";
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									config.stretchType[currToEdit.getProp('stretchType')] = 'true';
									config.lineSpacing[currToEdit.getProp('lineSpacing')] = 'true';
									config.markup[currToEdit.getProp('markup')] = 'true';
									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;
									
									textElementData = {
										fontName: config.fontName,
										textAlignment: config.textAlignment,
										verticalAlignment: config.verticalAlignment,
										size: currToEdit.getProp('size'),
										isBold: currToEdit.getProp('isBold') ? 'true' : 'false',
										isItalic: currToEdit.getProp('isItalic') ? 'true' : 'false',
										markup: config.markup,
										lineSpacing: config.lineSpacing,
										lineSpacingSize: currToEdit.getProp('lineSpacingSize'),
										leftIndent: currToEdit.getProp('leftIndent'),
										rightIndent: currToEdit.getProp('rightIndent')
									};
									
									selfData = {text: currToEdit.getProp('text'),key:currToEdit.getProp('key')==""?currToEdit.getProp('text'):currToEdit.getProp('key')};
									const staticTextData = $.extend({}, reportElementData, textElementData, selfData);
									
									$html =  Helper.getInstance().handleTemplete(tml[0], staticTextData, 'editVari-tmpl');
									$container.html($html);
								});
								break;
							case 'Image':
								
								let scaleImageOption=currToEdit.getProp('scaleImageOption');
								for(let c in scaleImageOption){
									if(c==currToEdit.getProp('scaleImage')){
										scaleImageOption[c]=true;
									}else{
										scaleImageOption[c]=false;
									}
								}
								let hAlignOption=currToEdit.getProp('hAlignOption');
								for(let d in hAlignOption){
									if(d==currToEdit.getProp('hAlign')){
										hAlignOption[d]=true;
									}else{
										hAlignOption[d]=false;
									}
								}
								let vAlignOption=currToEdit.getProp('vAlignOption');
								for(let e in vAlignOption){
									if(e==currToEdit.getProp('vAlign')){
										vAlignOption[e]=true;
									}else{
										vAlignOption[e]=false;
									}
								}
								//console.log("img")
								$.when(api.getTemplete('editImage-tmpl'), api.getJSON()).done((tml, json) => {
									let config = json[0];
									config.fontName[currToEdit.getProp('fontName')] = "true";
									config.textAlignment[currToEdit.getProp('textAlignment')] = "true";
									config.verticalAlignment[currToEdit.getProp('verticalAlignment')] = "true";
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									config.stretchType[currToEdit.getProp('stretchType')] = 'true';
									config.lineSpacing[currToEdit.getProp('lineSpacing')] = 'true';
									config.markup[currToEdit.getProp('markup')] = 'true';
	
									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;
									for(let i in reportElementData.lineStyleOption){
										if(i==reportElementData.lineStyle){
											reportElementData.lineStyleOption[i]=true;
										}else{
											reportElementData.lineStyleOption[i]=false;
										}
									}
									textElementData = {
										fontName: config.fontName,
										textAlignment: config.textAlignment,
										verticalAlignment: config.verticalAlignment,
										size: currToEdit.getProp('size'),
										src: currToEdit.getProp('srcT'),
										isBold: currToEdit.getProp('isBold') ? 'true' : 'false',
										isItalic: currToEdit.getProp('isItalic') ? 'true' : 'false',
										markup: config.markup,
										lineSpacing: config.lineSpacing,
										lineSpacingSize: currToEdit.getProp('lineSpacingSize'),
										leftIndent: currToEdit.getProp('leftIndent'),
										rightIndent: currToEdit.getProp('rightIndent'),
										printWhenExpression:currToEdit.getProp('printWhenExpression'),
									};
									selfData = {
										text: currToEdit.getProp('text'),
										scaleImageOption:scaleImageOption,
										hAlignOption:hAlignOption,
										vAlignOption:vAlignOption,


									};
									const editImage = $.extend({}, reportElementData, textElementData, selfData);
									//console.log(textElementData)
									$html =  Helper.getInstance().handleTemplete(tml[0], editImage, 'editImage-tmpl');
									$container.html($html);
								});
								break;
							case 'CurrentDate':
								let cate=currToEdit.getProp('categoryOption');
								let now=false;
								for(let i in cate){
									if(i==currToEdit.getProp('Category')){
										now=true;
										cate[i]="true";
									}else{
										cate[i]="false";
									}
								}
								if(now==false){
									for(let l in cate){
										cate[l]="true";
										break;
									}
								}
								let type;
								let now2=false;
								if(currToEdit.getProp('Category')=="Date"&&now){
									type=currToEdit.getProp('typeOption');
								}else if(now==false){
									type=currToEdit.getProp('typeOption');
								}else{
									type=currToEdit.getProp('type2Option');
								}
								for(let j in type){
									if(j==currToEdit.getProp('type')){
										now=true;
										type[j]="true";
									}else{
										type[j]="false";
									}
								}
								if(now2==false){
									for(let k in type){
										type[k]="true";
										break;
									}
								}
								for(let af in evaluationTimeOption){
									if(af==currToEdit.getProp('evaluationTime')){
										evaluationTimeOption[af]=true;
									}else{
										evaluationTimeOption[af]=false;
									}
								}

								$.when(api.getTemplete('editCurrentDate-tmpl'), api.getJSON()).done((tml, json) => {
									let config = json[0];
									config.fontName[currToEdit.getProp('fontName')] = "true";
									config.textAlignment[currToEdit.getProp('textAlignment')] = "true";
									config.verticalAlignment[currToEdit.getProp('verticalAlignment')] = "true";
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									config.stretchType[currToEdit.getProp('stretchType')] = 'true';
									config.lineSpacing[currToEdit.getProp('lineSpacing')] = 'true';
									config.markup[currToEdit.getProp('markup')] = 'true';

									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;
									for(let i in reportElementData.lineStyleOption){
										if(i==reportElementData.lineStyle){
											reportElementData.lineStyleOption[i]=true;
										}else{
											reportElementData.lineStyleOption[i]=false;
										}
									}
									textElementData = {
										fontName: config.fontName,
										textAlignment: config.textAlignment,
										verticalAlignment: config.verticalAlignment,
										size: currToEdit.getProp('size'),
										isBold: currToEdit.getProp('isBold') ? 'true' : 'false',
										isItalic: currToEdit.getProp('isItalic') ? 'true' : 'false',
										printWhenExpression:currToEdit.getProp('printWhenExpression'),
										lineSpacing: config.lineSpacing,
										lineSpacingSize: currToEdit.getProp('lineSpacingSize'),
										leftIndent: currToEdit.getProp('leftIndent'),
										rightIndent: currToEdit.getProp('rightIndent'),
										firstLineIndent:currToEdit.getProp('firstLineIndent'),
										islineSpacing: currToEdit.getProp('lineSpacing')=="Fixed"? 'false': 'true' ,
									};
									selfData = {
										text: className,
										date: currToEdit.getProp('text'),
										isBlankWhenNull: currToEdit.getProp('isBlankWhenNull') ? 'true' : 'false',
										isStretchWithOverflow: currToEdit.getProp('isStretchWithOverflow') ? 'true' : 'false',
										pattern: currToEdit.getProp('pattern'),
										evaluationTime: currToEdit.getProp('evaluationTime'),
										Category:cate,
										type:type,
										evaluationTimeOption:evaluationTimeOption,

									};
									const textFieldData = $.extend({}, reportElementData, textElementData, selfData);
									$html =  Helper.getInstance().handleTemplete(tml[0], textFieldData, 'editCurrentDate-tmpl');
									$container.html($html);
								});
								break;
							case 'PageNumber':
								for(let ag in evaluationTimeOption){
									if(ag==currToEdit.getProp('evaluationTime')){
										evaluationTimeOption[ag]=true;
									}else{
										evaluationTimeOption[ag]=false;
									}
								}
								$.when(api.getTemplete('editPageNumber-tmpl'), api.getJSON()).done((tml, json) => {
									let config = json[0];
									config.fontName[currToEdit.getProp('fontName')] = "true";
									config.textAlignment[currToEdit.getProp('textAlignment')] = "true";
									config.verticalAlignment[currToEdit.getProp('verticalAlignment')] = "true";
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									config.stretchType[currToEdit.getProp('stretchType')] = 'true';
									config.lineSpacing[currToEdit.getProp('lineSpacing')] = 'true';
									config.markup[currToEdit.getProp('markup')] = 'true';

									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;
									for(let i in reportElementData.lineStyleOption){
										if(i==reportElementData.lineStyle){
											reportElementData.lineStyleOption[i]=true;
										}else{
											reportElementData.lineStyleOption[i]=false;
										}
									}
									textElementData = {
										fontName: config.fontName,
										textAlignment: config.textAlignment,
										verticalAlignment: config.verticalAlignment,
										size: currToEdit.getProp('size'),
										isBold: currToEdit.getProp('isBold') ? 'true' : 'false',
										isItalic: currToEdit.getProp('isItalic') ? 'true' : 'false',
										printWhenExpression:currToEdit.getProp('printWhenExpression'),
										lineSpacing: config.lineSpacing,
										lineSpacingSize: currToEdit.getProp('lineSpacingSize'),
										leftIndent: currToEdit.getProp('leftIndent'),
										rightIndent: currToEdit.getProp('rightIndent'),
										firstLineIndent:currToEdit.getProp('firstLineIndent'),
										islineSpacing: currToEdit.getProp('lineSpacing')=="Fixed"? 'false': 'true' ,
									};
									selfData = {
										text: className,
										biao:currToEdit.getProp('text'),
										isBlankWhenNull: currToEdit.getProp('isBlankWhenNull') ? 'true' : 'false',
										isStretchWithOverflow: currToEdit.getProp('isStretchWithOverflow') ? 'true' : 'false',
										pattern: currToEdit.getProp('pattern'),
										evaluationTimeOption:evaluationTimeOption,

									};
									const textFieldData = $.extend({}, reportElementData, textElementData, selfData);
									$html =  Helper.getInstance().handleTemplete(tml[0], textFieldData, 'editPageNumber-tmpl');
									$container.html($html);
								});
								break;
							case 'Chart':
								for(let aa in evaluationTimeOption){
									if(aa==currToEdit.getProp('evaluationTime')){
										evaluationTimeOption[aa]=true;
									}else{
										evaluationTimeOption[aa]=false;
									}
								}
								let titlePositionOption={
									"Top":true,
									"Bottom":false,
									"Right":false,
									"Left":false,
								}
								for(let ab in titlePositionOption){
									if(ab==currToEdit.getProp('titlePosition')){
										titlePositionOption[ab]=true;
									}else{
										titlePositionOption[ab]=false;
									}
								}
								let legendPositionOption={
									"Top":true,
									"Bottom":false,
									"Right":false,
									"Left":false,
								}
								for(let ac in legendPositionOption){
									if(ac==currToEdit.getProp('legendPosition')){
										legendPositionOption[ac]=true;
									}else{
										legendPositionOption[ac]=false;
									}
								}
								let orientationOption={
									"垂直":true,
									"水平":false,

								}
								if(currToEdit.getProp('orientation')=="Vertical"){
									orientationOption["垂直"]=true;
									orientationOption["水平"]=false;
								}else{
									orientationOption["垂直"]=false;
									orientationOption["水平"]=true;
								}
								for(let ae in resetTypeOption){
									if(ae==currToEdit.getProp('resetType')){
										resetTypeOption[ae]=true;
									}else{
										resetTypeOption[ae]=false;
									}
								}
								let categoryVerticalTickLabelsOption={
									"垂直":true,
									"水平":false,
								}
								if(currToEdit.getProp('categoryVerticalTickLabels')){
									categoryVerticalTickLabelsOption["垂直"]=true;
									categoryVerticalTickLabelsOption["水平"]=false;
								}else{
									categoryVerticalTickLabelsOption["垂直"]=false;
									categoryVerticalTickLabelsOption["水平"]=true;
								}
								let valueVerticalTickLabelsOption={
									"垂直":true,
									"水平":false,
								}
								if(currToEdit.getProp('valueVerticalTickLabels')){
									valueVerticalTickLabelsOption["垂直"]=true;
									valueVerticalTickLabelsOption["水平"]=false;
								}else{
									valueVerticalTickLabelsOption["垂直"]=false;
									valueVerticalTickLabelsOption["水平"]=true;
								}
								$.when(api.getTemplete('editChart-tmpl'), api.getJSON()).done((tml, json) => {
									let config = json[0];
									config.fontName[currToEdit.getProp('fontName')] = "true";
									config.textAlignment[currToEdit.getProp('textAlignment')] = "true";
									config.verticalAlignment[currToEdit.getProp('verticalAlignment')] = "true";
									config.positionType[currToEdit.getProp('positionType')] = 'true';
									// config.stretchType[currToEdit.getProp('stretchType')] = 'true';
									config.lineSpacing[currToEdit.getProp('lineSpacing')] = 'true';
									config.markup[currToEdit.getProp('markup')] = 'true';

									reportElementData.positionType = config.positionType;
									reportElementData.stretchType = config.stretchType;
									for(let i in reportElementData.lineStyleOption){
										if(i==reportElementData.lineStyle){
											reportElementData.lineStyleOption[i]=true;
										}else{
											reportElementData.lineStyleOption[i]=false;
										}
									}
									textElementData={
										chartType:currToEdit.chartType,
										chartTypeChina:currToEdit.chartTypeChina,
										evaluationTimeOption:evaluationTimeOption,
										title:currToEdit.title,
										titleFontName:currToEdit.titleFontName,
										titleFontColor:currToEdit.titleFontColor,
										titleFontSize:currToEdit.titleFontSize,
										titlePositionOption:titlePositionOption,
										subtitle:currToEdit.subtitle,
										subtitleFontName:currToEdit.subtitleFontName,
										subtitleFontColor:currToEdit.subtitleFontColor,
										subtitleFontSize:currToEdit.subtitleFontSize,
										legendFontName:currToEdit.legendFontName,
										legendColor:currToEdit.legendColor,
										legendFontSize:currToEdit.legendFontSize,
										legendPositionOption:legendPositionOption,
										orientationOption:orientationOption,
										keyExpression:currToEdit.keyExpression,
										valueExpression:currToEdit.valueExpression,
										labelExpression:currToEdit.labelExpression,
										resetTypeOption:resetTypeOption,
										isShowLabels:currToEdit.isShowLabels,
										labelFontName:currToEdit.labelFontName,
										labelFontSize:currToEdit.labelFontSize,
										labelFontColor:currToEdit.labelFontColor,
										labelFormat:currToEdit.labelFormat,
										pielegendLabelFormat:currToEdit.pielegendLabelFormat,
										categoryVerticalTickLabelsOption:categoryVerticalTickLabelsOption,
										valueVerticalTickLabelsOption:valueVerticalTickLabelsOption,
										categoryAxisLabelExpression:currToEdit.categoryAxisLabelExpression,
										valueAxisLabelExpression:currToEdit.valueAxisLabelExpression,
										isShowShapes:currToEdit.isShowShapes,
										isShowLines:currToEdit.isShowLines,
										isShowLegend:currToEdit.isShowLegend,
										rangeAxisMinValueExpression:currToEdit.rangeAxisMinValueExpression,
										rangeAxisMaxValueExpression:currToEdit.rangeAxisMaxValueExpression,
										printWhenExpression:currToEdit.printWhenExpression,

									}
									selfData = {text: currToEdit.getProp('text')};
									const staticTextData = $.extend({}, reportElementData, textElementData, selfData);
									console.log(staticTextData)
									$html =  Helper.getInstance().handleTemplete(tml[0], staticTextData, 'editChart-tmpl');
									$container.html($html);
								});

								break;
							case 'SubReport':
								if(!report.myId)report.myId = $("#parentId").val()
								
								$.when(api.getTemplete('editSubReport-tmpl'), api.getSubReport(report.myId),).done((tml, reportNames) => {
									let subreportExpression=reportNames[0].data.datas;
									let subreportExpressions=[{"id":"","name":"选择","checked":true}];
									
									for(let k=0;k<subreportExpression.length;k++){
										if(subreportExpression[k].id==currToEdit.getProp("subreportExpression") ){
											subreportExpressions.push({"id":subreportExpression[k].id,"name":subreportExpression[k].name,"checked":true})
										}else{
											subreportExpressions.push({"id":subreportExpression[k].id,"name":subreportExpression[k].name,"checked":false})
										}
									}
									textElementData = {
										size: currToEdit.getProp('size'),
										src: currToEdit.getProp('srcT'),
										isBold: currToEdit.getProp('isBold') ? 'true' : 'false',
										isItalic: currToEdit.getProp('isItalic') ? 'true' : 'false',
										printWhenExpression:currToEdit.getProp('printWhenExpression'),
										isPrintRepeatedValues:currToEdit.getProp("isPrintRepeatedValues"),
										isRemoveLineWhenBlank:currToEdit.getProp("isRemoveLineWhenBlank"),
										printWhenExpression:currToEdit.getProp("printWhenExpression"),

										subreportExpression:currToEdit.getProp("subreportExpression"),
										subreportExpressions:subreportExpressions,
										subParameter:currToEdit.getProp("subParameter"),
									};
									selfData = {
										text: currToEdit.getProp('text'),
									};
									const editSubReport = $.extend({}, reportElementData, textElementData, selfData);
									//console.log(textElementData)
									$html =  Helper.getInstance().handleTemplete(tml[0], editSubReport, 'editSubReport-tmpl');
									$container.html($html);
								});
								break;
							default:
								break;
						}
					
				}
			}
			this.bindEvent();
		} else {
			return false;
		}
	}
	
	/**
	 * 绑定事件(文本框输入，选项框值改变触发的方法)
	 */
	bindEvent() {
		const $container = $(this.container);
		const report = this.report;
		const currToEdit = report.getCurrToEdit();
		const tree = Tree.getInstance();
		
		$container.off('mousedown', '#showCode').on("mousedown", '#showCode', (e) => {
			new Modal(e.target, $('#xmlText'), report).render();
		});

		$container.off('mousedown', '[data-id="showEditor"]').on('mousedown', '[data-id="showEditor"]', (e) => {
			new Modal(e.target, $('#editor'), report).render();
		});
		//console.log($container.find("[name=pattern]"));
		$container.off("click",'[name="subParameter"]').on("click",'[name="subParameter"]',function(){
			let that=$(this);
			var url ="subParameter.html";
			let args={};
			args.parameter=report.parameter;
			args.variable=report.variable;
			args.field=report.field;
			args.subPara=currToEdit.subParameter;
			args.result=that.val();
			OBPM.dialog.show({
				opener:window,
				width:500,
				height:350,
				title:"子报表参数",
				url:url,
				args:args,
				close:function(result){
					if(result){
						let prop={};
						prop.subParameter=result;
						currToEdit.setProps(prop);
					}
					
				}
			})
		})
		$container.off("click",'[name="filterexpression"],[name="expression"],[name="varExpression"]').on("click",'[name="filterexpression"],[name="expression"],[name="varExpression"]',function(e){
			let that=$(this);
			// console.log(e)
			const target = $(e.target);

			let name=$(e.target).prop("name");
			var url = "editExpression.html";
			let args={};
			args.parameter=report.parameter;
			args.variable=report.variable;
			args.field=report.field;
			args.result=that.val();
			OBPM.dialog.show({
				opener:window,
				width:500,
				height:300,
				title:"表达式",
				url:url,
				args:args,
				close:function(result){
					if(result || result == ""){
						switch(name){
							case 'filterexpression':
								report.filterexpression=result;
								break;
							case 'expression':
								currToEdit.expression=result;
								break;
							case 'varExpression':
									let idOne;
									if(target.siblings()[0].nodeName=="SPAN"){
										idOne=parseInt(target.parent().parent().attr("idOne"));
									}else{
										idOne=parseInt(target.parent().parent().parent().attr("idOne"));
									}
									let nodes=report.variable;
									let len=nodes.length;
									for(let i=0;i<len;i++){
										if(nodes[i].idOne==idOne){
											nodes[i].varExpression=result;
											tree.render();
										}
									}
								break;
						}
						that.val(result);
						
	
					}
					
				}
			})
		})
		$container.off("click",'[name="pattern"]').on("click",'[name="pattern"]',function(){
			let that=$(this);
			console.log($(this));
			var url = "pattern.html";
			OBPM.dialog.show({
				opener:window,
				width:500,
				height:500,
				title:"模式",
				url:url,
				args: that[0].value,
				close:function(result){
					if(result!=""){
						//let prop=reslut
						//console.log(result)
						currToEdit.setProps(result);
						that.val(result.pattern);
					}
				}
			})
		})
		$container.off("click",'[id="chartData"]').on("click",'[id="chartData"]',function(){
			let that=$(this);
			let args={}
			let data=[];

			data.push(report.getFieldToTree())
			data.push(report.getVariableToTree())
			args.date=data;
			args.chartType=currToEdit.chartType;
			// args.keyExpression=currToEdit.keyExpression;
			// args.valueExpression=currToEdit.valueExpression;
			// args.labelExpression=currToEdit.labelExpression;
			args.series=currToEdit.seriesArr;
			// let seriesArr= {
			// 	keyExpression: currToEdit.keyExpression,
			// 	valueExpression: currToEdit.valueExpression,
			// 	labelExpression: currToEdit.labelExpression,
			// }

			//console.log($(this));
			let url2= "chartDate.html?chart="+currToEdit.chartType;
			OBPM.dialog.show({
				opener:window,
				width: 600,
				height: 400,
				url: url2,
				args: args,
				title: '图表数据',
				close: function(prop) {
					if(prop){

						currToEdit.seriesArr=[];
						currToEdit.seriesArr=prop;
					}

					// currToEdit.keyExpression=prop.key;
					// currToEdit.valueExpression=prop.value;
					// currToEdit.labelExpression=prop.label;

				}
			});
		})

		$container.off("click",'[name="chartFontStyle"]').on("click",'[name="chartFontStyle"]',function(){
			let that=$(this);
			//console.log($(this));
			let id=that.attr("id");
			let data={};
			var url = "titleFont.html";
			if(id=="titleFont"){
				data={
					id:id,
					titleFontName:currToEdit.titleFontName,
					titleFontColor:currToEdit.titleFontColor,
					titleFontSize:currToEdit.titleFontSize,
				}
			}else if(id=="subtitleFont"){
				data={
					id:id,
					subtitleFontName:currToEdit.subtitleFontName,
					subtitleFontColor:currToEdit.subtitleFontColor,
					subtitleFontSize:currToEdit.subtitleFontSize,
				}
			}else if(id=="legendFont"){
				data={
					id:id,
					legendFontName:currToEdit.legendFontName,

					legendColor:currToEdit.legendColor,
					legendFontSize:currToEdit.legendFontSize,
				}
			}else if(id="labelFont"){
				data={
					id:id,
					labelFontName:currToEdit.labelFontName,
					labelFontSize:currToEdit.labelFontSize,
					labelFontColor:currToEdit.labelFontColor,
				}
			}

			OBPM.dialog.show({
				opener:window,
				width:300,
				height:300,
				title:"字体样式",
				url:url,
				args:data,
				close:function(result){
					if(result!=""){
						currToEdit.setProps(result);
						that.attr("titleFontName",result.titleFontName)
						that.attr("titleFontColor",result.titleFontColor)
						that.attr("titleFontSize",result.titleFontSize)
					}
				}
			})
		})
		$container.off("click",'[name="rangeAxisValueExpression"]').on("click",'[name="rangeAxisValueExpression"]',function(){
			let that=$(this);
			let url2= "expression.html";
			let data=[];

			data.push(report.getFieldToTree())
			data.push(report.getVariableToTree())
			let args2={
				date:data,
				val:$(this).siblings("input").val(),
				editSpan:$(this).siblings("input").attr("id"),
			}
			OBPM.dialog.show({
				opener:window,
				width: 500,
				height: 400,
				url: url2,
				args: args2,
				title: '表达式',
				close: function(prop) {
					if(prop){
						currToEdit[prop.editSpan]=prop.val;
						that.siblings("input").val(prop.val);
					}


				}
			});
		})
		$container.off('input change').on('input change', (e) => {
			const target = $(e.target);
			const key = target.attr('id');
			const type = target.attr('type');
			const isChunk = target.attr('isChunk');
			let prop = {};
			let PreHeight;
			if(type == 'number') {
				if(key == 'size') {
					prop.font = {};
					prop.font[key] = parseInt(target.val());
				}else if( key == 'leftIndent' || key == 'rightIndent' || key == 'firstLineIndent'|| key == 'lineSpacingSize'){
					prop.paragraph = {};
					prop.paragraph[key]=parseInt(target.val());
				}else if(key == "lineWidth" || key=="radius" ){
					if(target.val()<0){
						target.val("0");
						prop[key] = parseInt(target.val());
					}else{
						prop[key] = parseInt(target.val());
					}
				}else if(key=="pageWidth"){
					// yx如果值大于1000，自动默认不能输入
					if(target.val() > 999){
						target.val("1000")
					}
					let val=Math.round(target.val()*(72/2.54));
					report.canvas.width=val;
					report.width=val;
					report.pageWidth=val;
					report.changeChunkSize({"width":parseInt(val)});
					report.repaint();
				}else if(key=="pageHeight"){
					// yx
					if(target.val() > 999){
						target.val("1000")
					}else if(target.val() < document.getElementById('canvasHeight').value){
						target.val(document.getElementById('canvasHeight').value)
					}
					let val=Math.round(target.val()*(72/2.54));
					report.pageHeight=val;
				}
				// else if(key=="height" && currToEdit.top){
				// 	// let reduceHeight=currToEdit.height-parseInt(target.val());
				// 	// currToEdit.top-=reduceHeight;
				// 	prop[key] = parseInt(target.val());	
				// }
				else {
					if(target.val()==""){
						target.val(0)
					}
					prop[key] = parseInt(target.val());	
				}
			} else if(type == 'checkbox') {
				if(key == 'isBold' || key == 'isItalic') {
					prop.font = {};
					prop.font[key] = target.prop('checked');
				} else if(key == 'mode') {
					prop[key] = target.prop('checked') ?  'Transparent': 'Opaque';
				} else {
					prop[key] = target.prop('checked');	
				}
			} else if(key == 'fontName') {
				prop.font = {};
				prop.font[key] = target.val();
			}else {

				if(key == 'Category'){
					let h="";
					if(target.val()=="Date"){
						let Datetype=currToEdit.getProp("typeOption");
						for(let i in Datetype){
							h+=`<option>`+i+`</option>`
						}
					}else{
						//h=currToEdit.getProp("typeOption").Time;
						let Datetype2=currToEdit.getProp("type2Option");
						for(let i in Datetype2){
							h+=`<option>`+i+`</option>`
						}
					}
					target.siblings().parent().siblings(".input-group").eq(0).find("select").html(h);
				}
				else if(key=='lineSpacing'){
					if(target.val()=="Fixed"){
						target.parent().siblings(".input-group").find("#lineSpacingSize").removeAttr("readonly");
					}else{
						target.parent().siblings(".input-group").find("#lineSpacingSize").prop("readonly","true");
					}
					prop.paragraph = {};
					prop.paragraph[key]=target.val();
				}
				prop[key] = target.val();
			}
			if(key=="categoryVerticalTickLabels"||key=="valueVerticalTickLabels"){
				if(target.val()=="垂直"){
					prop[key]=true;
				}else if(target.val()=="水平"){
					prop[key]=false;
				}
			}
			if(key=="orientation"){
				if(target.val()=="垂直"){
					prop[key]="Vertical";
				}else if(target.val()=="水平"){
					prop[key]="Horizontal";
				}
			}
			let option2;
			if(key=="option"){

				switch(target.val()){
					case "计数":
						option2="Count"
						break;
					case "非重复计数":
						option2="DistinctCount"
						break;
					case "总数":
						option2="Sum"
						break;
					case "平均数":
						option2="Average"
						break;
					case "最低数":
						option2="Lowest"
						break;
					case "最高数":
						option2="Highest"
						break;
					case "标准偏差":
						option2="StandardDeviation"
						break;
					case "方差":
						option2="Variance"
						break;
					case "Nothing":
						option2="Nothing"
						break;
					case "第一个":
						option2="First"
						break;
					default :
						option2="Nothing"
						break;
				}
				prop[key]=option2;
			}
			if(key=="subreportExpression"){
				prop[key] = target.children("option:selected").attr("rid");
				report.subReportId=target.children("option:selected").attr("rid");
			}
			target.siblings().val(target.val());
			
			if(report.variable){
				
				let idOne;
				let name;
				if(target.siblings()[0].nodeName=="SPAN"){
					idOne=parseInt(target.parent().parent().attr("idOne"));
					name=target.parent().parent().find("input[name='name']").prop("value");
				}else{
					idOne=parseInt(target.parent().parent().parent().attr("idOne"));
					name=target.parent().parent().parent().find("input[name='name']").prop("value");
				}
				let nodes=report.variable;
				let len=nodes.length;
				for(let i=0;i<len;i++){
					if(nodes[i].idOne==idOne){
						//console.log(nodes[i])
						if(key=="text"){
							nodes[i].text=target.val();

						}else if(key=="field"){
							//.indexOf("field")!=-1
							nodes[i].field=target.val();
							nodes[i].isField="true";
						}else if(key=="fieldInput"){
							//.indexOf("field")!=-1
							nodes[i].field=target.val();
							nodes[i].isField="false";
						}else if(key=="option"){
							nodes[i].option=option2;
						}else if(key=="cls"){
							nodes[i].cls=target.val();
						}else if(key=="resetType"){
							nodes[i].resetType=target.val();
						}else if(key=="resetGroup"){
							nodes[i].resetGroup=target.val();
						}
						tree.render();
						//console.log(TreeMenu.instance.variable.nodes)
						
					}
				}
				//console.log(nodes)
			}
			if(report.parameter){
				let idOne2;
				let name2;
				if(target.siblings()[0].nodeName=="SPAN"){
					idOne2=parseInt(target.parent().parent().attr("idOne"));
					name2=target.parent().parent().find("input[name='name']").prop("value");
				}else{
					idOne2=parseInt(target.parent().parent().parent().attr("idOne"));
					name2=target.parent().parent().parent().find("input[name='name']").prop("value");
				}
				let parameters=report.parameter;
				let len2=parameters.length;
				for(let i2=0;i2<len2;i2++){
					if(parameters[i2].idOne==idOne2){
						//console.log(nodes[i])
						if(key=="text"){
							parameters[i2].text=target.val();
						}else if(key=="cls"){
							parameters[i2].cls=target.val();
						}
						tree.render();
						//console.log(TreeMenu.instance.variable.nodes)
						
					}
				}
			}
			//console.log(currToEdit)
			if(currToEdit != null&&currToEdit.setProps) {

				let maxTop=0;
				let i;
				if(isChunk=="true" && prop.height!=undefined){
					if(prop.height==currToEdit.height){
						return false;
					}

					if(prop.height!=0){
						currToEdit._beforeMoveHeight=currToEdit.height;
						currToEdit._beforeMovePos=currToEdit.top;
						if(currToEdit.height<prop.height){
							currToEdit.top+=prop.height-currToEdit.height;
						}else{
							currToEdit.top-=currToEdit.height-prop.height;
						}
						let pos=currToEdit.top;
						//+(prop.height-currToEdit.height)
						currToEdit.setProps(prop);
						currToEdit.changeSelectedChunk(pos);
						const move = currToEdit.getMoveDistance();
						report.recalculationContainerHeight();
						report.changeChunkSizeWithBaseLine(move);
						//report.changeChunkSizeWithBaseLine(pos);
						//console.log(currToEdit)
					}else{
						currToEdit._beforeMoveHeight=currToEdit.height;
						currToEdit._beforeMovePos=currToEdit.top;
						let pos2=currToEdit.top+(prop.height-currToEdit.height);
						currToEdit.setProps(prop);
						currToEdit.top=pos2;
						currToEdit.changeSelectedChunk(pos2);
						const move2 = currToEdit.getMoveDistance();

						//重计算容器的高
						report.recalculationContainerHeight();
						//改变区域大小及后面区域元素的相对于现在的位置
						report.changeChunkSizeWithBaseLine(move2);
					}

				}else{
					if(currToEdit.whichChange){ 
						currToEdit.whichChange=key;
					}
					// yx 如果当前的值输入不符合六位就出现红色的框
					if((key == 'backcolor' || key == 'forecolor' || key == 'lineColor') && (!/^#([0-9a-fA-F]{6}|[0-9a-fA-F]{3})$/.test(prop[key]))){
						document.getElementsByName(key)[0].style.borderColor = 'red'
					}else{
						document.getElementsByName(key)[0].style.borderColor = ''
					}
					currToEdit.setProps(prop);
					if(currToEdit.scope=="GroupHeader"){
						report.chunk.forEach(elm=>{
							if(elm.tip && elm.tip==currToEdit.tip){
								elm.setProps(prop)
							}
						})
					}
				}
				report.resetElementToChunk(currToEdit)

			} else if(currToEdit&&currToEdit.scope=="Variable"){
				
				//currToEdit.field=target.val();
			}else {
				
				report.setProps(prop);
			}
			//console.log(currToEdit)
			report.repaint();
			tree.render();
		});
	}
	changeEditContentPanel(dom){
        var $this = $(dom);
        var name = $this.attr("name");
        var value = $this.val();

        var $panels = $("div[data-componentName='"+name+"']");

        $panels.each(function(){
            var dataValue = $(this).data("value");
            if(typeof dataValue == "boolean"){
                dataValue = dataValue ? "true" : "false";
            }
            if(dataValue == value && $(this).hasClass("d-none")){
                $(this).removeClass("d-none");
            }else{
                $(this).addClass("d-none");
            }
        })
    }
}

export default PropsPanel;