import PaintElement from './PaintElement';
import Rectangle from '../utility/Rectangle';
import Resources from '../utility/Resources';
import Relation from './Relation';

class Node extends PaintElement {

    constructor(diagram){
		super(diagram);    
		
		this._img = null;
		
		this._txtrect = null;
		
		this._iconrect = null;
		
		this._imgrect = null;

		this.x = 0;

		this.y = 0;

		this.width = Node.WIDTH;

		this.height = Node.HEIGHT;

		this.m_width = Node.M_WIDTH;
	
		this.m_height = Node.M_HEIGHT;

		this.prenodeid = "";

		this.statelabel = "";

		this.backnodeid = "";// 回退至节点id

		this.formname = "";// 节点对应表单名

		this.fieldpermlist = "";// 节点表单域权限对应，形如@a;#b;$c格式，代码含义详见PermissionType.java类

		this.isstartandnext = false;// 启动时是否送下一人

		this._iscurrent = false;
		
		this._handlePoint = {
            x: 0,
            y: 0
		};
		
		this.orderNum=0;//排序号

		this.resize();
    }

    getShape() {
		if (_shape == null) {
			let area = new Rectangle();
			if (_imgrect != null)
				area.add(_imgrect);
			if (_txtrect != null)
				area.add(_txtrect);
			if (_iconrect != null)
				area.add(_iconrect);

			_shape = area;
		}
		return _shape;
	}

	/**
	 * @param path
	 * @return java.awt.Image
	 * @roseuid 3E046AF60136
	 */
	getImage(path) {
		let tk = Toolkit.getDefaultToolkit();
		let img = tk.getImage(path);
		return img;
	}

	/**
	 * @param x
	 * @param y
	 * @param width
	 * @param height
	 * @roseuid 3E0475DE000F
	 */
	resize() {
		if (this._imgrect == null) {
			this._imgrect = new Rectangle();
		}
		if (this._txtrect == null) {
			this._txtrect = new Rectangle();
		}
		if (this._iconrect == null) {
			this._iconrect = new Rectangle();
		}
		if (this._noderect == null) {
			this._noderect = new Rectangle();
		}

		this._imgrect.setBounds(this.x + Node.PAD, this.y + Node.PAD, 48, 48);
		this._txtrect.setBounds(this.x + Node.PAD, this.y + Node.PAD * 2, this.width, Resources.FONT_METRICS.height);
		this._iconrect.setBounds(this.x + this.width, this.y, 11, 12);
		this._noderect.setBounds(this.x, this.y, this.width,this.height);
	}

	/**
	 * @param x
	 * @param y
	 * @return boolean
	 * @roseuid 3E0A6E190080
	 */
	isSelected(x, y) {
		// Rectangle rc = new Rectangle();
		return this._noderect.contains(x, y);
	}

	/**
	 * @param x
	 * @param y
	 * @roseuid 3E0A6E19009E
	 */
	moveTo(x, y) {
    this.x = x - this._handlePoint.x;
		this.y = y - this._handlePoint.y;

		this.resize();
	}


	/**
	 * yx 获取对应的属性值
	 */
	getProp(prop) {
		return this[prop];
	}
	

  /**
   * yx获取元素连接的点
   */
	getElementConnectionPoint(elems, target) {
		let point = {};
		
		if(elems.length > 0) {
			
			for(let i = 0, len = elems.length;i < len;i++) {
				if(elems[i].getProp('id') == target.getProp('id')) {
					continue;
				}
				
				if(!(elems[i] instanceof Relation)){
					// 横坐标
					const abscissa = elems[i].getAbscissaConnectionPoint(target);
					// 纵坐标
					const ordinate = elems[i].getOrdinateConnectionPoint(target);
					// 中线
					const middle = elems[i].getMiddleConnectionPoint(target);
					
					if(point.abscissa && point.ordinate) {
						return point;
					}

					if(abscissa && !point.abscissa) {
						point.abscissa = abscissa;
					}
					
					if(ordinate && !point.ordinate) {
						point.ordinate = ordinate;
					}

					if(middle && !point.middle){
						point.middle = middle
					}
				}
			}
			return point;
		} else {
			return null;
		}
	}

  /**
   * yx 获取纵向的连接点
   */
  getAbscissaConnectionPoint(target) {
		if(parseInt(target.x) == parseInt(this.x) && target.y >= this.y) {
			return {beginPoint: {x: this.x, y: this.y}, endPoint: {x: target.x, y: (target.y + target.height)}};
		} else if(parseInt(target.x) == parseInt(this.x) && target.y <= this.y) {
			return {beginPoint: {x: target.x, y: target.y}, endPoint: {x: this.x, y: (this.y + this.height)}};
		} else if(parseInt(target.x) == parseInt(this.x + this.width) && target.y >= this.y) {
			return {beginPoint: {x: (this.x + this.width), y: this.y}, endPoint: {x: target.x, y: (target.y + target.height)}};
		} else if(parseInt(target.x) == parseInt(this.x + this.width) && target.y <= this.y) {
			return {beginPoint: {x: target.x, y: target.y}, endPoint: {x: (this.x + this.width), y: (this.y + this.height)}};
		} else if(parseInt(target.x + target.width) == parseInt(this.x) && target.y >= this.y) {
			return {beginPoint: {x: this.x, y: this.y}, endPoint: {x: (target.x + target.width), y: (target.y + target.height)}};
		} else if(parseInt(target.x + target.width) == parseInt(this.x) && target.y <= this.y) {
			return {beginPoint: {x: (target.x + target.width), y: target.y}, endPoint: {x: this.x, y: (this.y + this.height)}};
		} else if(parseInt(target.x + target.width) == parseInt(this.x + this.width) && target.y >= this.y) {
			return {beginPoint: {x: (this.x + this.width), y: this.y}, endPoint: {x: (target.x + target.width), y: (target.y + target.height)}};
		} else if(parseInt(target.x + target.width) == parseInt(this.x + this.width) && target.y <= this.y) {
			return {beginPoint: {x: (target.x + target.width), y: target.y}, endPoint: {x: (this.x + this.width), y: (this.y + this.height)}}
		} else {
			return null;
		}
	}

  /**
   * yx 获取横向链接点
   */
  getOrdinateConnectionPoint(target) {
		if(parseInt(target.y) == parseInt(this.y) && target.x >= this.x) {
			return {beginPoint: {x: this.x, y: this.y}, endPoint: {x: (target.x + target.width), y: target.y}};
		} else if(parseInt(target.y)== parseInt(this.y) && target.x <= this.x) {
			return {beginPoint: {x: target.x, y: target.y}, endPoint: {x: (this.x + this.width), y: this.y}};
		} else if(parseInt(target.y) == parseInt(this.y + this.height) && target.x >= this.x) {
			return {beginPoint: {x: this.x, y: (this.y + this.height)}, endPoint: {x: (target.x + target.width), y: target.y}};
		} else if(parseInt(target.y) == parseInt(this.y + this.height) && target.x <= this.x) {
			return {beginPoint: {x: target.x, y: target.y}, endPoint: {x: (this.x + this.width), y: (this.y + this.height)}};
		} else if(parseInt(target.y + target.height) == parseInt(this.y) && target.x >= this.x) {
			return {beginPoint: {x: this.x, y: this.y}, endPoint: {x: (target.x + target.width), y: (target.y + target.height)}};
		} else if(parseInt(target.y + target.height) == parseInt(this.y) && target.x <= this.x) {
			return {beginPoint: {x: target.x, y: (target.y + target.height)}, endPoint: {x: (this.x + this.width), y: this.y}};
		} else if(parseInt(target.y + target.height) == parseInt(this.y + this.height) && target.x >= this.x) {
			return {beginPoint: {x: this.x, y: (this.y + this.height)}, endPoint: {x: (target.x + target.width), y: (target.y + target.height)}};
		} else if(parseInt(target.y + target.height) == parseInt(this.y + this.height) && target.x <= this.x) {
			return {beginPoint: {x: target.x, y: (target.y + target.height)}, endPoint: {x: (this.x + this.width), y: (this.y + this.height)}};
		} else {
			return null;
		}
	}

	/**
	 * yx 获取中线坐标的连接点
	 * @returns 
	 */
	getMiddleConnectionPoint(target){
		if(parseInt(target.x) >= parseInt(this.x) && target.y+target.height == this.y+this.height && target.height == this.height) { //target和this都为大节点
			return {beginPoint: {x: this.x, y: this.y + this.height / 2}, endPoint: {x: target.x + target.width, y: target.y + (target.height / 2)}};
		}else if(parseInt(target.x) <= parseInt(this.x) && target.y+target.height == this.y+this.height && target.height == this.height){
			return {beginPoint: {x: target.x, y: target.y + target.height / 2}, endPoint: {x: this.x + this.width, y: this.y + (this.height / 2)}};
		}else if(target.x <= this.x && target.y+target.height/2 == this.y+this.height/2){
			return {beginPoint: {x:target.x, y: target.y + target.height / 2 - 1}, endPoint: {x: this.x + this.width, y: this.y + this.height / 2}}
		}else if(target.x >= this.x && target.y+target.height/2 == this.y+this.height/2){
			return {beginPoint: {x:this.x, y: this.y + this.height / 2 - 1}, endPoint: {x: target.x + target.width, y: target.y + target.height / 2}}
		}else if((this.x + (target.width - this.width) / 2) + this.width / 2 == target.x + target.width / 2 && this.y >= target.y){
			return {beginPoint: {x: target.x + target.width / 2, y: target.y}, endPoint: {x: this.x + this.width / 2 , y: this.y + this.height}}
		}else if(this.x == target.x && this.y >= target.y && this.height == target.height){
			return {beginPoint: {x: this.x, y: this.y + this.height / 2}, endPoint: {x: target.x + this.width, y: this.y + (this.height / 2)}};
		}else if(this.x == target.x && this.y <= target.y && this.height == target.height){
			return {beginPoint: {x: this.x + this.width / 2, y: this.y}, endPoint: {x: target.x + target.width / 2, y: target.y + target.height}}
		}else if(target.y <= this.y && target.x+target.width/2 == this.x+this.width/2){
			return {beginPoint: {x:target.x + target.width / 2 - 1, y: target.y}, endPoint: {x: this.x + this.width / 2, y: this.y + this.height}}
		}else if(target.y >= this.y && target.x+target.width/2 == this.x+this.width/2){
			return {beginPoint: {x:this.x + this.width / 2 - 1, y: this.y}, endPoint: {x: target.x + target.width / 2, y: target.y + target.height}}
		}
	}


	/**
	 * @return java.awt.Rectangle
	 * @roseuid 3E0A6E1900C6
	 */
	getRepaintRect() {
		let rct = new Rectangle(x - 20, y - 20, width + 20, height + 20);
		return rct;
	}

	removeSubElement(id) {
		if (_subelems == null) {
			return false;
		}

		for (let e = _subelems.elements(); e.hasMoreElements();) {
			let em = e.nextElement();

			if (em.id != null && em.id.equals(id)) {
				em.removeAllSubElement();
				_subelems.removeElement(em);
			}

		}

		return false;

	}

	removeAllSubElement() {
		this._subelems.removeAllElements();
	}

	//拼装XML
	toXML(){
		//检验节点名称与状态标签是否为空
		var str = "";

		str+=super.toXML();

		str+="<x>"+this.x+"</x>\n";
		str+="<y>"+this.y+"</y>\n";
		str+="<width>"+this.width+"</width>\n";
		str+="<height>"+this.height+"</height>\n";
		str+="<m_width>"+this.m_width+"</m_width>\n";
		str+="<m_height>"+this.m_height+"</m_height>\n";
		str+="<prenodeid>"+this.replaceCharacter(this.prenodeid)+"</prenodeid>\n";
		str+="<statelabel>"+this.replaceCharacter(this.statelabel)+"</statelabel>\n";
		str+="<orderNum>"+this.replaceCharacter(this.orderNum)+"</orderNum>\n";

		str+="<backnodeid>"+this.replaceCharacter(this.backnodeid)+"</backnodeid>\n";
		str+="<formname>"+this.replaceCharacter(this.formname)+"</formname>\n";
		str+="<fieldpermlist>"+this.replaceCharacter(this.fieldpermlist)+"</fieldpermlist>\n";
		str+="<isstartandnext>"+this.isstartandnext+"</isstartandnext>\n";
		str+="<_iscurrent>"+this._iscurrent+"</_iscurrent>\n";

		return str;
	}

	//xh
	// 验证器
	check() {
	  if(!this.name || !this.statelabel) {
			alert('请输入节点名称和状态标签！');
			return false;
		}
		if(this.orderNum!==0 && (this.orderNum<0||this.orderNum=="")){
			if(this.orderNum==""){this.orderNum=0}
			else{
			alert("请为"+this.name+"节点在基本信息中指定排序号!");
			return false;}
		}
		// yx
		const regText = /^[\u4e00-\u9fa5_a-zA-Z0-9]+$/g;
		if(!regText.test(this.name)){
			alert(this.name+"节点名称不能有特殊符号");
			return false
		}

		return true;   
	}
	
	//xh
	hasRelation(relation) {
		let inputCount = 0,outputCount = 0;

		for(let i = 0;i < relation.length;i++) {
			if(this.id == relation[i].startnodeid) {
				outputCount++;
			}
		}

		for(let j = 0;j < relation.length;j++) {
			if(this.id == relation[j].endnodeid) {
				inputCount++;
			}
		}

		return {input: inputCount, output: outputCount};
	}
	
	drawTips(g, tips) {

		if (tips != null && tips != '') {
			let tiplist = tips.split("\n"); 

			let tipWidth = 0;
			for (let i = 0; i < tiplist.length; i++) {
				if(g.stringWidth(tiplist[i]) > tipWidth){
					tipWidth = g.stringWidth(tiplist[i]);
				}
			}

			g.setColor(Resources.COLOR.lightYellow);
			g.fillRect(
				this.x + this.width / 2, 
				this.y + this.height, 
				tipWidth + 10, 
				(Resources.FONT_METRICS.height + 5) * tiplist.length + 10
			);
			g.setColor(Resources.COLOR.black);
			g.drawRect(
				this.x + this.width / 2, 
				this.y + this.height, 
				tipWidth + 10, 
				(Resources.FONT_METRICS.height + 5) * tiplist.length + 10
			);
			for (let i = 0; i < tiplist.length; i++) {
				g.drawString(
					tiplist[i], 
					this.x + this.width / 2 + 5, 
					this.y + this.height + (i + 1) * (Resources.FONT_METRICS.height + 5)
				);
			}
		}
	}
}

Node.WIDTH = 150;
Node.M_WIDTH = 50;
Node.HEIGHT = 70;
Node.M_HEIGHT = 50;
Node.TXTH = 10;
Node.IMGX = 50;
Node.PAD = 10;//默认边距10

export default Node;