class Element {
  constructor(diagram) {
    this._owner = diagram;
    this._subelems = [];
  }

  // 拼装XML
  toXML() {
    let str = '';

    str += '<id>' + this.replaceCharacter(this.id) + '</id>\n';
    str += '<name>' + this.replaceCharacter(this.name) + '</name>\n';

    return str;
  }

  // 替换特殊字符
  replaceCharacter(str) {
    if (str != null) {
      if(typeof str != 'string') {
        str += '';
      }
      while (str.indexOf('&') != -1 || str.indexOf('"') != -1 || str.indexOf('<') != -1 || str.indexOf('>') != -1) {
        str = str.replace(/&/g, '@amp;');
        str = str.replace(/\"/g, '@quot;');
        str = str.replace(/</g, '@lt;');
        str = str.replace(/>/g, '@gt;');
      }
      return str;
    }
    return '';
  }

  replaceXML(str) {
    if (str != null) {
      if(typeof str != 'string') {
        str += '';
      }
      while (str.indexOf('"') != -1) {
        str = str.replace(/\"/g, '@quot;');
      }
      return str;
    }
    return '';
  }

  /**
	 * @param e
	 * @roseuid 3E0A6E170254
	 */
  appendElement(e) {
    _subelems.addElement(e);
  }

  getSubelems() {
    return this._subelems;
  }
}

export default Element;
