import AbstractField from "./AbstractField";
import { Sequence } from "../../utility";

class WeixinrecordField extends AbstractField{
    constructor(container) {
        super();
        this.scope="weixinrecordField"
        this.container = container;
        this.htmlDOM=null;
        this.className="baseField";
        this.propValues.id = Sequence.createUuid();
        this.html=`<div style="padding: 5px 0;line-height: 20px;color: #3d464d;font-weight: 600;">
        <span  class="baseLabel-title" style="font-size: 14px;color: #3d464d;">微信录音控件</span>
        </div><div class="baseCon fieldId" fieldid='${this.propValues.id}' style="height: 30px;">
        <img src="images/weixinrecordField.png"/></div>`;
        
        this.propValues.name="微信录音控件"+window.formApp.formPanel.propValues.nameIndex;

        this.propValues.discript="";
        this.propValues.editProp="editWeixinrecordField";

        this.propValues.hiddenscript = ""; //隐藏条件脚本
        this.propValues.hiddenvalue = ""; //隐藏时显示值
        this.propValues.hiddenprintscript = ""; //打印时隐藏条件脚本
        this.propValues.printhiddenvalue = ""; //打印隐藏时显示值
        this.propValues.readonlyscript = ""; //只读条件脚本
        this.propValues.mobile = true;//托盘编辑显示痕迹
        this.propValues.fieldtype="VALUE_TYPE_TEXT"
    }
    getPropsDesc() {
        return {
            "base":['myselfrows','name','mobile','discript'],
            "hidden":['hiddenscript','hiddenvalue'],
            "hiddenprint":["hiddenprintscript","printhiddenvalue"],
            "readonly":['readonlyscript']
        }
    }
    
}
export default WeixinrecordField;