import {Api, Helper} from '../../utility';
import PropsPanel from './PropsPanel';
import Tree from './Tree';
import Variables from '../chunk/Variables';
import Parameters from '../chunk/Parameters';
import {GroupHeader,GroupFooter} from '../chunk/index';

//xh 左边鼠标右键variables的操作
class TreeMenu {
	static instance = null;
	
	static getInstance() {
		if(!TreeMenu.instance || !(TreeMenu.instance instanceof TreeMenu)) {
			TreeMenu.instance = new TreeMenu();
		}

		return TreeMenu.instance;	
	}
	
	constructor() {
		this.target = null;
		this.container = null;
		this.report = null;
		this.hasMenu = false;
		this.isShowMenu = false;
		this.api = new Api();
		this.variable=null;
		this.parameter=null;
		this.num=0;
		this.num2=0;
		this.type="新建";
		this.whichNode=null;
		this.preVar=null;
		this.whichGroup=null;
		
	}

	//对象方法注册
	registerFunc(signature, callback) {

		//签名唯一性判断
		if(this.func[signature] == 'undefined') {
			this.func[signature] = callback;
		} else {
			throw new Error('signature already exists');
		}
	}

	//对象方法调用
	trigger(signature, params) {
		if(this.func[signature] != 'undefined') {
			if(params != "undefined") {
				if(typeof params != 'array' && !(params instanceof Array)) {
					this.func[signature](params);
				} else {
					this.func[signature](...params);
				}
			} else {
				this.func[signature]();
			}
		} else {
			throw new Error('signature not registered');
		}
	}
	
	setProps(newProps) {
		Object.assign(this, newProps);
	}
	
	getProp(prop) {
		return this[prop];
	}

	//获取鼠标坐标位置
	getMouseCoordinate() {
		return {x: this.target.clientX, y: this.target.clientY};
	}

	showMenu() {
		this.createMenu();
		this.hasMenu=true;
		return this.container;
	}
	
	createMenu() {
		//console.log("createMenu")
		const {x, y} = this.getMouseCoordinate();
		const api = this.api;
		const that = this;
		const $container = $(this.container);

		let TreeMenu = "";

		api.getTemplete('treeMenu-tmpl').done((tml) => {
			let data={
				style: 'position:absolute;left:'+x+'px;top:'+y+'px;display:block',
				type:that.type,
			}
			TreeMenu = Helper.getInstance().handleTemplete(tml, data, 'treeMenu-tmpl');
            $('body').append(TreeMenu);
			that.setProps({hasMenu: true, isShowMenu: true, container: $('#treeMenu')});
			//console.log(this.container);
			that.registerEvent();
		});
		
	}
	
	updateMenu() {
		const {x, y} = this.getMouseCoordinate();
		const TreeMenu = $('#treeMenu');
		
		if(TreeMenu) {
			TreeMenu.css({left: x, top: y, display: 'block'});
			this.setProps({isShowMenu: true});
		}
	}
	
	hideMenu() {
		this.hasMenu=false;
		 const TreeMenu = $('#treeMenu');
		//
		 if(TreeMenu.length>0) {
		// 	TreeMenu.css('display', 'none');
			 TreeMenu.remove();
			this.setProps({isShowMenu: false});

		}


	}

	registerEvent() {
		const $container = $(this.container);
		let that = this;
		//console.log($container)
        $container.off('click', 'a').on('click', 'a', function(e) {
        	//console.log($container);
			const $this = $(this);
			const type = $this.text();
			
			switch(type) {
				case '添加变量':
					that.hideMenu();
					TreeMenu.getInstance().addTreeElement(that);
					break;
				case '删除变量':
					that.hideMenu();
					TreeMenu.getInstance().delTreeElement();
					break;
				// case '添加分组':
				// 	that.hideMenu();
				// 	TreeMenu.getInstance().addGroup();
				// 	break;
				case '删除分组':
					that.hideMenu();
					TreeMenu.getInstance().delGroup();
					break;
				case '添加参数':
					that.hideMenu();
					TreeMenu.getInstance().addTreeElement2(that);
					break;
				case '删除参数':
					that.hideMenu();
					TreeMenu.getInstance().delTreeElement2();
					break;
				default:
					break;
			}	
			// $this.css('outline-style', 'none');
		});
	}
	initTreeMenu(){
		let variable=new Variables();
		let a=variable.getNodeConfigInfo();
		this.variable=a;
		this.variable.nodes=[];
	}
	initTreeMenu2(){
		let parameter=new Parameters();
		let a=parameter.getNodeConfigInfo();
		this.parameter=a;
		this.parameter.nodes=[];
	}
	backTreeMenu(){
		if(!this.variable){
			this.initTreeMenu();
		}
		//console.log(this.variable)
		return this.variable;

	}
	backTreeMenu2(){
		if(!this.parameter){
			this.initTreeMenu2();
		}
		return this.parameter;

	}
	getNum(len){
		this.num=len;
	}
	getNum2(len){
		this.num2=len;
	}
	//删除variable子节点
	delTreeElement(){
		let that=this;
		let variable=[...this.preVar];
		let have=false;
		if(this.preVar.length>0){
			for(let i=0;i<variable.length;i++){
				if(variable[i].idOne==this.whichNode.idOne){
					have=true;
					this.preVar.splice(i,1);
				}
			}
		}
		
		Tree.getInstance().render();
	}
	//添加variable的子节点
	addTreeElement(that) {
		this.num++;
		const data = {
			text: '变量'+this.num,
			scope:'Variable',
			field:null,
			option:"Nothing",
			cls:"java.lang.String",
			icon: 'glyphicon glyphicon-th-list',
			isVariable: true,
			idOne:new Date().getTime(),
			isField:false,
			resetType:"None",
			resetGroup:"",
			varExpression:"",
		};

		//console.log(this.num)
		this.variable.nodes.push(data);
		//this.hideMenu();
		Tree.getInstance().render();
		
//		that.report.addVariable();
		PropsPanel.getInstance().render();
	}
	addTreeElement2(that) {
		this.num2++;
		const data = {
			text: '参数'+this.num2,
			scope:'Parameter',
			cls:"java.lang.String",
			icon: 'glyphicon glyphicon-th-list',
			idOne:new Date().getTime(),
		};
		this.parameter.nodes.push(data);
		Tree.getInstance().render();
		PropsPanel.getInstance().render();
	}
	delTreeElement2(){
		let that=this;
		let parameter=[...this.preVar];
		let have=false;
		if(this.preVar.length>0){
			for(let i=0;i<parameter.length;i++){
				if(parameter[i].idOne==this.whichNode.idOne){
					have=true;
					this.preVar.splice(i,1);
				}
			}
		}
		
		Tree.getInstance().render();
	}
	addGroup(){
		console.log(222);
		var timestamp=new Date().getTime();
		let Groupheader=new GroupHeader(this.report.width,this.report.height);
		let Groupfooter=new GroupFooter(this.report.width,this.report.height);
		Groupheader.tip=timestamp;
		Groupfooter.tip=timestamp;

		let headerNum=0,footerNum=0;
		this.report.chunk.forEach((el,index)=>{
			if(el.scope=='Detail'){
				headerNum=index;
				footerNum=index+1;
			}
		})
		this.report.chunk.splice(headerNum,0,Groupheader);
		this.report.chunk.splice(footerNum+1,0,Groupfooter);
		for(let i=headerNum;i<this.report.chunk.length;i++){
			if(this.report.chunk[i].scope=="GroupHeader" || this.report.chunk[i].scope=="GroupFooter" ){
				this.report.chunk[i].y=this.report.chunk[i-1].y+Groupheader.height;
				this.report.chunk[i].top=this.report.chunk[i-1].top+Groupheader.height;
			}else if(this.report.chunk[i].scope=='Detail'){
				this.report.chunk[i].y+=Groupheader.height;
				this.report.chunk[i].top+=Groupheader.height;
			}else{
				this.report.chunk[i].y+=Groupheader.height+Groupfooter.height;
				this.report.chunk[i].top+=Groupheader.height+Groupfooter.height;
			}

			if(this.report.chunk[i].element.length>0 && this.report.chunk[i].scope=='Detail'){
				this.report.chunk[i].element.forEach(elm=>{
					elm.y+=Groupheader.height;
					// elm.top+=Groupheader.height;

				})
			}else{
				
				
				this.report.chunk[i].element.forEach(elm=>{
					elm.y=elm.y+Groupheader.height+Groupfooter.height;
					// elm.top=elm.top+Groupheader.height+Groupfooter.height;

				})
			}
		}
		this.report.height=this.report.height+Groupheader.height+Groupfooter.height;
		this.report.canvas.height=this.report.canvas.height+Groupheader.height+Groupfooter.height;
		this.report.repaint();
		Tree.getInstance().render();
		// console.log(this.report.getCurrToEdit());
	}
	delGroup(){
		let that=this;
		console.log(this.whichGroup)
		
		for(let i=0;i<this.report.chunk.length;i++){
			if(this.report.chunk[i].tip && this.report.chunk[i].tip==this.whichGroup.instance.tip){
				this.report.variable.forEach(el=>{
					if(el.resetGroup==that.report.chunk[i].name){
						el.resetGroup="";
						el.resetType="Report";
					}
				})
				let move=-that.report.chunk[i].height;
				that.report._currToChunk=that.report.chunk[i];
				that.report.chunk[i].changeSelectedChunk(that.report.chunk[i].top-that.report.chunk[i].height)
				that.report.recalculationContainerHeight();
				//改变区域大小及后面区域元素的相对于现在的位置
				that.report.changeChunkSizeWithBaseLine(move);
				that.report.chunk.splice(i,1);
				i=i-1;
			}
		}
		
		this.report.repaint();
		Tree.getInstance().render();
	}
}

export default TreeMenu;