class Chunk {
	constructor(width, height) {
		this.element = [];
		this.id = "";
		this.reportWidth = width;
		this.reportHeight = height;
		this.description = "";
        this.bgcolor = Chunk.DEF_BGCOLOR;
        this.color = Chunk.DEF_COLOR;
        this.font = Chunk.DEF_FONT;
		this.printWhenExpression="";
		this.isChunk=true;
	}
	
	addElement(elem) {
		const baseline = this.getPrevChunkBaseline();
		const chunkName = this.getClassName();
		
		elem.setProps({prevChunkBaseline: baseline, belong: chunkName});
		
        this.element.push(elem);
    }
	
	delElement(elem) {
		for(let i =0, len = this.element.length;i < len;i++) {
			if(elem.getProp('id') == this.element[i].getProp('id')) {
				this.element.splice(i, 1);
				return false;
			}
		}
	}

    setProps(newProps) {
        Object.assign(this, newProps);
    }
	
	setTop(value) {
		this.top += value;
	} 

    getProp(prop) {
		return this[prop];
	}
	
	getMoveDistance() {
        return this.top - this._beforeMovePos;
    }
	
	getElementClosestToBaseline() {
		let elem = null;
		
		for(let i = 0, len = this.element.length;i < len;i++) {
			if(elem == null) {
				elem = this.element[i];
			} else {
				elem = elem.y >= this.element[i].y ? elem : this.element[i];
			}
		}
		
		return elem;
	}
	
	getPrevChunkBaseline() {
		return this.top - this.height;
	}
	
	getNodeConfigInfo() {
		let node = {};
		node.text = this.getChineseName();

		node.uuid = this.getProp('id');
		node.instance = this;
		node.idOne=this.idOne || null;
		node.field=this.field || null;
		node.option=this.option || null;
		node.scope=this.scope || null;
		if(this.element.length > 0) {
			node.nodes = []
			
			for(let i = 0, len = this.element.length;i < len;i++) {
				const data = this.element[i].getNodeConfigInfo();
				node.nodes.push(data);	
			}
		}
		if(this.element.length>0){
			//node.collapseIcon = 'glyphicon glyphicon-euro';
		}else{
			node.icon='glyphicon glyphicon-cloud';
		}
		//console.log(node);
		return node;
	}
	
	getElementConnectionPoint(target) {
		let point = {};
		
		if(this.element.length > 0) {
			
			for(let i = 0, len = this.element.length;i < len;i++) {
				if(this.element[i].getProp('id') == target.getProp('id')) {
					continue;
				}
				
				const abscissa = this.element[i].getAbscissaConnectionPoint(target);
				const ordinate = this.element[i].getOrdinateConnectionPoint(target);
				
				if(abscissa && !point.abscissa) {
					point.abscissa = abscissa;
				}
				
				if(ordinate && !point.ordinate) {
					point.ordinate = ordinate;
				}
				
				if(point.abscissa && point.ordinate) {
					return point;
				}
			}
			
			return point;
		} else {
			return null;
		}
	}
	
	// 替换特殊字符
    replaceCharacter(str) {
    if (str != null) {
        while (str.indexOf('&') != -1 || str.indexOf('"') != -1 || str.indexOf('<') != -1 || str.indexOf('>') != -1) {
			str = str.replace(/&/g, '@amp;');
			str = str.replace(/\"/g, '@quot;');
			str = str.replace(/</g, '@lt;');
			str = str.replace(/>/g, '@gt;');
        }
        return str;
    }
    return '';
    }

    replaceXML(str) {
    if (str != null) {
        while (str.indexOf('"') != -1) {
			str = str.replace(/\"/g, '@quot;');
        }
        return str;
    }
    return '';
    }
	
	isSelected(pos) {
		if(pos < this.top + 10) {
			return true;
		} else {
			return false;
		}
	}
	
	isInChunk(elem) {
		if((Math.round(elem.y) + elem.height) <= this.top && Math.round(elem.y) >= Math.round(this.top - this.height)) {
			return true;
		} else {
			return false;
		}
	}
	
	isInChunkBaseline(pos) {
		if(pos > this.top - 5 && pos < this.top + 5) {
			return true;
		}
		
		return false;
	}
	
	isBelong(element) {
		let className = this.getClassName();
		let chunkName = element.getProp('belong');
			
		if(this.isInChunk(element) && chunkName == className) {
			return true;
		} else {
			return false;
		}
	}

	hasOwnElement() {
		if(this.element.length > 0) {
			return true;
		} else {
			return false;
		}
	}
	
	hasSelectedElement(x, y) {
		for(let i = 0, len = this.element.length;i < len;i++) {
			if(this.element[i].isSelected(x, y)) {
				return this.element[i];
			}
		}

		return null;
	}
	
	changeElementPosWithTop(pos) {
		let mdt = 0;
		let baseline = this.getPrevChunkBaseline();
		
		if(this.element.length > 0) {
			for(let i = 0, len = this.element.length;i < len;i++) {
				mdt = this.element[i].getProp('y') + pos;
				this.element[i].setProps({y: mdt, prevChunkBaseline: baseline});
			}
			return;
		} else {
			return false;
		}
	}
	//pos是相对于画布的鼠标位置
	changeSelectedChunk(pos) {
		const elem = this.getElementClosestToBaseline();
        const minH = this.minHeight;
		const beforeMovePos = this._beforeMovePos;
        const beforeMoveHeight = this._beforeMoveHeight;
		
		 let h = 0;
		 let top = 0;

		if(!elem && this.height <= minH && pos < this.top) {
			h = minH;
			top =beforeMovePos - (beforeMoveHeight - minH);
				//
		} else if(elem != null && this.top <= (elem.y + elem.height)  && pos < this.top) {
			h = this.height + (elem.y + elem.height  - this.top);
			top = (elem.y +elem.height) ;
		} else {
			h = this.height + (pos - this.top);
        	top = pos;
		}
		
		this.setProps({height: h, top: top});
	}
	
	resetElementTrueOrdinate() {
		const baseline = this.getPrevChunkBaseline();
		
		if(this.element.length > 0) {
			for(let i = 0;i < this.element.length;i++) {
				this.element[i].setTrueOrdinate(baseline);
			}
		}
	}
	elemIsOnLines(y,height){
		if(y>this.top-5 && y<this.top+5){
			return this.top;
		}
		if(y+height>this.top-5 && y+height<this.top+5){
			return this.top-height;
		}
		return false;
	}
}

Chunk.DEF_CURREDITCOLOR = 'red';
Chunk.DEF_BGCOLOR = 'rgb(128, 255, 128)';
Chunk.DEF_COLOR = '#CFCFCF';
Chunk.DEF_FONT = '18px SansSerif';

export default Chunk;