import Node from "./Node";
import PaintElement from "./PaintElement";
import Resources from "../utility/Resources";
import StringUtil from "../utility/StringUtil";

class GatewayNode extends Node {
  constructor(diagram) {
    super(diagram);

    /**
     * 是否聚合节点
     */
    this.isgather = false;

    /**
     * 是否分散节点
     */
    this.issplit = false;

    /**
     * 分散节点
     */
    this.splitStartNode = "";
  }

  getClassName() {
    return "cn.myapps.runtime.workflow.element.GatewayNode";
  }

  paint(g) {
    if (this._img == null) {
      this._img = Resources.IMG_GATEWAY_NODE;
    }

    // Call All Sub Elements PAINT METHOD.
    // 保存当前背景颜色...
    let old = this.bgcolor;
    // yx 判断Ctrl数组是否有值
    if(this._owner.checkSelectArr()){
      // yx 判断是否在ctrl数据中
      if(this._owner.isInZoom(this)){
        this.bgcolor = PaintElement.DEF_CURREDITCOLOR;
      }
    }else{
      if (this._owner.isCurrentToEdit(this)) {
        this.bgcolor = PaintElement.DEF_CURREDITCOLOR;
      }
  
      if (this._owner.isCurrentSelected(this)) {
        this.bgcolor = PaintElement.DEF_SELECTEDCOLOR;
      }
    }

    for (let i = 0; i < this._subelems.length; i++) {
      let te = this._subelems[i];
      if (te instanceof PaintElement) {
        let se = te;
        se.paint(g);
      }
    }

    // Fill background
    this.width = Node.WIDTH;
    this.m_width = Node.M_WIDTH;
    this.m_height = Node.M_HEIGHT;
    this.height = Node.HEIGHT;
    this.resize();
    g.setColor(this.bgcolor);
    g.fillRect(this.x - 2, this.y - 2, this.width + 4, this.height + 4);
    // Draw Image
    g.setColor("#000");
    g.drawDiamondBorder(this.x, this.y, this.width, this.height);

    // Draw Image
    // g.drawImage(this._img, this._imgrect.x, this._imgrect.y, this._imgrect.width, this._imgrect.height);

    // yx 给节点添加默认名称
    if (this.name == "" || this.name == null) {
      this.name = "网关节点";
    }

    if (this.name != null && this.name != "") {
      // yx 判断字体过多是绘画是否一直在中间
      // let tx = this._txtrect.x;
      // const ty = this._txtrect.y + 1.5 * this._txtrect.height;
      const tx = this._txtrect.x + this._txtrect.width / 4;

      const ty = this._txtrect.y;

      g.setColor(Resources.COLOR.black);
      g.drawText(StringUtil.dencodeHTML(this.name), tx - 10, ty + 20, 80);
    }

    // 恢复当前背景颜色
    this.bgcolor = old;
  }

  toXML() {
    let str = "<cn.myapps.runtime.workflow.element.GatewayNode>\n";
    str += "<isgather>" + this.isgather + "</isgather>\n";
    str += "<issplit>" + this.issplit + "</issplit>\n";
    str += "<splitStartNode>" + this.replaceCharacter(this.splitStartNode) + "</splitStartNode>\n";
    str += super.toXML();
    str += "</cn.myapps.runtime.workflow.element.GatewayNode>\n";
    return str;
  }

  //xh
  // 验证器
  check() {
    let result = super.check();

    if (!result) {
      return false;
    }

    //聚合选项校验
    if (this.isgather) {
      if (!this.splitStartNode) {
        alert("请为" + this.name + "节点选择聚合审批节点(若选择聚合选项，则流程中至少要有一个节点开启并行)！");
        return false;
      }
    }

    return true;
  }

  //xh
  hasRelation(relation) {
    let { input, output } = super.hasRelation(relation);

    if (input == 0 && output == 0) {
      alert("请创建" + this.name + "节点的关联线！");
      return false;
    } else if (output > 0 && input == 0) {
      alert(this.name + "节点缺少接入节点！");
      return false;
    } else if (input > 0 && output == 0) {
      alert("请为" + this.name + "节点连接其他节点！");
      return false;
    } else {
      return true;
    }
  }

  // yx
  hasSomeRelation (relation) {
    return super.hasRelation(relation)
  }

  showTips(g) {
    this.drawTips(g, this.name);
  }

  errorCheck() {
    let errorStr = super.errorCheck();
    if (this.name != "") {
      if (this.isgather && this.splitStartNode == "") {
        errorStr += `${this.name} node.error.choosesplitstartnode` + `;`;
      }
    }
    return errorStr;
  }
}

export default GatewayNode;
