import Node from './Node';
import Element from './Element';
import Graphics from '../utility/Graphics';
import Resources from '../utility/Resources';
import Rectangle from '../utility/Rectangle';


class DetailSheet extends Node {
    constructor(diagram){
        super(diagram);
        this.HEAD_TEXT = "DetailSheet";
        this.HEAD_COLOR = 'rgb(255, 128, 64)';
        this.TEXT_COLOR = 'rgb(255, 255, 255)';
        this.x = 50;
        this.y = 100;
        this._headRect = {};
		this._textRect = {};
		this.bgcolor = "";
	}
	
	getClassName(){
		return "cn.myapps.runtime.dynaform.dts.excelimport.DetailSheet";
	}

    paint(g) {
        // Call All Sub Elements PAINT METHOD.
		// 保存当前背景颜色...
		const old = this.bgcolor;
		if (this._owner.isCurrentToEdit(this)) {
			this.bgcolor = Element.DEF_CURREDITCOLOR;
		}

		if (this._owner.isCurrentSelected(this)) {
			this.bgcolor = Element.DEF_SELECTEDCOLOR;
		}

		for (let i = 0; i < this._subelems.length; i++) {
			const se = this._subelems[i];
			if (se instanceof Node) {
			  se.paint(g);
			}
		  }


		this.resize();
		g.setColor(this.HEAD_COLOR);

		g.fillRect(this.x, this.y, this._headRect.width, this._headRect.height);
		g.setColor("black");        
		g.drawRect(this.x, this.y, this._headRect.width, this._headRect.height + this._textRect.height);

		//java.awt.FontMetrics fm = _owner.getFontMetrics(font);
		const hx = this.x ;
		const hy = this.y + this._headRect.height / 2;
		g.setColor('#1a1a1a');
        const headTextWidth = g.stringWidth(this.HEAD_TEXT);

		g.drawString(this.HEAD_TEXT, hx + this._headRect.width/2-headTextWidth/2, hy + 2);

		g.setColor(this.TEXT_COLOR);
		g.fillRect(this.x, this.y + this._headRect.height, this._textRect.width, this._textRect.height);

		const tx = this.x;
		const ty = this.y + this._headRect.height + this._textRect.height / 2;
		g.setColor('#1a1a1a');		
		const nameWidth = g.stringWidth(this.name);

		// yx 显示省略号
		if(this.name){
			g.drawText(this.name, tx + this._textRect.width/6, ty + 2);
		}
		else{
			g.drawString(this.name, tx + this._textRect.width/2-nameWidth/2, ty + 2);
		}

		// 恢复当前背景颜色
		// g.setColor(bgcolor);
		
		// g.drawRect(this.x, this.y, this._headRect.width, this._headRect.height + this._textRect.height);

		// this.bgcolor = old;
        
    }
	
	toXML(fieldName, fields) {
		let str = "<cn.myapps.runtime.dynaform.dts.excelimport.DetailSheet>\n";
		str += super.toXML();
		str += "</cn.myapps.runtime.dynaform.dts.excelimport.DetailSheet>\n";
		return str;
	}

	showTips(g) {
		// String tips = "列表：" + getFormatShortNameListStr() + "\n" + "备注：" +
		// note;
		let tips = '';
		tips += this.name;
		//if (this.description != null && this.description.trim() != ""
		//		&& this.description.trim() != "null") {
		//	tips = "备注：" + this.description;
		//	tips += "\n";
		//}
		this.drawTips(g, tips);
	}
}

export default DetailSheet
