package cn.myapps.macro.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RestController
public class MacroController {

    @Autowired
    private DiscoveryClient discoveryClient;
    //后台debug的url获取，当为consul时，拿取runtime的连接跳转
    @GetMapping("/api/macro/runtime/consul/debug/url")
    public Map getServiceRuntimeUrl(){

        List<ServiceInstance> instances = discoveryClient.getInstances("obpm-runtime-consul");
        if(instances != null && !instances.isEmpty()){
            ServiceInstance serviceInstance = instances.get(0);
            String host = serviceInstance.getHost();
            int port = serviceInstance.getPort();
            String contextPath = serviceInstance.getMetadata().get("contextPath");
            String runtimeUrl = host+":"+port+contextPath+"/macro/debug.html";
            Map<String,String> maps = new HashMap<>();
            maps.put("status","ok");
            maps.put("url",runtimeUrl);
            return maps;
        }
        return null;
    }
}
