package cn.myapps.common.util.cache;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class MyCacheManager {

	private static ConcurrentHashMap  _applications = new ConcurrentHashMap();

	private MyCacheManager() {
	}
	
	public static ICacheProvider getProviderInstance(String providerClassName) {
		ICacheProvider _application = (ICacheProvider) _applications.get(providerClassName);
		if (_application == null) {
			synchronized (MyCacheManager.class) {
				try {
					_application = (ICacheProvider) _applications.get(providerClassName);
					if (_application == null) {
						if (providerClassName != null) {
							Class<?> clazz = Class.forName(providerClassName);
							_application = (ICacheProvider) clazz.newInstance();
							CacheConfig cconf = CacheConfig.getInstance();
							for (Iterator<?> iter = cconf.getMethodCacheConfigs().values()
									.iterator(); iter.hasNext(); ) {
								MethodCacheConfig value = (MethodCacheConfig) iter
										.next();
								// 禁止将对象写到磁盘
								_application.createCache(value.signature,
										value.maxElementsInMemory, false, false,
										value.timeToIdleSeconds,
										value.timeToLiveSeconds);
							}
							_application.setClearedNames(cconf.getMethodCleaners());
							_applications.put(providerClassName, _application);
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}

		return _application;
	}

	public static synchronized ICacheProvider getProviderInstance() {
		CacheConfig cconf;
		try {
			cconf = CacheConfig.getInstance();
			String providerClassName = cconf.getProviderClassName();
			return getProviderInstance(providerClassName);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String buildCacheKeyString(Class<?> clazz, Method method) {
		StringBuffer sb = new StringBuffer();
		sb.append(clazz.getName()).append(".").append(method.getName()).append(
				"(");

		Class<?>[] paramsTypes = method.getParameterTypes();
		for (int i = 0; i < paramsTypes.length; i++) {
			sb.append(paramsTypes[i].getName());
			if (i < paramsTypes.length - 1) {
				sb.append(",");
			}
		}
		sb.append(")");
		return sb.toString();
	}

	public static String buildCacheKeyString(Method method) {
		StringBuffer sb = new StringBuffer();
		sb.append(method.getDeclaringClass().getName()).append(".").append(
				method.getName()).append("(");

		Class<?>[] paramsTypes = method.getParameterTypes();
		for (int i = 0; i < paramsTypes.length; i++) {
			sb.append(paramsTypes[i].getName());
			if (i < paramsTypes.length - 1) {
				sb.append(",");
			}
		}
		sb.append(")");
		return sb.toString();
	}
}
