package cn.myapps.common.util.cache;

import java.util.HashMap;
import java.util.Set;

public interface ICacheProvider {
	public static final String DEFAULT_CACHE_NAME = "DEFAULT_CACHE";

	public IMyCache getDefaultCache();

	IMyCache createCache(java.lang.String name, int maxElementsInMemory,
						 boolean overflowToDisk, boolean eternal, long timeToLiveSeconds,
						 long timeToIdleSeconds);

	IMyCache getCache(String name);

	void clearCache(String name);

	String[] getCacheNames();

	void setClearedNames(HashMap<String, MethodCacheCleaner> clearedNames);

	boolean clearByCacheName(String cacheName);

	/**
	 * 获取所有需要清除缓存的方法名称
	 *
	 * @return 所有名称
	 */
	String[] getClearedNames();

	Set getKeys(String cacheName);

	void remove(String key) throws Exception;
}