package cn.myapps.common.util.cache;

import java.lang.reflect.Method;
import java.util.Arrays;

public class CacheKey {

	private String o;

	private String method;

	Object[] methodParameters;

	public CacheKey(Object o, Method method, Object[] methodParameters) {
//		System.out.println("CacheKey Object-->"+o);
		this.o = o.getClass()+"";//o.toString();
		this.method = method.getDeclaringClass().getName()+"$$$"+method+"";
		this.methodParameters = methodParameters;
	}

	// public native int hashCode();

	public String toString() {
		StringBuffer tmp = new StringBuffer();
		if (methodParameters!=null)
			for (int i = 0; i < methodParameters.length; i++) {
				if (methodParameters[i] != null)
					tmp.append(methodParameters[i]).append(",");
			}
		return o + "&&" + method + "&&" + tmp;
	}
	/*
	private boolean equalsArray() {
		return false;
	}
	*/

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((method == null) ? 0 : method.hashCode());
		result = prime * result + Arrays.hashCode(methodParameters);
		result = prime * result + ((o == null) ? 0 : o.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CacheKey other = (CacheKey) obj;
		if (method == null) {
			if (other.method != null)
				return false;
		} else if (!method.equals(other.method))
			return false;
		if (!Arrays.equals(methodParameters, other.methodParameters))
			return false;
		if (o == null) {
			if (other.o != null)
				return false;
		} else if (!o.equals(other.o))
			return false;
		return true;
	}
}
