package cn.myapps.common.util;

import com.bcxin.saas.core.exceptions.SaasNoSupportException;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

public class SqlConditionUtil {
    public static String getCondition(String fieldName, Collection<String> scopes) {
        if (CollectionUtils.isEmpty(scopes)) {
            throw new SaasNoSupportException("数据范围无效, scopes信息不能为空");
        }

        StringBuilder where = new StringBuilder();
        scopes.forEach(ic -> {
            if (where.length() > 0) {
                where.append(",");
            }

            where.append(String.format("'%s'", ic.replace("'", "''")));
        });

        return String.format(" %s in (%s) ", fieldName, where);
    }
}
