package cn.myapps.common.util;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bcxin.web.commons.utils.RequestUtil;
import org.springframework.util.StringUtils;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Base64.Decoder;
import java.util.Base64.Encoder;
import java.util.Date;

/**
 * The security
 */
public class Security {
	public static final String ACCESS_TOKEN = "accessToken";
	public static final String DESIGNER_TOKEN = "designerToken";
	public static final String ADMIN_TOKEN = "adminToken";
	public static final String DEBUG_TOKEN = "debugToken";

	public static final String SECRET_KEY = "teemlink_obpm";
	
	private static final int EXPIRE_TIME_IN_SECONDS = 12 * 60 * 60;

	public static final long REFRESH_TIME = 1 * 60 * 60 * 1000;
	
	private static final JWTVerifier verifier = JWT.require(Algorithm.HMAC256(SECRET_KEY)).withIssuer("auth0").build();
	
	public final static String ENCRYPTION_BASE64 = "base64";
	private static Blowfish cipher = null;
	/**
	 * 来自于智能人事的加密信息
	 */
	private static final String USER_INFO = "userInfo";
	
	/**
	 * 旧的密码加密机制(主要用于登录)
	 * 
	 * @param s
	 * @return
	 * @throws Exception
	 */
	public static String encryptOld(final String s) throws Exception {
		return StringUtil.left(Security.encodeToMD5(s), 30);
	}
	
	public static String getAdminIdFromToken(HttpServletRequest request) throws JWTVerificationException {
		//对客户端发送的AccessToken参数进行校验，通过返回true，否则返回false
		//获取accessToken
		String accessToken = RequestUtil.extractValue(request, ADMIN_TOKEN);
		if(!StringUtils.hasLength(accessToken)) {
			return RequestUtil.extractAclAdminAccountId(request);
		}

		try {
			DecodedJWT jwt = verifier.verify(accessToken);
			String userId = jwt.getClaim("username").asString();
			return userId;
		} catch (Exception e) {
			return null;
		}
	}

	public static String getDesignerIdFromToken(HttpServletRequest request) throws JWTVerificationException {
		//对客户端发送的AccessToken参数进行校验，通过返回true，否则返回false
		//获取accessToken
		String accessToken = request.getParameter(DESIGNER_TOKEN);
		if (accessToken == null) {
			Cookie[] cookies = request.getCookies();
			for (Cookie cookie : cookies) {
				String name = cookie.getName();
				if (DESIGNER_TOKEN.equals(name)) {
					accessToken = cookie.getValue();
				}
			}
		}
		if (accessToken == null) {
			accessToken = request.getHeader(DESIGNER_TOKEN);
		}

		if (accessToken == null) {
			return null;
		}

		try {
			DecodedJWT jwt = verifier.verify(accessToken);
			String userId = jwt.getClaim("username").asString();
			return userId;
		} catch (Exception e) {
			return null;
		}
	}

	public static Long getDesignerExpiresAtFromToken(HttpServletRequest request) throws JWTVerificationException {
		String accessToken = request.getParameter(DESIGNER_TOKEN);
		if (accessToken == null) {
			accessToken = request.getHeader(DESIGNER_TOKEN);
		}

		if (accessToken == null) {
			Cookie[] cookies = request.getCookies();
			for (Cookie cookie : cookies) {
				String name = cookie.getName();
				if (DESIGNER_TOKEN.equals(name)) {
					accessToken = cookie.getValue();
				}
			}
		}

		if (accessToken == null) {
			return null;
		}

		DecodedJWT jwt = verifier.verify(accessToken);
		long expiresAt = jwt.getExpiresAt().getTime();

		return expiresAt;
	}

	public static String getUserIdFromToken(String token) throws JWTVerificationException {
		JWTVerifier xxx = JWT.require(Algorithm.HMAC256(SECRET_KEY)).withIssuer("auth0").acceptExpiresAt(1000 * 1000).build();
		DecodedJWT jwt = xxx.verify(token);
		String userId = jwt.getClaim("username").asString();

		return userId;
	}

	public static String getUserIdFromTokenWithoutVerify(String token) throws JWTVerificationException {
		DecodedJWT jwt = verifier.verify(token);
		String userId = jwt.getClaim("username").asString();
		return userId;
	}

	public static String getUserInfoFromToken(String token) throws JWTVerificationException {
		DecodedJWT jwt = verifier.verify(token);
		String userInfo = jwt.getClaim(USER_INFO).asString();
		return userInfo;
	}

	public static String getUserIdFromToken(HttpServletRequest request) throws JWTVerificationException {
		final String getUserIdFromTokenKey = "getUserIdFromToken";
		String userId = (String) request.getAttribute(getUserIdFromTokenKey);
		if (userId == null) {
			String accessToken = getTokenFromRequest(request);
			DecodedJWT jwt = verifier.verify(accessToken);
			userId = jwt.getClaim("username").asString();
			request.setAttribute(getUserIdFromTokenKey, userId);
		}

		return userId;
	}

	public static void addAccessToken2ResponseCookie(ServletRequest request, ServletResponse response) {
		HttpServletRequest servletRequest = (HttpServletRequest) request;
		HttpServletResponse servletResponse = (HttpServletResponse) response;

		String accessToken = getTokenFromRequest(servletRequest);
		Cookie cookie = new Cookie(Security.ACCESS_TOKEN, accessToken);

		cookie.setPath("/");
		servletResponse.addCookie(cookie);
	}


	public static String getTokenFromRequest(HttpServletRequest request) {
		return extractFieldFromRequest(request, ACCESS_TOKEN);
	}

	public static Long getUserExpiresAtFromToken(HttpServletRequest request) throws JWTVerificationException {
		String accessToken = request.getParameter(ACCESS_TOKEN);
		if (accessToken == null) {
			//获取手机端的access_token
			accessToken = request.getParameter("access_token");
			if(accessToken == null)
				accessToken = request.getHeader("accessToken");
		}

		if (accessToken == null) {
			Cookie[] cookies = request.getCookies();
			for (Cookie cookie : cookies) {
				String name = cookie.getName();
				if (ACCESS_TOKEN.equals(name)) {
					accessToken = cookie.getValue();
				}
			}
		}

		if (accessToken == null) {
			return null;
		}

		DecodedJWT jwt = verifier.verify(accessToken);
		long expiresAt = jwt.getExpiresAt().getTime();

		return expiresAt;
	}

	public static Long getAdminExpiresAtFromToken(HttpServletRequest request) throws JWTVerificationException {
		String accessToken = request.getParameter(ADMIN_TOKEN);
		if (accessToken == null) {
			accessToken = request.getHeader("accessToken");
		}

		if (accessToken == null) {
			Cookie[] cookies = request.getCookies();
			if(cookies!=null){
				for (Cookie cookie : cookies) {
					String name = cookie.getName();
					if (ADMIN_TOKEN.equals(name)) {
						accessToken = cookie.getValue();
					}
				}
			}
		}

		if (accessToken == null) {
			return null;
		}

		DecodedJWT jwt = verifier.verify(accessToken);
		long expiresAt = jwt.getExpiresAt().getTime();

		return expiresAt;
	}

	public static Long getDebugUserExpiresAtFromToken(HttpServletRequest request) throws JWTVerificationException {
		String accessToken = request.getParameter(DEBUG_TOKEN);
		if (accessToken == null) {
			accessToken = request.getHeader("accessToken");
		}

		if (accessToken == null) {
			Cookie[] cookies = request.getCookies();
			for (Cookie cookie : cookies) {
				String name = cookie.getName();
				if (DEBUG_TOKEN.equals(name)) {
					accessToken = cookie.getValue();
				}
			}
		}

		if (accessToken == null) {
			return null;
		}

		DecodedJWT jwt = verifier.verify(accessToken);
		long expiresAt = jwt.getExpiresAt().getTime();

		return expiresAt;
	}

	public static String getDebugUserIdFromToken(HttpServletRequest request) throws JWTVerificationException {
		//对客户端发送的AccessToken参数进行校验，通过返回true，否则返回false
		//获取accessToken
		String accessToken = request.getParameter(DEBUG_TOKEN);
		if (accessToken == null) {
			//获取手机端的access_token
			accessToken = request.getParameter("access_token");
			if(accessToken == null)
				accessToken = request.getHeader("accessToken");
		}

		if (accessToken == null) {
			Cookie[] cookies = request.getCookies();
			if (cookies != null) {
				for (Cookie cookie : cookies) {
					String name = cookie.getName();
					if (DEBUG_TOKEN.equals(name)) {
						accessToken = cookie.getValue();
					}
				}
			}
		}

		if (accessToken == null) {
			return null;
		}


		DecodedJWT jwt = verifier.verify(accessToken);

		String userId = jwt.getClaim("username").asString();
		return userId;
	}

	public static String extractFieldFromRequest(HttpServletRequest request,String fieldName)
	{
		if(!StringUtils.hasLength(fieldName)) {
			return null;
		}
//对客户端发送的AccessToken参数进行校验，通过返回true，否则返回false
		//获取accessToken
		String accessToken = request.getParameter(fieldName);
		if (accessToken == null) {
			//获取手机端的access_token
			accessToken = request.getParameter("access_token");
			if (accessToken == null)
				accessToken = request.getHeader("accessToken");
		}

		if (accessToken == null) {
			Cookie[] cookies = request.getCookies();
			if (cookies != null) {
				for (Cookie cookie : cookies) {
					String name = cookie.getName();
					if (fieldName.equals(name)) {
						accessToken = cookie.getValue();
					}
				}
			}
		}

		return accessToken;
	}

	public static void addFieldName2ResponseCookie(HttpServletResponse servletResponse,String fieldName,String value) {
		Cookie cookie = new Cookie(fieldName, value);

		cookie.setPath("/");
		servletResponse.addCookie(cookie);
	}
	
    public static String getToken(String userId) {
		return getToken(userId, EXPIRE_TIME_IN_SECONDS);
	}

	public static String getToken(String userId,int expiresInSeconds){
		String token = null;
		try {
			Date expiresAt = new Date(System.currentTimeMillis() + expiresInSeconds * 1000);
			token = JWT.create()
					.withIssuer("auth0")
					.withClaim("username", userId)
					.withExpiresAt(expiresAt)
					// 使用了HMAC256加密算法。
					.sign(Algorithm.HMAC256(SECRET_KEY));
		} catch (Exception e){
			e.printStackTrace();
		}
		return token;

	}

	public static String getEmailToken(String userId,Date expiresAt){

		String token = null;
		try {
			token = JWT.create()
					.withIssuer("auth0")
					.withClaim("username", userId)
					.withExpiresAt(expiresAt)
					// 使用了HMAC256加密算法。
					.sign(Algorithm.HMAC256(SECRET_KEY));
		} catch (Exception e){
			e.printStackTrace();
		}
		return token;

	}
	
	/**
	 * Encrypt the string with the MD5 arithmetic
	 * 
	 * @param s
	 *            Normal message that you want to convert.
	 * @return The Encrypt string.
	 * @throws NoSuchAlgorithmException
	 * @throws Exception
	 */
	public static String encodeToMD5(String s) throws NoSuchAlgorithmException {
		if (s == null)
			return null;
		StringBuffer digstr = new StringBuffer();
		MessageDigest MD = MessageDigest.getInstance("MD5");

		byte[] oldbyte = new byte[s.length()];
		for (int i = 0; i < s.length(); i++) {
			oldbyte[i] = (byte) s.charAt(i);
		}
		MD.update(oldbyte);
		byte[] newbyte = MD.digest(oldbyte);
		for (int i = 0; i < newbyte.length; i++) {
			digstr.append(newbyte[i]);
		}

		return digstr.toString();
	}

	/**
	 * BASE64 编码
	 * 
	 * @param s
	 * @return
	 */
	public static String encodeToBASE64(String s) {
		if (s == null)
			return null;
		return encodeToBASE64(s.getBytes());
	}
	
	/**
	 * BASE64 编码
	 * 
	 * @param obj
	 * @return
	 */
	public static String encodeToBASE64(byte[] obj) {
		if (obj == null)
			return null;
        Encoder encoder = Base64.getEncoder();
        String encode = encoder.encodeToString(obj);
        return encode;
	}

	/**
	 * BASE64 解码
	 * 
	 * @param s
	 * @return
	 */
	public static String decodeBASE64(String s) {
		if (s == null)
			return null;
        // 从JKD 9开始rt.jar包已废除，从JDK 1.8开始使用java.util.Base64.Decoder
        Decoder decoder = Base64.getDecoder();
        byte[] buffer = decoder.decode(s);
        return new String(buffer);
	}

	public static String encryptPassword(String password) {
		if (password == null) {
			return null;
		}
		Blowfish cipher = getCipher();
		if (cipher == null) {
			throw new UnsupportedOperationException();
		}
		return cipher.encryptString(password);
	}

	/**
	 * Returns a decrypted version of the encrypted password. Encryption is
	 * performed using the Blowfish algorithm. The encryption key is stored as
	 * the Jive property "passwordKey". If the key is not present, it will be
	 * automatically generated.
	 * 
	 * @param encryptedPassword
	 *            the encrypted password.
	 * @return the encrypted password.
	 * @throws UnsupportedOperationException
	 *             if encryption/decryption is not possible; for example, during
	 *             setup mode.
	 */
	public static String decryptPassword(String encryptedPassword) {
		if (encryptedPassword == null) {
			return null;
		}
		Blowfish cipher = getCipher();
		if (cipher == null) {
			throw new UnsupportedOperationException();
		}
		return cipher.decryptString(encryptedPassword);
	}

	/**
	 * Returns a Blowfish cipher that can be used for encrypting and decrypting
	 * passwords. The encryption key is stored as the Jive property
	 * "passwordKey". If it's not present, it will be automatically generated.
	 * 
	 * @return the Blowfish cipher, or <tt>null</tt> if Openfire is not able to
	 *         create a Cipher; for example, during setup mode.
	 */
	private static synchronized Blowfish getCipher() {
		if (cipher != null) {
			return cipher;
		}
		// Get the password key, stored as a database property. Obviously,
		// protecting your database is critical for making the
		// encryption fully secure.
		String keyString;
		try {
			keyString = "obpm";
			if (keyString == null) {
				// Check to make sure that setting the property worked. It won't
				// work,
				// for example, when in setup mode.
			}
			cipher = new Blowfish(keyString);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return cipher;
	}

	/**
	 * 把16进制字符串转换成字节数组
	 * 
	 * @param hex
	 * @return
	 */
	public static byte[] hexStringToByte(String hex) {
		int len = (hex.length() / 2);
		byte[] result = new byte[len];
		char[] achar = hex.toCharArray();
		for (int i = 0; i < len; i++) {
			int pos = i * 2;
			result[i] = (byte) (toByte(achar[pos]) << 4 | toByte(achar[pos + 1]));
		}
		return result;
	}

	private static byte toByte(char c) {
		byte b = (byte) "0123456789ABCDEF".indexOf(c);
		return b;
	}

	/**
	 * 把字节数组转换成16进制字符串
	 * 
	 * @param bArray
	 * @return
	 */
	public static final String bytesToHexString(byte[] bArray) {
		StringBuffer sb = new StringBuffer(bArray.length);
		String sTemp;
		for (int i = 0; i < bArray.length; i++) {
			sTemp = Integer.toHexString(0xFF & bArray[i]);
			if (sTemp.length() < 2)
				sb.append(0);
			sb.append(sTemp.toUpperCase());
		}
		return sb.toString();
	}

	private static final String AUTHENTICATION="Authorization";
	private static final String BEARER_USER_ID="BEARER_USER_ID";
	/**
	 * 获取自然人的用户Id
	 * @param request
	 * @return
	 */
	public static String extractBearerUserId(HttpServletRequest request) {
		Object bearerUserId = request.getAttribute(BEARER_USER_ID);
		if (bearerUserId == null) {
			String authentication = request.getHeader(AUTHENTICATION);
			if (StringUtil.isBlank(authentication) || authentication.length() < 7) {
				bearerUserId = "";
			} else {
				String token = authentication.substring(7);
				bearerUserId = getUserIdFromToken(token);

				request.setAttribute(BEARER_USER_ID, bearerUserId);
			}
		}

		return (String) bearerUserId;
	}
}
