package cn.myapps.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

public class PropertyUtil {
    private static Map<String, Properties> settings = new HashMap<>();

    public static String getPath() {
        String path = DefaultProperty.getProperty("myapps.storage.root");
        return path;
    }

    private synchronized static void load(String name) {
        if (!isLoaded(name)) {
            Properties props = new Properties();

            URL propsUrl = null;
            try {
                String path = getPath();
                propsUrl = new URL("file", null, path + "/" + name + ".properties");
            } catch (Exception e) {
                e.printStackTrace();
            }

            //URL propsUrl = Thread.currentThread().getContextClassLoader().getResource(name + ".properties");

            if (propsUrl == null) {
                throw new IllegalStateException(name + ".properties missing");
            }
            try (InputStream stream = propsUrl.openStream()) {
                // Load settings
                props.load(new InputStreamReader(stream, "UTF-8"));
            } catch (IOException e) {
                throw new RuntimeException("Could not load " + name + ".properties:" + e);
            }
            settings.put(name, props);
        }
    }

    public static void init() {
        if (settings == null || settings.isEmpty()) {
            load("notification");
            load("security");
            load("sso");
            load("email");
            load("myapp");
            load("ftp");
            load("skin");
        }

    }

    public static String get(String key) {
        return get(key, null);
    }

    public static boolean getBoolean(String key) {
        String rtn = get(key, null);
        if (rtn != null) {
            return Boolean.getBoolean(rtn);
        }
        return false;
    }

    public static Properties getProp(String name) {
        URL propsUrl = null;
        try {
            String path = getPath();
            propsUrl = new URL("file", null, path + "/" + name + ".properties");
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (propsUrl == null) {
            throw new IllegalStateException(name + ".properties missing");
        }
        try (InputStream stream = propsUrl.openStream()) {
            Properties props = new Properties();
            props.load(new InputStreamReader(stream, "UTF-8"));
            return props;
        } catch (IOException e) {
            throw new RuntimeException("Could not load " + name + ".properties:" + e);
        }

    }

    public static String get(String key, String defaultValue) {
        if (settings == null || settings.isEmpty()) {
            init();
        }

        if (settings != null) {
            for (Iterator<String> iter = settings.keySet().iterator(); iter.hasNext(); ) {
                String propName = iter.next();
                Properties props = settings.get(propName);
                String value = (String) props.getProperty(key, defaultValue);
                if (value != null) {
                    return value;
                }
            }
        }
        return null;
    }

    public static String getByPropName(String propName, String key) {
        if (settings == null || settings.isEmpty()) {
            init();
        }

        if (settings != null && settings.get(propName) != null) {
            return settings.get(propName).getProperty(key);
        }
        return null;
    }

    public static void clear() {
        settings.clear();

    }

    public static void reload() {
        Collection<String> tempNames = new HashSet<String>();
        tempNames.addAll(settings.keySet());
        settings.clear();

        for (Iterator<String> iter = tempNames.iterator(); iter.hasNext(); ) {
            String name = iter.next();
            load(name);
        }
    }

    public static void reload(String propKey) {
        load(propKey);
    }

    public static Map<String, String> toMap() {
        Map<String, String> rtn = new HashMap<String, String>();
        for (Iterator<String> iterator = settings.keySet().iterator(); iterator.hasNext(); ) {
            Properties properties = settings.get(iterator.next());
            for (Iterator<?> iterator2 = properties.keySet().iterator(); iterator2.hasNext(); ) {
                String key = (String) iterator2.next();
                String value = properties.getProperty(key);
                rtn.put(key, value);

            }
        }
        return rtn;
    }

    private static boolean isLoaded(String name) {
        return settings.keySet().contains(name);
    }

    private static Boolean _isNetworkEnvironment = null;

    public static boolean IsNetworkEnvironment() {
        if (_isNetworkEnvironment == null) {
            _isNetworkEnvironment = "network".equalsIgnoreCase(PropertyUtil.get("myapps.environment"));
        }

        return _isNetworkEnvironment.booleanValue();
    }
}
