package cn.myapps.common.util;

import lombok.Data;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

@Configuration
public class PropertiesConfig {

    @Value("${server.servlet.context-path}")
    private String contextPath;

    @Value("${myapps.storage.root}")
    private String storageroot;

    /**
     * 默认是都没填
     */
    @Value("${spring.jpa.properties.hibernate.default_schema:}")
    private String defaultSchema;

    @Value("${server.port}")
    private int serverPort;

    @Value("${myapps.refresh.cache.monitor.types:}")
    private String[] refreshCacheMonitorTypes;

    @Value("${myapps.refresh.cache.profile:}")
    private String refreshCacheProfile;

    @Value("${myapps.ignored.count.query.timeout:false}")
    private boolean ignoredCountQueryTimeout;

    @Value("${myapps.ignored.count.cacahed.timeoutInSeconds:10}")
    private int cacheCountQueryInSeconds;

    public int getServerPort() {
        return serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getContextPath() {
        return contextPath;
    }

    public String getDefaultSchema() {
        return defaultSchema;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getStorageroot() {
        File root = new File(storageroot);
        if (root.exists() && root.isDirectory()) {
            return storageroot;
        } else {
            storageroot = System.getProperty("user.dir") + File.separator + ".." + File.separator + "obpm-demo";
            return storageroot;
        }
    }

    public void setStorageroot(String storageroot) {
        this.storageroot = storageroot;
    }

    public String[] getRefreshCacheMonitorTypes() {
        return refreshCacheMonitorTypes;
    }

    public boolean isIgnoredCountQueryTimeout()
    {
        return ignoredCountQueryTimeout;
    }

    public int getCacheCountQueryInSeconds() {
        return cacheCountQueryInSeconds;
    }

    public void setRefreshCacheMonitorTypes(String[] refreshCacheMonitorTypes) {
        this.refreshCacheMonitorTypes = refreshCacheMonitorTypes;
    }

    public boolean isRefreshCache(String type) {
        if (this.getRefreshCacheMonitorTypes() == null || this.getRefreshCacheMonitorTypes().length == 0) {
            return false;
        }

        return Arrays.stream(this.getRefreshCacheMonitorTypes()).collect(Collectors.toList()).contains(type);
    }

    public String getRefreshCacheProfile() {
        return refreshCacheProfile;
    }

    public void setRefreshCacheProfile(String refreshCacheProfile) {
        this.refreshCacheProfile = refreshCacheProfile;
    }

    public boolean isEnabledRefreshCached() {
        return StringUtils.hasLength(this.getRefreshCacheProfile());
    }
}
