package cn.myapps.common.util;

import java.io.File;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * The default property.
 */
public class DefaultProperty {
	private static Properties prop = null;
	protected static final Logger log = LoggerFactory.getLogger(DefaultProperty.class);

	private static String rootPath = null;

	/**
	 * Initialize the proerties
	 * 
	 * @throws Exception
	 */
	private static void init() throws Exception {
		if (prop == null){
			synchronized (DefaultProperty.class) {
			prop = new Properties();
			prop = PropertyUtil.getProp("myapp");
			}
		}
	}

	/**
	 * Get the property value
	 * 
	 * @param key
	 *            The property key
	 * @param defaultValue
	 *            The default value.
	 * @return The Property value.
	 * @throws Exception
	 */
	public static String getProperty(String key, String defaultValue) {
		if (prop == null) {
			try {
				init();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return prop != null ? prop.getProperty(key, defaultValue):null;
	}

	/**
	 * Get the property value
	 * 
	 * @param key
	 *            The property key
	 * @return The Property value.
	 * @throws Exception
	 */
	public static PropertiesConfig initBean(){
		PropertiesConfig config = SpringApplicationContextUtil.getBean("propertiesConfig");
		return config;
	}

	public static String getProperty(String key) {
		switch (key){
			case "myapps.storage.root":
				if(rootPath == null){
					rootPath = StringUtil.isBlank(initBean().getStorageroot())?getProperty(key,null):initBean().getStorageroot();
					File root = new File(rootPath);
					if (!root.exists() || !root.isDirectory()) {
						rootPath = System.getProperty("user.dir") + File.separator + ".." + File.separator + "obpm-demo";
						log.warn(rootPath);
					}
				}
				return rootPath;
			default:
				return getProperty(key, null);
		}
	}

}
