package cn.myapps.common.util;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

import cn.myapps.common.model.table.Column;
import cn.myapps.common.model.table.Table;

public class DbUtil {
	public static final String DBTYPE_ORACLE = "ORACLE";

	public static final String DBTYPE_MSSQL = "MSSQL";

	public static final String DBTYPE_MYSQL = "MYSQL";

	public static final String DBTYPE_HSQLDB = "HSQLDB";

	public static final String DBTYPE_DB2 = "DB2";

	public static final String DBTYPE_POSTGRESQL = "POSTGRESQL";

	public static final String DBTYPE_DM = "DM";

	public static final String DBTYPE_KINGBASE = "KINGBASE";

	public static HashMap<String, String> _dbTypes = new HashMap<String, String>();

	public static String getDBType(Connection conn) throws SQLException {
		String productName = conn.getMetaData().getDatabaseProductName().toUpperCase();
		// 通过driverName是否包含关键字判断
		if (productName.indexOf("MYSQL") != -1) {
			return DBTYPE_MYSQL;
		} else if (productName.indexOf("SQL SERVER") != -1) {
			// sqljdbc与sqljdbc4不同，sqlserver中间有空格
			return DBTYPE_MSSQL;
		} else if (productName.indexOf("ORACLE") != -1) {
			// sqljdbc与sqljdbc4不同，sqlserver中间有空格
			return DBTYPE_ORACLE;
		} else if (productName.indexOf("DB2") != -1) {
			// sqljdbc与sqljdbc4不同，sqlserver中间有空格
			return DBTYPE_DB2;
		} else if (productName.indexOf("POSTGRESQL") != -1) {
			// sqljdbc与sqljdbc4不同，sqlserver中间有空格
			return DBTYPE_POSTGRESQL;
		} else if (productName.indexOf("DM") != -1) {
			return DBTYPE_DM;
		} else if (productName.indexOf("KINGBASEES") != -1) {
			return DBTYPE_KINGBASE;
		}

		// Oracle
		return "-1";
	}

	public static String getSchema(Connection conn, String dbType) {
		if (dbType.equals(DBTYPE_ORACLE) || dbType.equals(DBTYPE_DB2) || dbType.equals(DBTYPE_DM)) {
			try {
				return conn.getMetaData().getUserName().trim().toUpperCase();
			} catch (SQLException sqle) {
				return "";
			}
		} else if (dbType.equals(DBTYPE_MYSQL)) {
			try {
				/*
				 * String schema = conn.getMetaData().getURL().trim().toUpperCase(); if
				 * (schema.indexOf("?USE") > 0) { schema =
				 * schema.substring(schema.lastIndexOf("/") + 1, schema.indexOf("?USE")); } else
				 * { schema = schema.substring(schema.lastIndexOf("/") + 1); } return schema;
				 */
				return conn.getCatalog();
			} catch (SQLException sqle) {
				return "";
			}

		} else if (dbType.equals(DBTYPE_MSSQL)) {
//			try {
//				ResultSet rs = conn.getMetaData().getSchemas();
//				if (rs != null) {
//					if (rs.next())
//						return rs.getString(1).trim().toUpperCase();
//				}
//			} catch (SQLException sqle) {
//				return "";
//			}
			return "dbo";
			/*
			 * try { String schema = conn.getMetaData().getURL().trim().toUpperCase(); int
			 * index = schema.indexOf("/"); if (index > 0) { if(schema.substring(index - 1,
			 * index).matches("\\d")){ return schema.substring(schema.lastIndexOf("/") + 1);
			 * } } return ""; } catch (SQLException sqle) { return ""; }
			 */
		} else if (dbType.equals(DBTYPE_HSQLDB)) {
			return "public".toUpperCase();
		} else if (dbType.equals(DBTYPE_POSTGRESQL)) {
			try {
				String schema = conn.getMetaData().getURL().trim().toUpperCase();

				if (schema.indexOf("CURRENTSCHEMA") > 0) {
					schema = schema.substring(
							schema.lastIndexOf("CURRENTSCHEMA") + "CURRENTSCHEMA=".length());
					schema = schema.toLowerCase();
					schema = conn.getCatalog() + "." + schema.toLowerCase();
					return schema;
				} else {
					schema = conn.getCatalog() + ".public";
					return schema;
				}
			} catch (SQLException sqle) {
				return "";
			}

		} else if (dbType.equals(DBTYPE_KINGBASE)) {
			try {
				return "PUBLIC";
			} catch (Exception sqle) {
				return "";
			}
		}

		return "";
	}

	public static Table getTable(String tableName, String dbType, Connection conn) {
		Collection<Table> tables = getTables(tableName, dbType, conn);
		if (tables != null && !tables.isEmpty()) {
			return tables.iterator().next();
		}

		return null;
	}

	/**
	 * @param tableName     数据表名称
	 * @param applicationId 应用ID
	 * @return 表集合
	 */
	public static Collection<Table> getTables(String tableName, String dbType, Connection conn) {
		Collection<Table> rtn = new ArrayList<Table>();

		ResultSet tableSet = null;
		try {

			String catalog = null;
			String schemaPattern = null;

			String schema = getSchema(conn, dbType);

			if (dbType.equals(DBTYPE_ORACLE) || dbType.equals(DBTYPE_DM)) {
				schemaPattern = schema;
			} else if (dbType.equals(DBTYPE_MSSQL)) {
				schemaPattern = "DBO";
				int databaseVersion = conn.getMetaData().getDatabaseMajorVersion();
				if (9 <= databaseVersion) {// MSSQL 2005 允许脏读
					conn.setTransactionIsolation(Connection.TRANSACTION_READ_UNCOMMITTED);
				}
			} else if (dbType.equals(DBTYPE_MYSQL)) {
				catalog = schema;
			} else if (dbType.equals(DBTYPE_HSQLDB)) {
				schemaPattern = schema;
			} else if (dbType.equals(DBTYPE_DB2)) {
				schemaPattern = schema;
			} else if (dbType.equals(DBTYPE_POSTGRESQL)) {
				catalog = schema.split("\\.")[0];
				schemaPattern = schema.split("\\.")[1];
			} else if (dbType.equals(DBTYPE_KINGBASE)) {
				catalog = schema;
			}

			DatabaseMetaData metaData = conn.getMetaData();
			if (dbType.equals(DBTYPE_POSTGRESQL)) {
				tableSet = metaData.getTables(catalog, schemaPattern, null, new String[]{"TABLE"});
			} else {
				tableSet = metaData.getTables(catalog, schemaPattern, tableName, new String[]{"TABLE"});
			}
			boolean isTableNameNotNull = true;
			if (tableName == null) {
				isTableNameNotNull = false;
			}

			while (tableSet.next()) {
				String dbTableName = tableSet.getString(3);
				if (dbType.equals(DBTYPE_POSTGRESQL)) {
					if (isTableNameNotNull && tableName != null
							&& !tableName.trim().toUpperCase().equals(dbTableName.trim().toUpperCase())) {
						continue;
					}
					tableName = dbTableName;
				} else {
					tableName = dbTableName;
				}

				Table table = new Table(tableName.toUpperCase());
				ResultSet columnSet = null;
				try {
					columnSet = metaData.getColumns(catalog, schemaPattern, tableName, null);
					while (columnSet.next()) {
						String name = columnSet.getString(4);
						int typeCode = columnSet.getInt(5);
						String remarks = columnSet.getString("REMARKS");
						Column column = new Column("", name.toUpperCase(), typeCode, remarks, null);

						table.getColumns().add(column);
					}

				} catch (Exception e) {
					e.printStackTrace();
				} finally {
					if (columnSet != null) {
						columnSet.close();
					}
				}

				rtn.add(table);
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				tableSet.close();
			} catch (SQLException e) {
				e.printStackTrace();
			}
		}

		return rtn;
	}

	//获取数据库对应validationQuery属性
	public static String getValidationQuery(String driveClassName) {
		if (driveClassName.contains("mysql")) {
			return "select 1";
		} else {
			driveClassName = driveClassName.toLowerCase();
			if (driveClassName.contains("oracle")) {
				return "select 1 from dual";
			} else if (driveClassName.contains("db2")) {
				return "select 1 from sysibm.sysdummy1";
			} else if (driveClassName.contains("postgresql")) {
				return "select version()";
			} else {
				return "select 1";
			}
		}
	}
}
