package cn.myapps.common.jdbcs.filters;

import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.bcxin.saas.core.ContextConstant;
import com.bcxin.saas.core.components.JsonProvider;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DeleteInterceptorFilter extends FilterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DeleteInterceptorFilter.class);

    public DeleteInterceptorFilter() {
        logger.error("注册DeleteInterceptorFilter");
    }

    private static DeleteInterceptorFilter singleton = null;

    public static synchronized DeleteInterceptorFilter getInstance() {
        if (singleton == null) {
            singleton = new DeleteInterceptorFilter();
        }

        return singleton;
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        doExecute(sql, statement);
        return super.statement_execute(chain, statement, sql);
    }

    @Override
    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        doExecute(sql, statement);
        return super.statement_execute(chain, statement, sql, columnNames);
    }

    @Override
    public boolean preparedStatement_execute(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        doExecute(statement.getSql(), statement);
        return super.preparedStatement_execute(chain, statement);
    }

    @Override
    public int preparedStatement_executeUpdate(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        doExecute(statement.getSql(), statement);
        return super.preparedStatement_executeUpdate(chain, statement);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        doExecute(sql, statement);
        return super.statement_executeUpdate(chain, statement, sql, autoGeneratedKeys);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        doExecute(sql, statement);
        return super.statement_executeUpdate(chain, statement, sql, columnIndexes);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        doExecute(sql, statement);
        return super.statement_executeUpdate(chain, statement, sql, columnNames);
    }

    @Override
    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql) throws SQLException {

        doExecute(sql, statement);
        return super.statement_executeUpdate(chain, statement, sql);
    }

    private void doExecute(String sql, Statement statement) {
        try {
            String actionValue = ThreadContext.get(ContextConstant.EXECUTE_ACTION);
            if(!ContextConstant.VALUE_DO_DELETE.equals(actionValue)) {
                return;
            }
            /**
             * 针对T_Document的操作不进行记录操作
             * removeDocumentHead
             */
            if(sql.contains("INSERT INTO sys_deletion_logs")) {
                return;
            }

            String userId = ThreadContext.get(ContextConstant.REQ_USER_ID);
            String orgId = ThreadContext.get(ContextConstant.REQ_ORG_ID);
            String url = ThreadContext.get(ContextConstant.REQ_URI);


            DataSource defaultSource = SpringApplicationContextUtil.getBean(DataSource.class);
            try (Connection connection = defaultSource.getConnection()) {
                try (PreparedStatement log = connection.prepareStatement(
                        "INSERT INTO sys_deletion_logs(user_id,org_id,url,business_id, track_id,content)VALUES(?,?,?,?,?,?)"
                )) {
                    log.setString(1, userId);
                    log.setString(2, orgId);
                    log.setString(3, url);
                    String businessId = ThreadContext.get(ContextConstant.BUSINESS_ID);
                    if(StringUtil.isBlank(businessId)) {
                        businessId = "#1";
                    }

                    log.setString(4, businessId);
                    String trackId = ThreadContext.get(ContextConstant.LOG_TRACE_ID);
                    if(StringUtil.isBlank(trackId)) {
                        trackId = "#1";
                    }

                    log.setString(5, trackId);
                    log.setString(6, sql);

                    log.executeUpdate();
                }
            }
        } catch (Exception ex) {
            logger.error("拦截删除数据({})发生异常", sql);
        }
    }
}
