package cn.myapps.common.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/**
 * Data package, usually use in the list.
 */
public class DataPackage<E> implements Serializable {
	private static final long serialVersionUID = -3847321538691386074L;
	/**
	 * 总行数
	 */
	public int rowCount;
	/**
	 * 每页显示的行数
	 */
	public int linesPerPage;
	/**
	 * 页码
	 */
	public int pageNo;
	/**
	 * 当前页数据集
	 */
	public Collection<E> datas;

	public DataPackage() {
		this.datas = new ArrayList<>();
	}

	/**
	 * Gets 当前页数据集
	 *
	 * @return Returns the datas.
	 */
	public Collection<E> getDatas() {
		if (datas == null) {
			datas = new ArrayList<E>();
		}

		return datas;
	}

	/**
	 * Set当前页数据集
	 *
	 * @param datas The datas to set.
	 */
	public void setDatas(Collection<E> datas) {
		this.datas = datas;
	}

	/**
	 * Gets 每页显示的行数
	 *
	 * @return Returns the linesPerPage.
	 */
	public int getLinesPerPage() {
		return linesPerPage;
	}

	/**
	 * Set 每页显示的行数
	 *
	 * @param linesPerPage The linesPerPage to set.
	 */
	public void setLinesPerPage(int linesPerPage) {
		this.linesPerPage = linesPerPage;
	}

	/**
	 * Gets 页码
	 *
	 * @return Returns the pageNo.
	 */
	public int getPageNo() {
		return pageNo;
	}

	/**
	 * Set 页码
	 *
	 * @param pageNo The pageNo to set.
	 */
	public void setPageNo(int pageNo) {
		this.pageNo = pageNo;
	}

	/**
	 * Gets 总行数
	 *
	 * @return Returns the rowCount.
	 */
	public int getRowCount() {
		return rowCount;
	}

	/**
	 * Set 总行数
	 *
	 * @param rowCount The rowCount to set.
	 */
	public void setRowCount(int rowCount) {
		this.rowCount = rowCount;
	}

	/**
	 * Gets 总页数
	 *
	 * @return The total page number.
	 */
	public int getPageCount() {
		return (int) Math.ceil((double) rowCount / (double) linesPerPage);
	}
}
