package cn.myapps.common.constant;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public class EnvironmentVariable {
	
	/**
     * 储存文件的根目录
     */
	public static String WORKSPACE_ROOT_PATH = null;
	
	static {
		// 初始化时在classpath目录的data目录下找workspace目录，测试环境用。
		URL workSpaceUrl = Thread.currentThread().getContextClassLoader().getResource("data/workspace");
		if(workSpaceUrl != null) {
			try {
				//初始化workspace_root_path
				WORKSPACE_ROOT_PATH = workSpaceUrl.toURI().getPath();
			} catch (URISyntaxException e) {
				e.printStackTrace();
			}
		}else {
			//若文件夹不存在则自动建立
			try {
				//获取根目录
				URL rootUrl = Thread.currentThread().getContextClassLoader().getResource("");
				//建立文件夹
				Boolean result = new File(rootUrl.toURI().getPath() + "data/workspace").mkdirs();

				if(result) {
					//初始化workspace_root_path
					workSpaceUrl = Thread.currentThread().getContextClassLoader().getResource("data/workspace");
					WORKSPACE_ROOT_PATH = workSpaceUrl.toURI().getPath();
				}
			}catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

}
