package cn.myapps.common.auth;

public interface IUser {
	public static final String TYPE_BG_USER = "bg_User";// 后台用户
	
	/**
	 * 来访设备-个人电脑
	 */
	public static final int EQUIPMENT_PC = 0;
	/**
	 * 来访设备-手机
	 */
	public static final int EQUIPMENT_PHONE = 1;
	/**
	 * 来访设备-平板
	 */
	public static final int EQUIPMENT_PAD = 2;

	
	public String getId();

	public String getDomainid();

	public String getName();

	public String getDefaultDepartment();
	
	public boolean isDeveloper();
	
	public String getDefaultApplication();
	
	public boolean isDomainAdmin();
	
	public boolean isSuperAdmin();
	
	public String getAvatarUri();

	public String getTelephone();

	public String getLoginno();

	public IUser getSuperior();

	public int getStatus();

//	public IUser getEmployer();

	public String getProxyUserId();

	public String getSessionid();

	public boolean isAgent(String actorid, String flowid) throws Exception;

	public int getEquipment();

	public String getLowerDepartmentList() throws Exception;

	public String getCalendarType();

	public String getIndexCode();

	public void setDomainid(String domainid);

	public void setName(String string);

	public String getEmail();

	public String getType();

	public String getDeptlist() throws Exception;

	public String getRolelist() throws Exception;

	public String getRolelist(String applicationid) throws Exception;

	public void setId(String owner);

	public void setLoginpwd(String loginpwd);

	public void setEmail(String email);

	public void setSigns(String signs);

	public void setTelephone(String telephone);

	public String getLoginpwd();

	public String getSigns();

	public String getDdUserId();

	public boolean isRecordLog();

	public void setRecordLog(boolean recordLog);
}
