package cn.myapps.common;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import cn.myapps.common.util.DefaultProperty;
import cn.myapps.common.util.PropertiesConfig;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.cache.ICacheProvider;
import cn.myapps.common.util.cache.IMyCache;
import cn.myapps.common.util.cache.MyCacheManager;
import org.springframework.util.StringUtils;

/**
 * The environment variable.
 */
public class Environment implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7874636871392290110L;
	public final static String DESIGNER_APP_TYPE="designer";
	public final static String RUNTIME_APP_TYPE="runtime";
	private static String appType;
	public static void setAppType(String appType) {
		Environment.appType = appType;
	}

	public static boolean isDesigner() {
		if (!StringUtils.hasLength(appType)) {
			return false;
		}

		return DESIGNER_APP_TYPE.equals(appType);
	}

	public static boolean isRuntimeApp() {
		if (!StringUtils.hasLength(appType)) {
			return false;
		}

		return RUNTIME_APP_TYPE.equals(appType);
	}

	public static boolean isDesignTimCacheReadonlyMode() {
		return !isRuntimeApp();
	}

	private String _wcpath;

	private String _contextPath;

	private String encoding = "UTF-8";
	
	private String baseUrl;
	
	private static Object LOCK = new Object();
	
	/**
	 * 网卡mac地址
	 */
	private static String macAddress = null;
	
	private String contextPath;
	
	/**
	 * 正在执行流程提交事务的document
	 */
	public static Map<String,Boolean> documentsOnFlowCommiting = new ConcurrentHashMap<String, Boolean>();
	
	/**
	 * baselib.js公共变量MAP对象
	 */
	public static Map<?,?> GLOBAL_MAP = new HashMap<Object,Object>();
	
	public static String licenseType = "S.标准版";
	
	/**
	 * 应用软件模板workspace在文件系统中的目录位置
	 */
	private String workspaceRootPath = null;
	
	public String getWorkspaceRootPath() {
		return workspaceRootPath;
	}

	/**
	 * @return the encoding
	 */
	public String getEncoding() {
		return encoding;
	}

	/**
	 * @param encoding
	 *            the encoding to set
	 */
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	private static Environment env = null;
	
	public CdnConfig cdnConfig = null;

	public static Environment getInstance() {
		if (env == null) {
			env = new Environment();
		}

		return env;
	}

	private Environment() {
		super();
		this.cdnConfig = new CdnConfig();
		String  workRootPath  =  PropertyUtil.getPath()+"/workspace";
		this.workspaceRootPath = workRootPath;
		this._wcpath = PropertyUtil.getPath();
		PropertiesConfig config = SpringApplicationContextUtil.getBean("propertiesConfig");
		this.setContextPath(config.getContextPath());
	}

	/**
	 * @param wcpath
	 *            The web context path.
	 */
	public void setApplicationRealPath(String wcpath) {
		_wcpath = wcpath;
	}

	/**
	 * Retrieve the web context path.
	 * 
	 * @return The web context path.
	 */
	public String getApplicationRealPath() {
		return (_wcpath != null) ? _wcpath : "";
	}

	/**
	 * Retrieve the web context physicsal path.
	 * 
	 * @param path
	 *            The web path.
	 * @return The web context physicsal path.
	 */
	public String getRealPath(String path) {
		String realpath = (path != null) ? getApplicationRealPath() + path : "";
		realpath = realpath.replaceAll("\\\\", "/");

		return realpath;
	}

	/**
	 * Set request context path;
	 * 
	 * @param cpath
	 * @return
	 */
	public String setContextPath(String cpath) {
		return _contextPath = cpath;
	}

	public String getContextPath() {
		return _contextPath != null ? _contextPath : "/";
	}

	public String getContext(String uri) {
		if (getContextPath().equals("/")) {
			return uri;
		} else {
			return getContextPath() + uri;
		}
	}

	public String getBaseUrl() {
		return baseUrl;
	}

	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}
	
	public static void cleanPermissionMap(){
		synchronized (LOCK) {
			ICacheProvider provider = null;
			try {
				provider = MyCacheManager.getProviderInstance("cn.myapps.common.util.cache.EhcacheProvider");
				IMyCache iMyCache = provider.getCache("PERMISSIONS");
				provider.clearByCacheName("PERMISSIONS");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void cleanOperationMap(){
		synchronized (LOCK) {
			try {
				ICacheProvider provider = MyCacheManager.getProviderInstance("cn.myapps.common.util.cache.EhcacheProvider");
				IMyCache iMyCache = provider.getCache("OPERATIONS");
				provider.clearByCacheName("OPERATION");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static String getMACAddress() {
		if(macAddress !=null) return macAddress;
		try {
			StringBuffer sb = new StringBuffer();
			byte[] mac = getHardwareAddress(false,false);
			if(mac.length<=1){
				 mac = getHardwareAddress(false,true);
			}
			if(mac.length<=1){
				 mac = getHardwareAddress(true,false);
			}
			if(mac.length<=1){
				 mac = getHardwareAddress(true,true);
			}
			for (int i = 0; i < mac.length; i++) {

				int n = mac[i] & 0xFF << 8 | mac[i++] & 0xFF;
				String s = Integer.toString(n, 35);
				sb.append(s);
			}
			macAddress = "Z"+(sb.toString().toUpperCase());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return macAddress;
	}
	
	private static byte[] getHardwareAddress(boolean includeSoftEther,boolean abs) throws Exception{
		byte[] mac = new byte[]{0};
		Enumeration netInterfaces;
		InetAddress ia = null;
		netInterfaces = NetworkInterface.getNetworkInterfaces();
		 while (netInterfaces.hasMoreElements()) {
	            NetworkInterface ni = (NetworkInterface) netInterfaces
	                    .nextElement();
	            Enumeration nii = ni.getInetAddresses();
	            
	            while (nii.hasMoreElements()) {
	            	ia = (InetAddress) nii.nextElement();
	            	// 获得网络接口对象（即网卡），并得到mac地址，mac地址存在于一个byte数组中。
	            	NetworkInterface nf = NetworkInterface.getByInetAddress(ia);
	            	if(nf==null ||nf.getDisplayName()==null || (!includeSoftEther && (nf.getDisplayName().indexOf("VMware")!=-1
	            			||nf.getDisplayName().indexOf("Microsoft")!=-1))){
	            		continue;
	            	}
	            		
	            	if(nf.isVirtual()
	            			||nf.isLoopback()
	            			||nf.isPointToPoint()
	            			) continue;
	            	
	            	byte[] tempMac = nf.getHardwareAddress();
	            	
	            	if(tempMac==null)  continue;
	            	if(abs){
	            		if(new BigInteger(tempMac).abs().compareTo(new BigInteger(mac).abs())>=0){
		            		mac = tempMac;
		            	}
	            	}else{
	            		if(new BigInteger(tempMac).compareTo(new BigInteger(mac))>=0){
		            		mac = tempMac;
		            	}
	            	}
	            	
	            }
	        }
		 
		 return mac;
	}
	
	/**
	 * cdn配置信息
	 * 
	 * @author Happy
	 *
	 */
	public class CdnConfig implements Serializable{
		/**
		 * 
		 */
		private static final long serialVersionUID = 1958653666631573081L;

		/**
		 * 是否启用
		 */
		private boolean enable;
		
		/**
		 * 回源HOST
		 */
		private String sourceHost;
		
		/**
		 * 资源版本
		 */
		private String resVersion;

		public CdnConfig() {
			super();
			enable = "true".equalsIgnoreCase(DefaultProperty.getProperty("cdn.config.enable"));
			sourceHost = DefaultProperty.getProperty("cdn.config.sourceHost");
			resVersion = DefaultProperty.getProperty("cdn.config.resVersion");
		}

		public boolean isEnable() {
			return enable;
		}

		public String getSourceHost() {
			return sourceHost;
		}

		public String getResVersion() {
			return resVersion;
		}
	}
}
