package cn.myapps.common;

import java.util.List;

import cn.myapps.common.data.DataPackage;


/**
 * 设计时业务接口
 * @author Happy
 *
 * @param <T>
 */
public interface DesignTimeService<T> {

	/**
	 * 通过文件uri获取javabean对象
	 * @param uri
	 * 		uri，文件唯一标示
	 * @return
	 * @throws Exception
	 */
	public T findByUri(String uri) throws Exception;

	/**
	 * 通过对象id获取javabean对象
	 * @param id
	 * @return
	 * @throws Exception
	 */
	public T findById(String id) throws Exception;

	/**
	 * 持久化
	 * @param object
	 * @throws Exception
	 */
	public void save(T object) throws Exception;

	/**
	 * 保存或更新
	 * <p>如果对象已经持久化，则执行更新操作，否则执行创建操作</p>
	 * @param object
	 * @throws Exception
	 */
	public void saveOrUpdate(T object) throws Exception;

	/**
	 * 更新
	 * @param object
	 * @throws Exception
	 */
	public void update(T object) throws Exception;

	/**
	 * 删除文件
	 * @param id
	 * @throws Exception
	 */
	public void delete(String id) throws Exception;

	/**
	 * 批量删除文件
	 * @param ids
	 */
	public void delete(String[] ids) throws Exception;

	/**
	 * 查询符合条件的对象集合
	 * @param parentId
	 * 		上级对象
	 * @param name
	 * 		文件名关键字
	 * @param page
	 * 		当前页数
	 * @param lines
	 * 		每页行数
	 * @return
	 * @throws Exception
	 */
	public DataPackage<T> query(String parentId,String name,int page,int lines) throws Exception;

	/**
	 * 查询符合条件的对象集合
	 * @param parentId
	 * 		上级对象
	 * @param searchword
	 * 		文件名或者描述关键字
	 * @param page
	 * 		当前页数
	 * @param lines
	 * 		每页行数
	 * @return
	 * @throws Exception
	 */
	public DataPackage<T> queryByNameOrDescript(String parentId,String searchword,int page,int lines) throws Exception;

	/**
	 * 查询符合条件的对象集合
	 * @param parentId
	 * 		父id
	 * @param name 名称
	 *
	 * @param description  描述
	 * @param page
	 * 		当前页数
	 * @param lines
	 * 		每页行数
	 * @return
	 * @throws Exception
	 */
//	public DataPackage<T> queryByNameAndDescript(String parentId, String name,String description, int page, int lines) throws Exception;
	/**
	 * 查询符合条件的对象集合
	 * @param parentId
	 * 		父id
	 * @param name
	 * 		文件名关键字
	 * @return
	 * @throws Exception
	 */
	public List<T> list(String parentId,String name) throws Exception;


	/**
	 * 深度查询
	 * @param parentId
	 * @param fileSuffix
	 * @return
	 */

	public List<T> deepQueryAll(String parentId, String fileSuffix) throws Exception;
	/**
	 * 查询符合条件的对象集合
	 * @param parentId
	 * 		父id
	 * @param name
	 * 		文件名关键字
	 * @return
	 * @throws Exception
	 */
	public List<T> list(String parentId, String pathSuffix, String fileSuffix, String name) throws Exception;

	/**
	 * 根据名称获取直属下级
	 * @param id
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public List<T> getSubordinate(String id,String name) throws Exception;

	/**
	 * 根据名称获取直属下级 子类
	 * @param id
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public List<T> getSubordinateChildren(String id,String name) throws Exception;

	/**
	 * 根据上级id获取直属下级
	 * @param parentId
	 * @param name
	 * @return
	 * @throws Exception
	 */
	public List<T> getChildsByParentId(String parentId, String name) throws Exception;

	/**
	 * 根据上级id获取直属下级
	 * @param parentId
	 * @param name
	 * @param pathSuffix
	 * @param fileSuffix
	 * @return
	 * @throws Exception
	 */
	public List<T> getChildsByParentId(String parentId,String pathSuffix, String fileSuffix,String name) throws Exception ;

	List<T> queryAccurateByName(String parentId, String name) throws Exception;
}