package cn.myapps.common;

import cn.myapps.common.util.DbUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import cn.myapps.common.jdbcs.filters.DeleteInterceptorFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.sql.DataSource;
import java.util.Collections;
import java.util.Map;

public class DataSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactory.class);
    public static final String DRIVERCLASSNAME = "driverClassName";
    public static final String URL = "url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String VALIDATIONQUERY="validationQuery";

    public static DataSource create(Map<String, String> properties) {
        DataSource ds = null;
        String driver = properties.get(DRIVERCLASSNAME);
        String url = properties.get(URL);
        if (driver.contains("mysql")) {
            driver = "com.mysql.cj.jdbc.Driver";
            properties.put(DRIVERCLASSNAME, driver);

            url = url.replace("&serverTimezone=GMT%2B8", "");
            url = url.replace("&serverTimezone=GMT", "");
            url = url.replace("characterEncoding=UTF-8%2B8", "characterEncoding=UTF-8");
            url += "&serverTimezone=GMT%2B8";
            /**
             * 允许批量执行多条语句
             */
            if(!url.contains("allowMultiQueries")) {
                url += "&allowMultiQueries=true";
            }

            properties.put(URL, url);
        }

        /**
         * 连接池启动时创建的连接数量
         */
        properties.put("initialSize ", "1");
        /**
         * 连接池中的最小空闲连接数量
         */
        properties.put("minIdle ", "10");
        /**
         * 连接池中的最大连接数量
         */
        properties.put("maxActive", "10000");
        /**
         * 等待连接的最长时间（毫秒）
         */
        properties.put("maxWait", String.valueOf(60000));

        /**
         * 空闲连接被移除的最长时间
         */
        properties.put("minEvictableIdleTimeMillis", "300000");

        /**
         * https://developer.aliyun.com/article/1157595
         */
        properties.put("testWhileIdle", "true");
        /**
         * 检查空闲连接的时间间隔
         */
        properties.put("timeBetweenEvictionRunsMillis", "60000");
        properties.put("validationQuery", DbUtil.getValidationQuery(driver));

        properties.put("testOnBorrow", "false");
        properties.put("testOnReturn", "false");

        /**
         * https://github.com/alibaba/druid/wiki/%E8%BF%9E%E6%8E%A5%E6%B3%84%E6%BC%8F%E7%9B%91%E6%B5%8B
         * 连接泄露
         * 每10分钟检测一次
         */
        properties.put("removeAbandoned", "true");
        properties.put("removeAbandonedTimeout", "1800");
        properties.put("logAbandoned", "true");
        properties.put("maxPoolPreparedStatementPerConnectionSize", "200");
        try {
            DruidDataSource druidDataSource = (DruidDataSource) DruidDataSourceFactory.createDataSource(properties);
            druidDataSource.setProxyFilters(Collections.singletonList(DeleteInterceptorFilter.getInstance()));

            ds = druidDataSource;
        } catch (Exception e) {
            logger.error("初始化DataSource(url={})发生异常", url, e);
        }

        return ds;
    }
}
