/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util.cache;

import cn.myapps.common.util.cache.CacheConfig;
import cn.myapps.common.util.cache.ICacheProvider;
import cn.myapps.common.util.cache.MethodCacheConfig;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;

public class MyCacheManager {
    private static ConcurrentHashMap _applications = new ConcurrentHashMap();

    private MyCacheManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ICacheProvider getProviderInstance(String providerClassName) {
        ICacheProvider _application = (ICacheProvider)_applications.get(providerClassName);
        if (_application != null) return _application;
        Class<MyCacheManager> clazz = MyCacheManager.class;
        synchronized (MyCacheManager.class) {
            try {
                _application = (ICacheProvider)_applications.get(providerClassName);
                if (_application != null || providerClassName == null) return _application;
                Class<?> clazz2 = Class.forName(providerClassName);
                _application = (ICacheProvider)clazz2.newInstance();
                CacheConfig cconf = CacheConfig.getInstance();
                for (MethodCacheConfig value : cconf.getMethodCacheConfigs().values()) {
                    _application.createCache(value.signature, value.maxElementsInMemory, false, false, value.timeToIdleSeconds, value.timeToLiveSeconds);
                }
                _application.setClearedNames(cconf.getMethodCleaners());
                _applications.put(providerClassName, _application);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return _application;
        }
    }

    public static synchronized ICacheProvider getProviderInstance() {
        try {
            CacheConfig cconf = CacheConfig.getInstance();
            String providerClassName = cconf.getProviderClassName();
            return MyCacheManager.getProviderInstance(providerClassName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String buildCacheKeyString(Class<?> clazz, Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(clazz.getName()).append(".").append(method.getName()).append("(");
        Class<?>[] paramsTypes = method.getParameterTypes();
        for (int i = 0; i < paramsTypes.length; ++i) {
            sb.append(paramsTypes[i].getName());
            if (i >= paramsTypes.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String buildCacheKeyString(Method method) {
        StringBuffer sb = new StringBuffer();
        sb.append(method.getDeclaringClass().getName()).append(".").append(method.getName()).append("(");
        Class<?>[] paramsTypes = method.getParameterTypes();
        for (int i = 0; i < paramsTypes.length; ++i) {
            sb.append(paramsTypes[i].getName());
            if (i >= paramsTypes.length - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

