/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    private static Logger log = LoggerFactory.getLogger(StringUtil.class);

    public static String toString(int[] codePoints, int offset, int count) {
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (count < 0) {
            throw new StringIndexOutOfBoundsException(count);
        }
        if (offset > codePoints.length - count) {
            throw new StringIndexOutOfBoundsException(offset + count);
        }
        int expansion = 0;
        int margin = 1;
        char[] v = new char[count + margin];
        int x = offset;
        int j = 0;
        for (int i = 0; i < count; ++i) {
            int c;
            if ((c = codePoints[x++]) < 0) {
                throw new IllegalArgumentException();
            }
            if (margin <= 0 && j + 1 >= v.length) {
                if (expansion == 0) {
                    expansion = ((-margin + 1) * count << 10) / i;
                    if ((expansion >>= 10) <= 0) {
                        expansion = 1;
                    }
                } else {
                    expansion *= 2;
                }
                int newLen = Math.min(v.length + expansion, count * 2);
                margin = newLen - v.length - (count - i);
                char[] copy = new char[newLen];
                System.arraycopy(v, 0, copy, 0, Math.min(v.length, newLen));
                v = copy;
            }
            if (c < 65536) {
                v[j++] = (char)c;
                continue;
            }
            if (c <= 0x10FFFF) {
                int charOffset = c - 65536;
                v[j + 1] = (char)((charOffset & 0x3FF) + 56320);
                v[j] = (char)((charOffset >>> 10) + 55296);
                j += 2;
                --margin;
                continue;
            }
            throw new IllegalArgumentException();
        }
        return new String(v, 0, j);
    }

    public static int countMatches(String s, String sb) {
        if (s == null || sb == null) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = s.indexOf(sb, idx)) != -1) {
            ++count;
            idx += sb.length();
        }
        return count;
    }

    public static String left(String s, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        return s == null || s.length() <= len ? s : s.substring(0, len);
    }

    public static String right(String s, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Requested String length " + len + " is less than zero");
        }
        return s == null || s.length() <= len ? s : s.substring(s.length() - len);
    }

    public static String repeat(String s, int t) {
        StringBuffer buffer = new StringBuffer(t * s.length());
        for (int i = 0; i < t; ++i) {
            buffer.append(s);
        }
        return buffer.toString();
    }

    public static String rightPad(String s, int z) {
        return StringUtil.rightPad(s, z, " ");
    }

    public static String rightPad(String s, int z, String d) {
        if ((z = (z - s.length()) / d.length()) > 0) {
            s = s + StringUtil.repeat(d, z);
        }
        return s;
    }

    public static String leftPad(String s, int z) {
        return StringUtil.leftPad(s, z, " ");
    }

    public static String leftPad(String s, int z, String d) {
        if ((z = (z - s.length()) / d.length()) > 0) {
            s = StringUtil.repeat(d, z) + s;
        }
        return s;
    }

    public static String replaceOnce(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, 1);
    }

    public static String replace(String text, String repl, String with) {
        return StringUtil.replace(text, repl, with, -1);
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + repl.length();
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    public static String[] split(String str) {
        return StringUtil.split(str, null, -1);
    }

    public static String[] splitString(String str, String separator) {
        if (!StringUtil.isBlank(separator)) {
            StringBuffer buff = new StringBuffer();
            char[] sps = separator.toCharArray();
            for (int i = 0; i < sps.length; ++i) {
                char sp = sps[i];
                if ('$' == sp || '.' == sp || '^' == sp || '*' == sp || '(' == sp || ')' == sp || '+' == sp) {
                    buff.append("\\").append(sp);
                    continue;
                }
                if ('\\' == sp) {
                    buff.append("\\").append(sp);
                    continue;
                }
                buff.append(sp);
            }
            if (!StringUtil.isBlank(buff.toString())) {
                separator = buff.toString();
            }
        }
        return str.split(separator);
    }

    public static String[] split(String text, String separator) {
        return StringUtil.split(text, separator, -1);
    }

    public static String[] split(String text, char separator) {
        return StringUtil.split(text, String.valueOf(separator));
    }

    public static String[] split(String str, String separator, int max) {
        StringTokenizer tok = null;
        tok = separator == null ? new StringTokenizer(str) : new StringTokenizer(str, separator);
        int listSize = tok.countTokens();
        if (max > 0 && listSize > max) {
            listSize = max;
        }
        String[] list = new String[listSize];
        int i = 0;
        int lastTokenBegin = 0;
        int lastTokenEnd = 0;
        while (tok.hasMoreTokens()) {
            if (max > 0 && i == listSize - 1) {
                String endToken = tok.nextToken();
                lastTokenBegin = str.indexOf(endToken, lastTokenEnd);
                list[i] = str.substring(lastTokenBegin);
                break;
            }
            list[i] = tok.nextToken();
            lastTokenBegin = str.indexOf(list[i], lastTokenEnd);
            lastTokenEnd = lastTokenBegin + list[i].length();
            ++i;
        }
        return list;
    }

    public static boolean isBoolean(String s) {
        if (s == null || s.trim().length() == 0) {
            return false;
        }
        return Boolean.valueOf(s.trim());
    }

    public static boolean isNumber(String s) {
        int i;
        int start;
        if (s == null || s.length() == 0) {
            return false;
        }
        char[] chars = s.toCharArray();
        int sz = chars.length;
        boolean hasExp = false;
        boolean hasDecPoint = false;
        boolean allowSigns = false;
        boolean foundDigit = false;
        int n = start = chars[0] == '-' ? 1 : 0;
        if (sz > start + 1 && chars[start] == '0' && chars[start + 1] == 'x') {
            int i2 = start + 2;
            if (i2 == sz) {
                return false;
            }
            while (i2 < chars.length) {
                if (!(chars[i2] >= '0' && chars[i2] <= '9' || chars[i2] >= 'a' && chars[i2] <= 'f' || chars[i2] >= 'A' && chars[i2] <= 'F')) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        --sz;
        for (i = start; i < sz || i < sz + 1 && allowSigns && !foundDigit; ++i) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                foundDigit = true;
                allowSigns = false;
                continue;
            }
            if (chars[i] == '.') {
                if (hasDecPoint || hasExp) {
                    return false;
                }
                hasDecPoint = true;
                continue;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                if (hasExp) {
                    return false;
                }
                if (!foundDigit) {
                    return false;
                }
                hasExp = true;
                allowSigns = true;
                continue;
            }
            if (chars[i] == '+' || chars[i] == '-') {
                if (!allowSigns) {
                    return false;
                }
                allowSigns = false;
                foundDigit = false;
                continue;
            }
            return false;
        }
        if (i < chars.length) {
            if (chars[i] >= '0' && chars[i] <= '9') {
                return true;
            }
            if (chars[i] == 'e' || chars[i] == 'E') {
                return false;
            }
            if (!(allowSigns || chars[i] != 'd' && chars[i] != 'D' && chars[i] != 'f' && chars[i] != 'F')) {
                return foundDigit;
            }
            if (chars[i] == 'l' || chars[i] == 'L') {
                return foundDigit && !hasExp;
            }
        }
        return allowSigns && !foundDigit;
    }

    public static boolean isBlank(String s) {
        return StringUtils.isBlank((String)s);
    }

    public static String unite(String[] arr, String sp) {
        int index;
        if (arr == null) {
            return null;
        }
        if (arr.length == 0) {
            return "";
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (StringUtil.isBlank(arr[i])) continue;
            buff = buff.append(arr[i]);
            if (StringUtil.isBlank(sp)) continue;
            buff = buff.append(sp);
        }
        if (!StringUtil.isBlank(sp) && (index = buff.lastIndexOf(sp)) > 0) {
            buff = buff.deleteCharAt(index);
        }
        return buff.toString();
    }

    public static String unite(String[] arr) {
        return StringUtil.unite(arr, ";");
    }

    public static String unite(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        String[] _arr = new String[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            _arr[i] = arr[i] != null ? arr[i].toString() : "";
        }
        return StringUtil.unite(_arr, ";");
    }

    public static String chineseURLToUTF(String s, char sp) {
        String filename = new File(s).getName();
        String path = new File(s).getParent();
        path = path.replace('\\', sp);
        try {
            filename = URLEncoder.encode(filename, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        path = path + "/" + filename;
        return path;
    }

    public static String toGB2312(String s) throws Exception {
        if (s != null && s.length() > 0) {
            byte[] byteTmp = s.getBytes("ISO8859_1");
            s = new String(byteTmp, "GB2312");
        }
        return s;
    }

    public static String toUTF8(String s, String encoding) throws Exception {
        if (s != null && s.length() > 0) {
            byte[] byteTmp = s.getBytes(encoding);
            s = new String(byteTmp, "UTF-8");
        }
        return s;
    }

    public static String toBig5(String s) throws Exception {
        if (s != null && s.length() > 0) {
            byte[] byteTmp = s.getBytes("BIG5");
            s = new String(byteTmp, "GBK");
        }
        return s;
    }

    public static String to8859(String s) throws Exception {
        if (s != null && s.length() > 0) {
            byte[] byteTmp = s.getBytes("GB2312");
            s = new String(byteTmp, "8859_1");
        }
        return s;
    }

    public static String getHTMLString(String s) {
        if (s == null) {
            return "";
        }
        if (s.equals("")) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        char ch1 = '\n';
        int ch2 = 10;
        for (int i = 0; i < s.length(); ++i) {
            ch1 = s.charAt(i);
            if (ch1 == ' ' && i + 1 < s.length()) {
                ch2 = s.charAt(i + 1);
                if (ch2 == 32) {
                    buf.append("\u00a1\u00a1");
                    ++i;
                    continue;
                }
                buf.append(ch1);
                continue;
            }
            if (ch1 == '\n') {
                buf.append("<br>");
                continue;
            }
            if (ch1 == '\t') {
                buf.append("\u00a1\u00a1\u00a1\u00a1");
                continue;
            }
            buf.append(ch1);
        }
        return buf.toString();
    }

    public static String encodeHTML(String t) {
        if (t != null) {
            t = t.replaceAll("#", "%23");
            t = t.replaceAll("&", "&amp;");
            t = t.replaceAll("\"", "@quot;");
            t = t.replaceAll("<", "@lt;");
            t = t.replaceAll(">", "@gt;");
            t = t.replaceAll("'", "@#146;");
            t = t.replaceAll(" ", "@nbsp;");
            t = t.replaceAll("\u00a0", "@nbsp;");
            t = t.replaceAll("\r", "&#10;");
            t = t.replaceAll("\n", "&#13;");
        }
        return t;
    }

    public static String encodeHTMLForDialog(String t) {
        if (t != null) {
            t = t.replaceAll("#", "%23");
            t = t.replaceAll("&", "&amp;");
            t = t.replaceAll("\"", "@quot;");
            t = t.replaceAll("<", "@lt;");
            t = t.replaceAll(">", "@gt;");
            t = t.replaceAll("'", "@#146;");
            t = t.replaceAll(" ", "@nbsp;");
            t = t.replaceAll("\u00a0", "@nbsp;");
            t = t.replaceAll("\r", "");
            t = t.replaceAll("\n", "");
        }
        return t;
    }

    public static String dencodeHTML(String t) {
        if (t != null) {
            t = t.replaceAll("&amp;", "&");
            t = t.replaceAll("@amp;", "&");
            t = t.replaceAll("&quot;", "\"");
            t = t.replaceAll("@quot;", "\"");
            t = t.replaceAll("&lt;", "<");
            t = t.replaceAll("@lt;", "<");
            t = t.replaceAll("&gt;", ">");
            t = t.replaceAll("@gt;", ">");
            t = t.replaceAll("&#146;", "'");
            t = t.replaceAll("@#146;", "'");
            t = t.replaceAll("&nbsp;", " ");
            t = t.replaceAll("@nbsp;", " ");
            t = t.replaceAll("&#10;", "\r");
            t = t.replaceAll("&#13;", "\n");
            t = t.replaceAll("&#9;", " ");
            t = t.replaceAll("%23", "#");
            t = t.replaceAll("\n\r", "\n");
            t = t.replaceAll("\r\n", "\n");
        }
        return t;
    }

    public static boolean haveChinesewords(String str) throws Exception {
        return !StringUtil.toGB2312(str).equals(str);
    }

    public static String getSameString(String s1, String s2) {
        StringBuffer s = new StringBuffer();
        if (s1 == null || s1.trim().length() <= 0 || s2 == null || s2.trim().length() <= 0) {
            return s.toString();
        }
        int len = s1.length() > s2.length() ? s2.length() : s1.length();
        char[] c1 = s1.toCharArray();
        char[] c2 = s2.toCharArray();
        for (int i = 0; i < len && c1[i] == c2[i]; ++i) {
            s.append(c1[i]);
        }
        return s.toString();
    }

    public static String getFixLengthString(String str, int length) throws Exception {
        if (str == null || str.trim().length() < 0) {
            return StringUtil.getBlankString(length);
        }
        String reStr = "";
        str = str.replaceAll("\r", "");
        str = str.replaceAll("\n", "");
        reStr = (str = new String(str.getBytes(), "8859_1")).length() >= length ? str.substring(0, length) : str + StringUtil.getBlankString(length - str.length());
        byte[] bytesStr = reStr.getBytes("8859_1");
        reStr = new String(bytesStr, "gb2312");
        return reStr;
    }

    public static String getBlankString(int count) {
        StringBuffer str = new StringBuffer(0);
        for (int i = 0; i < count; ++i) {
            str.append(" ");
        }
        return str.toString();
    }

    public static String getXmlFileContent(File file) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(file);
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(doc.getXMLEncoding());
        xmlWriter.write(doc);
        log.debug("{}", (Object)("Encoding-->" + doc.getXMLEncoding()));
        String xmlStr = writer.toString();
        return xmlStr;
    }

    public static String toUTFBody(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = new byte[utflen];
        int i = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        return new String(bytearr, "UTF-8");
    }

    public static String URLEncode(String s, String enc) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, enc);
    }

    public static String URLDecode(String s, String enc) throws UnsupportedEncodingException {
        return URLDecoder.decode(s, enc);
    }

    private static void writeToFile(String fileName, String content) throws IOException {
        FilterOutputStream outStream = null;
        OutputStreamWriter writer = null;
        try {
            File dir;
            String dirPath = "";
            if (fileName.lastIndexOf("/") != -1) {
                dirPath = fileName.substring(0, fileName.lastIndexOf("/"));
            }
            if (!(dir = new File(dirPath)).exists() && !dir.mkdirs()) {
                throw new IOException("create directory '" + dirPath + "' failed!");
            }
            outStream = new BufferedOutputStream(new FileOutputStream(fileName, true));
            writer = new OutputStreamWriter(outStream);
            writer.write(content);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public static void printToFile(String fileName, String content) throws IOException {
        StringUtil.writeToFile(fileName, content);
    }

    public static void printlnToFile(String fileName, String content) throws IOException {
        StringUtil.writeToFile(fileName, content + "\n");
    }

    public static String replaceBlank(String str) {
        if (str != null) {
            Pattern p = Pattern.compile("\t|\r|\n");
            Matcher m = p.matcher(str);
            return m.replaceAll("").trim();
        }
        return null;
    }

    public static int parseInt(String text) {
        return Integer.parseInt(text);
    }

    public static long parseLong(String text) {
        return Long.parseLong(text);
    }

    public static double parseDouble(String text) {
        return Double.parseDouble(text);
    }

    public static String valueOf(double d) {
        if ((double)Math.round(d) - d == 0.0) {
            return String.valueOf((long)d);
        }
        return String.valueOf(d);
    }

    public static boolean specialSymbols(String value) {
        if (StringUtil.isBlank(value)) {
            return false;
        }
        String regex = "[`~!@#$^&*()+=|{}':;',\\[\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c'\u3002\uff0c\u3001\uff1f]";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        return matcher.find();
    }
}

