/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDateUtil {
    private static final Logger log = LoggerFactory.getLogger(SimpleDateUtil.class);

    public static String getDateStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String getDateStrC(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        if (date != null) {
            return format.format(date);
        }
        return "";
    }

    public static String getDateStrCompact(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String str = format.format(date);
        return str;
    }

    public static String getDateTimeStr(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (date != null) {
            return format.format(date);
        }
        return "";
    }

    public static String getDateTimeStrC(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
        if (date != null) {
            return format.format(date);
        }
        return "";
    }

    public static String getCurDateStr(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        return format.format(new Date());
    }

    public static Date parseDate(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.parse(s);
    }

    public static Date parseDate(String s, String f) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat(f);
        return format.parse(s);
    }

    public static Date parseDateC(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        return format.parse(s);
    }

    public static Date parseDateTime(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.parse(s);
    }

    public static Date parseDateTimeC(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
        return format.parse(s);
    }

    public static Date parseTime(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        return format.parse(s);
    }

    public static Date parseTimeC(String s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("HH\u65f6mm\u5206ss\u79d2");
        return format.parse(s);
    }

    public static int yearOfDate(Date s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String d = format.format(s);
        return Integer.parseInt(d.substring(0, 4));
    }

    public static int monthOfDate(Date s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String d = format.format(s);
        return Integer.parseInt(d.substring(5, 7));
    }

    public static int dayOfDate(Date s) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String d = format.format(s);
        return Integer.parseInt(d.substring(8, 10));
    }

    public static String getDateTimeStr(java.sql.Date date, double time) {
        String format = "yyyy-MM-dd";
        SimpleDateFormat sf = new SimpleDateFormat(format);
        String dateStr = sf.format(date);
        Double d = new Double(time);
        String timeStr = String.valueOf(d.intValue()) + ":00:00";
        return dateStr + " " + timeStr;
    }

    public static int diffDateM(Date sd, Date ed) throws ParseException {
        Calendar c_sd = Calendar.getInstance();
        Calendar c_ed = Calendar.getInstance();
        c_sd.setTime(sd);
        c_ed.setTime(ed);
        return (c_ed.get(1) - c_sd.get(1)) * 12 + c_ed.get(2) - c_sd.get(2) + 1;
    }

    public static int diffDateD(Date sd, Date ed) throws ParseException {
        return Math.round((float)(ed.getTime() - sd.getTime()) / 8.64E7f) + 1;
    }

    public static int diffDateM(int sym, int eym) throws ParseException {
        return (Math.round((float)eym / 100.0f) - Math.round((float)sym / 100.0f)) * 12 + (eym % 100 - sym % 100) + 1;
    }

    public static java.sql.Date getNextMonthFirstDate(java.sql.Date date) throws ParseException {
        GregorianCalendar scalendar = new GregorianCalendar();
        scalendar.setTime(date);
        ((Calendar)scalendar).add(2, 1);
        scalendar.set(5, 1);
        return new java.sql.Date(scalendar.getTime().getTime());
    }

    public static Date getNextMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static java.sql.Date getFrontDateByDayCount(java.sql.Date date, int dayCount) throws ParseException {
        GregorianCalendar scalendar = new GregorianCalendar();
        scalendar.setTime(date);
        ((Calendar)scalendar).add(5, -dayCount);
        return new java.sql.Date(scalendar.getTime().getTime());
    }

    public static Date getFirstDay(String year, String month) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.parse(year + "-" + month + "-1");
    }

    public static Date getFirstDay(int year, int month) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.parse(year + "-" + month + "-1");
    }

    public static Date getFirstDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return c.getTime();
    }

    public static Date getLastDay(String year, String month) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = format.parse(year + "-" + month + "-1");
        GregorianCalendar scalendar = new GregorianCalendar();
        scalendar.setTime(date);
        ((Calendar)scalendar).add(2, 1);
        ((Calendar)scalendar).add(5, -1);
        date = scalendar.getTime();
        return date;
    }

    public static Date getLastDay(int year, int month) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date date = format.parse(year + "-" + month + "-1");
        GregorianCalendar scalendar = new GregorianCalendar();
        scalendar.setTime(date);
        ((Calendar)scalendar).add(2, 1);
        ((Calendar)scalendar).add(5, -1);
        date = scalendar.getTime();
        return date;
    }

    public static Date getLastDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        c.roll(5, false);
        return c.getTime();
    }

    public static String getTodayStr() throws ParseException {
        Calendar calendar = Calendar.getInstance();
        return SimpleDateUtil.getDateStr(calendar.getTime());
    }

    public static Date getToday() {
        return new Date(System.currentTimeMillis());
    }

    public static String getTodayAndTime() {
        return new Timestamp(System.currentTimeMillis()).toString();
    }

    public static String getTodayC() throws ParseException {
        Calendar calendar = Calendar.getInstance();
        return SimpleDateUtil.getDateStrC(calendar.getTime());
    }

    public static int getThisYearMonth() throws ParseException {
        Calendar today = Calendar.getInstance();
        return today.get(1) * 100 + today.get(2) + 1;
    }

    public static int getYearMonth(Date date) throws ParseException {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1) * 100 + c.get(2) + 1;
    }

    public static int getDistinceYear(String beforedate, String afterdate) throws ParseException {
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd");
        int yearCount = 0;
        try {
            Date d1 = d.parse(beforedate);
            Date d2 = d.parse(afterdate);
            Calendar c1 = Calendar.getInstance();
            c1.setTime(d1);
            Calendar c2 = Calendar.getInstance();
            c2.setTime(d2);
            yearCount = c2.get(1) - c1.get(1);
        }
        catch (ParseException e) {
            log.debug("{}", (Object)"Date parse error!");
        }
        return yearCount;
    }

    public static long getDistinceMonth(String beforedate, String afterdate) throws ParseException {
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd");
        long monthCount = 0L;
        try {
            Date d1 = d.parse(beforedate);
            Date d2 = d.parse(afterdate);
            Calendar c1 = Calendar.getInstance();
            c1.setTime(d1);
            Calendar c2 = Calendar.getInstance();
            c2.setTime(d2);
            monthCount = (c2.get(1) - c1.get(1)) * 12 + c2.get(2) - c1.get(2);
        }
        catch (ParseException e) {
            log.debug("{}", (Object)"Date parse error!");
        }
        return monthCount;
    }

    public static long getDistinceDay(String beforedate, String afterdate) throws ParseException {
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd");
        long betweenDays = 0L;
        try {
            Date d1 = d.parse(beforedate);
            Date d2 = d.parse(afterdate);
            betweenDays = (d2.getTime() - d1.getTime()) / 86400000L;
        }
        catch (ParseException e) {
            log.debug("{}", (Object)"Date parse error!");
        }
        return betweenDays;
    }

    public static long getDistinceDay(Date beforedate, Date afterdate) throws ParseException {
        long dayCount = 0L;
        try {
            dayCount = (afterdate.getTime() - beforedate.getTime()) / 86400000L;
        }
        catch (Exception e) {
            log.debug("{}", (Object)"Date parse error!");
        }
        return dayCount;
    }

    public static long getDistinceDay(java.sql.Date beforedate, java.sql.Date afterdate) throws ParseException {
        long dayCount = 0L;
        try {
            Calendar c1 = Calendar.getInstance();
            Calendar c2 = Calendar.getInstance();
            c1.setTime(beforedate);
            c2.setTime(afterdate);
            if (c1.after(afterdate)) {
                c1 = c2;
                c2.setTime(beforedate);
            }
            int betweenYears = c2.get(1) - c1.get(1);
            dayCount = c2.get(6) - c1.get(6);
            for (int i = 0; i < betweenYears; ++i) {
                c1.set(1, c1.get(1) + 1);
                dayCount += (long)c1.getMaximum(6);
            }
        }
        catch (Exception e) {
            log.debug("{}", (Object)"Date parse error!");
        }
        return dayCount;
    }

    public static long getDistinceDay(String beforedate) throws ParseException {
        return SimpleDateUtil.getDistinceDay(beforedate, SimpleDateUtil.getTodayStr());
    }

    public static long getDistinceTime(String beforeDateTime, String afterDateTime) throws ParseException {
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long timeCount = 0L;
        try {
            Date d1 = d.parse(beforeDateTime);
            Date d2 = d.parse(afterDateTime);
            timeCount = (d2.getTime() - d1.getTime()) / 3600000L;
        }
        catch (ParseException e) {
            log.debug("{}", (Object)"Date parse error!");
            throw e;
        }
        return timeCount;
    }

    public static long getDistinceTime(String beforeDateTime) throws ParseException {
        return SimpleDateUtil.getDistinceTime(beforeDateTime, DateFormat.getDateInstance().format(new Timestamp(System.currentTimeMillis())));
    }

    public static long getDistinceMinute(String beforeDateTime, String afterDateTime) throws ParseException {
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long timeCount = 0L;
        try {
            Date d1 = d.parse(beforeDateTime);
            Date d2 = d.parse(afterDateTime);
            timeCount = (d2.getTime() - d1.getTime()) / 60000L;
        }
        catch (ParseException e) {
            log.debug("{}", (Object)"Date parse error!");
            throw e;
        }
        return timeCount;
    }

    public static long getDistinceMinute(String afterDateTime) throws ParseException {
        return SimpleDateUtil.getDistinceMinute(DateFormat.getDateInstance().format(new Timestamp(System.currentTimeMillis())), afterDateTime);
    }

    public static boolean isOvertime(String beforeDateTime, String timeCount) {
        boolean exceed = false;
        try {
            long count1 = Long.parseLong(timeCount);
            long count2 = SimpleDateUtil.getDistinceTime(beforeDateTime);
            if (count1 < count2) {
                exceed = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return exceed;
    }

    public static String getTimestamStr(Timestamp timestamp) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(timestamp);
    }

    public static String getTimeStr(Time time) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
        return format.format(time);
    }

    public static boolean isBeforeCheckDate(String checkdate, Date auditDate) throws ParseException {
        Date cd;
        try {
            cd = new Date(SimpleDateUtil.parseDate(checkdate).getTime());
        }
        catch (ParseException ex) {
            log.debug("{}", (Throwable)ex);
            return false;
        }
        return SimpleDateUtil.isBeforeCheckDate(cd, auditDate);
    }

    private static boolean isBeforeCheckDate(Date checkdate, Date auditDate) throws ParseException {
        return auditDate.before(checkdate);
    }

    public static String format(Date date, String formatText) throws Exception {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(formatText);
        return format.format(date);
    }

    public static int getDaysOfMonth(Date startdate, Date enddate, String month) throws Exception {
        Calendar cs = Calendar.getInstance();
        cs.setTime(startdate);
        Calendar ce = Calendar.getInstance();
        ce.setTime(enddate);
        int startmonth = cs.get(2) + 1;
        int endmonth = ce.get(2) + 1;
        int m = Integer.parseInt(month);
        Date ld = SimpleDateUtil.getLastDay(String.valueOf(cs.get(1)), month);
        Calendar c = Calendar.getInstance();
        c.setTime(ld);
        int day = c.get(5);
        if (startmonth < m && m < endmonth) {
            return day;
        }
        if (m == startmonth) {
            return day - cs.get(5);
        }
        if (m == endmonth) {
            return ce.get(5);
        }
        return 0;
    }

    public static int diffDateH(String beforeDateTime, String afterDateTime) throws ParseException {
        SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int HourCount = 0;
        try {
            Date d1 = d.parse(beforeDateTime);
            Date d2 = d.parse(afterDateTime);
            HourCount = Math.round((float)(d2.getTime() - d1.getTime()) / 8.64E7f * 100.0f) / 100;
        }
        catch (ParseException e) {
            log.debug("{}", (Object)"Date parse error!");
            throw e;
        }
        return HourCount;
    }

    public static Date getNextDateByYearCount(Date date, int yearCount) throws ParseException {
        Calendar scalendar = Calendar.getInstance();
        scalendar.setTime(date);
        scalendar.add(1, yearCount);
        return scalendar.getTime();
    }

    public static Date getNextDateByMonthCount(Date date, int monthCount) throws ParseException {
        Calendar scalendar = Calendar.getInstance();
        scalendar.setTime(date);
        scalendar.add(2, monthCount);
        return scalendar.getTime();
    }

    public static Date getNextDateByDayCount(Date date, int dayCount) throws ParseException {
        Calendar scalendar = Calendar.getInstance();
        scalendar.setTime(date);
        scalendar.add(5, dayCount);
        return scalendar.getTime();
    }

    public static Date getNextDateByMinuteCount(Date date, int minuteCount) throws ParseException {
        Calendar scalendar = Calendar.getInstance();
        scalendar.setTime(date);
        scalendar.add(12, minuteCount);
        return scalendar.getTime();
    }

    public static long getDiffTime(Date beforeTime, Date afterTime) {
        try {
            String beforeTimeStr = SimpleDateUtil.format(beforeTime, "HH:mm:ss");
            String afterTimeStr = SimpleDateUtil.format(afterTime, "HH:mm:ss");
            Date bTime = SimpleDateUtil.parseTime(beforeTimeStr);
            Date aTime = SimpleDateUtil.parseTime(afterTimeStr);
            long diff = aTime.getTime() - bTime.getTime();
            return diff;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static long getDiffDateTime(Date beforeTime, Date afterTime) {
        try {
            long diff = afterTime.getTime() - beforeTime.getTime();
            return diff;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean isDate(String s) {
        if (s == null || s.trim().length() == 0) {
            return false;
        }
        try {
            SimpleDateUtil.parseDate(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDateTime(String s) {
        if (s == null || s.trim().length() == 0) {
            return false;
        }
        try {
            SimpleDateUtil.parseDateTime(s);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

