/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util;

import cn.myapps.common.util.SequenceException;
import cn.myapps.common.util.StringUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.safehaus.uuid.UUIDGenerator;

public class SequenceGenerator {
    private static final int base = 100000;
    private static long millis = 0L;
    private static long counter = 0L;
    private static long old = 0L;
    private static Object obj = new Object();

    public static String getSequence() throws SequenceException {
        UUID uuid = UUID.randomUUID();
        StringBuilder sb = new StringBuilder();
        sb.append(SequenceGenerator.digits(uuid.getMostSignificantBits() >> 32, 8));
        sb.append(SequenceGenerator.digits(uuid.getMostSignificantBits() >> 16, 4));
        sb.append(SequenceGenerator.digits(uuid.getMostSignificantBits(), 4));
        sb.append(SequenceGenerator.digits(uuid.getLeastSignificantBits() >> 48, 4));
        sb.append(SequenceGenerator.digits(uuid.getLeastSignificantBits(), 12));
        return sb.toString();
    }

    public static String getDesignTimeSequence() throws SequenceException {
        UUID uuid = UUID.randomUUID();
        StringBuilder sb = new StringBuilder();
        sb.append(SequenceGenerator.digits(uuid.getMostSignificantBits() >> 32, 8));
        sb.append(SequenceGenerator.digits(uuid.getMostSignificantBits() >> 16, 4));
        sb.append(SequenceGenerator.digits(uuid.getMostSignificantBits(), 4));
        sb.append(SequenceGenerator.digits(uuid.getLeastSignificantBits() >> 48, 4));
        sb.append(SequenceGenerator.digits(uuid.getLeastSignificantBits(), 12));
        return "__" + sb.toString();
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Numbers.toString(hi | val & hi - 1L, Numbers.MAX_RADIX).substring(1);
    }

    public static synchronized String getLongSequence() throws SequenceException {
        UUIDGenerator gen = UUIDGenerator.getInstance();
        org.safehaus.uuid.UUID uuid = gen.generateTimeBasedUUID();
        String uuidStr = uuid.toString();
        String[] uuidParts = uuidStr.split("-");
        StringBuffer builder = new StringBuffer();
        builder.append(uuidParts[2]);
        builder.append("-");
        builder.append(uuidParts[1]);
        builder.append("-");
        builder.append(uuidParts[0]);
        builder.append("-");
        builder.append(uuidParts[3]);
        builder.append("-");
        builder.append(uuidParts[4]);
        return builder.toString();
    }

    public static synchronized String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }

    public static synchronized String getTimeSequence() throws SequenceException {
        long result = System.currentTimeMillis();
        if (result == millis) {
            if (++old >= 100000L) {
                throw new SequenceException("It had exceed the maxium sequence in this moment.");
            }
            result = millis * 100000L + old;
        } else {
            millis = result;
            result *= 100000L;
            old = 0L;
        }
        return result + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized long getSequenceTimes() {
        try {
            long rtn = System.currentTimeMillis();
            Object object = obj;
            synchronized (object) {
                while (rtn == counter) {
                    obj.wait(2L);
                    rtn = System.currentTimeMillis();
                }
            }
            counter = rtn;
            return rtn;
        }
        catch (Exception ie) {
            return System.currentTimeMillis();
        }
    }

    public static String getFileUUID(File file, String startWith) {
        UUIDGenerator gen = UUIDGenerator.getInstance();
        String fileName = file.toString();
        if (!StringUtil.isBlank(startWith)) {
            if (fileName.indexOf(startWith) != -1) {
                fileName = fileName.substring(fileName.indexOf(startWith));
                org.safehaus.uuid.UUID uuid = gen.generateNameBasedUUID(null, fileName);
                return uuid.toString();
            }
        } else {
            org.safehaus.uuid.UUID uuid = gen.generateNameBasedUUID(null, fileName);
            return uuid.toString();
        }
        return "";
    }

    static class Numbers {
        static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        static final Map<Character, Integer> digitMap = new HashMap<Character, Integer>();
        public static final int MAX_RADIX;
        public static final int MIN_RADIX = 2;

        Numbers() {
        }

        public static String toString(long i, int radix) {
            boolean negative;
            if (radix < 2 || radix > MAX_RADIX) {
                radix = 10;
            }
            if (radix == 10) {
                return Long.toString(i);
            }
            int size = 65;
            int charPos = 64;
            char[] buf = new char[65];
            boolean bl = negative = i < 0L;
            if (!negative) {
                i = -i;
            }
            while (i <= (long)(-radix)) {
                buf[charPos--] = digits[(int)(-(i % (long)radix))];
                i /= (long)radix;
            }
            buf[charPos] = digits[(int)(-i)];
            if (negative) {
                buf[--charPos] = 45;
            }
            return new String(buf, charPos, 65 - charPos);
        }

        static NumberFormatException forInputString(String s) {
            return new NumberFormatException("For input string: \"" + s + "\"");
        }

        public static long toNumber(String s, int radix) {
            if (s == null) {
                throw new NumberFormatException("null");
            }
            if (radix < 2) {
                throw new NumberFormatException("radix " + radix + " less than Numbers.MIN_RADIX");
            }
            if (radix > MAX_RADIX) {
                throw new NumberFormatException("radix " + radix + " greater than Numbers.MAX_RADIX");
            }
            long result = 0L;
            boolean negative = false;
            int i = 0;
            int len = s.length();
            long limit = -9223372036854775807L;
            if (len > 0) {
                char firstChar = s.charAt(0);
                if (firstChar < '0') {
                    if (firstChar == '-') {
                        negative = true;
                        limit = Long.MIN_VALUE;
                    } else if (firstChar != '+') {
                        throw Numbers.forInputString(s);
                    }
                    if (len == 1) {
                        throw Numbers.forInputString(s);
                    }
                    ++i;
                }
                long multmin = limit / (long)radix;
                while (i < len) {
                    Integer digit;
                    if ((digit = digitMap.get(Character.valueOf(s.charAt(i++)))) == null) {
                        throw Numbers.forInputString(s);
                    }
                    if (digit < 0) {
                        throw Numbers.forInputString(s);
                    }
                    if (result < multmin) {
                        throw Numbers.forInputString(s);
                    }
                    if ((result *= (long)radix) < limit + (long)digit.intValue()) {
                        throw Numbers.forInputString(s);
                    }
                    result -= (long)digit.intValue();
                }
            } else {
                throw Numbers.forInputString(s);
            }
            return negative ? result : -result;
        }

        static {
            for (int i = 0; i < digits.length; ++i) {
                digitMap.put(Character.valueOf(digits[i]), i);
            }
            MAX_RADIX = digits.length;
        }
    }
}

