/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util;

import cn.myapps.common.util.Blowfish;
import cn.myapps.common.util.StringUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.bcxin.web.commons.utils.RequestUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public class Security {
    public static final String ACCESS_TOKEN = "accessToken";
    public static final String DESIGNER_TOKEN = "designerToken";
    public static final String ADMIN_TOKEN = "adminToken";
    public static final String DEBUG_TOKEN = "debugToken";
    public static final String SECRET_KEY = "teemlink_obpm";
    private static final int EXPIRE_TIME_IN_SECONDS = 43200;
    public static final long REFRESH_TIME = 3600000L;
    private static final JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)"teemlink_obpm")).withIssuer("auth0").build();
    public static final String ENCRYPTION_BASE64 = "base64";
    private static Blowfish cipher = null;
    private static final String USER_INFO = "userInfo";
    private static final String AUTHENTICATION = "Authorization";
    private static final String BEARER_USER_ID = "BEARER_USER_ID";

    public static String encryptOld(String s) throws Exception {
        return StringUtil.left(Security.encodeToMD5(s), 30);
    }

    public static String getAdminIdFromToken(HttpServletRequest request) throws JWTVerificationException {
        String accessToken = RequestUtil.extractValue((HttpServletRequest)request, (String)ADMIN_TOKEN);
        if (!StringUtils.hasLength((String)accessToken)) {
            return RequestUtil.extractAclAdminAccountId((HttpServletRequest)request);
        }
        try {
            DecodedJWT jwt = verifier.verify(accessToken);
            String userId = jwt.getClaim("username").asString();
            return userId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getDesignerIdFromToken(HttpServletRequest request) throws JWTVerificationException {
        String accessToken = request.getParameter(DESIGNER_TOKEN);
        if (accessToken == null) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = request.getCookies()) {
                String name = cookie.getName();
                if (!DESIGNER_TOKEN.equals(name)) continue;
                accessToken = cookie.getValue();
            }
        }
        if (accessToken == null) {
            accessToken = request.getHeader(DESIGNER_TOKEN);
        }
        if (accessToken == null) {
            return null;
        }
        try {
            DecodedJWT jwt = verifier.verify(accessToken);
            String userId = jwt.getClaim("username").asString();
            return userId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long getDesignerExpiresAtFromToken(HttpServletRequest request) throws JWTVerificationException {
        String accessToken = request.getParameter(DESIGNER_TOKEN);
        if (accessToken == null) {
            accessToken = request.getHeader(DESIGNER_TOKEN);
        }
        if (accessToken == null) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = request.getCookies()) {
                String name = cookie.getName();
                if (!DESIGNER_TOKEN.equals(name)) continue;
                accessToken = cookie.getValue();
            }
        }
        if (accessToken == null) {
            return null;
        }
        DecodedJWT jwt = verifier.verify(accessToken);
        long expiresAt = jwt.getExpiresAt().getTime();
        return expiresAt;
    }

    public static String getUserIdFromToken(String token) throws JWTVerificationException {
        JWTVerifier xxx = JWT.require((Algorithm)Algorithm.HMAC256((String)SECRET_KEY)).withIssuer("auth0").acceptExpiresAt(1000000L).build();
        DecodedJWT jwt = xxx.verify(token);
        String userId = jwt.getClaim("username").asString();
        return userId;
    }

    public static String getUserIdFromTokenWithoutVerify(String token) throws JWTVerificationException {
        DecodedJWT jwt = verifier.verify(token);
        String userId = jwt.getClaim("username").asString();
        return userId;
    }

    public static String getUserInfoFromToken(String token) throws JWTVerificationException {
        DecodedJWT jwt = verifier.verify(token);
        String userInfo = jwt.getClaim(USER_INFO).asString();
        return userInfo;
    }

    public static String getUserIdFromToken(HttpServletRequest request) throws JWTVerificationException {
        String getUserIdFromTokenKey = "getUserIdFromToken";
        String userId = (String)request.getAttribute("getUserIdFromToken");
        if (userId == null) {
            String accessToken = Security.getTokenFromRequest(request);
            DecodedJWT jwt = verifier.verify(accessToken);
            userId = jwt.getClaim("username").asString();
            request.setAttribute("getUserIdFromToken", (Object)userId);
        }
        return userId;
    }

    public static void addAccessToken2ResponseCookie(ServletRequest request, ServletResponse response) {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        String accessToken = Security.getTokenFromRequest(servletRequest);
        Cookie cookie = new Cookie(ACCESS_TOKEN, accessToken);
        cookie.setPath("/");
        servletResponse.addCookie(cookie);
    }

    public static String getTokenFromRequest(HttpServletRequest request) {
        return Security.extractFieldFromRequest(request, ACCESS_TOKEN);
    }

    public static Long getUserExpiresAtFromToken(HttpServletRequest request) throws JWTVerificationException {
        String accessToken = request.getParameter(ACCESS_TOKEN);
        if (accessToken == null && (accessToken = request.getParameter("access_token")) == null) {
            accessToken = request.getHeader(ACCESS_TOKEN);
        }
        if (accessToken == null) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = request.getCookies()) {
                String name = cookie.getName();
                if (!ACCESS_TOKEN.equals(name)) continue;
                accessToken = cookie.getValue();
            }
        }
        if (accessToken == null) {
            return null;
        }
        DecodedJWT jwt = verifier.verify(accessToken);
        long expiresAt = jwt.getExpiresAt().getTime();
        return expiresAt;
    }

    public static Long getAdminExpiresAtFromToken(HttpServletRequest request) throws JWTVerificationException {
        Cookie[] cookies;
        String accessToken = request.getParameter(ADMIN_TOKEN);
        if (accessToken == null) {
            accessToken = request.getHeader(ACCESS_TOKEN);
        }
        if (accessToken == null && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                if (!ADMIN_TOKEN.equals(name)) continue;
                accessToken = cookie.getValue();
            }
        }
        if (accessToken == null) {
            return null;
        }
        DecodedJWT jwt = verifier.verify(accessToken);
        long expiresAt = jwt.getExpiresAt().getTime();
        return expiresAt;
    }

    public static Long getDebugUserExpiresAtFromToken(HttpServletRequest request) throws JWTVerificationException {
        String accessToken = request.getParameter(DEBUG_TOKEN);
        if (accessToken == null) {
            accessToken = request.getHeader(ACCESS_TOKEN);
        }
        if (accessToken == null) {
            Cookie[] cookies;
            for (Cookie cookie : cookies = request.getCookies()) {
                String name = cookie.getName();
                if (!DEBUG_TOKEN.equals(name)) continue;
                accessToken = cookie.getValue();
            }
        }
        if (accessToken == null) {
            return null;
        }
        DecodedJWT jwt = verifier.verify(accessToken);
        long expiresAt = jwt.getExpiresAt().getTime();
        return expiresAt;
    }

    public static String getDebugUserIdFromToken(HttpServletRequest request) throws JWTVerificationException {
        Cookie[] cookies;
        String accessToken = request.getParameter(DEBUG_TOKEN);
        if (accessToken == null && (accessToken = request.getParameter("access_token")) == null) {
            accessToken = request.getHeader(ACCESS_TOKEN);
        }
        if (accessToken == null && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                if (!DEBUG_TOKEN.equals(name)) continue;
                accessToken = cookie.getValue();
            }
        }
        if (accessToken == null) {
            return null;
        }
        DecodedJWT jwt = verifier.verify(accessToken);
        String userId = jwt.getClaim("username").asString();
        return userId;
    }

    public static String extractFieldFromRequest(HttpServletRequest request, String fieldName) {
        Cookie[] cookies;
        if (!StringUtils.hasLength((String)fieldName)) {
            return null;
        }
        String accessToken = request.getParameter(fieldName);
        if (accessToken == null && (accessToken = request.getParameter("access_token")) == null) {
            accessToken = request.getHeader(ACCESS_TOKEN);
        }
        if (accessToken == null && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                if (!fieldName.equals(name)) continue;
                accessToken = cookie.getValue();
            }
        }
        return accessToken;
    }

    public static void addFieldName2ResponseCookie(HttpServletResponse servletResponse, String fieldName, String value) {
        Cookie cookie = new Cookie(fieldName, value);
        cookie.setPath("/");
        servletResponse.addCookie(cookie);
    }

    public static String getToken(String userId) {
        return Security.getToken(userId, 43200);
    }

    public static String getToken(String userId, int expiresInSeconds) {
        String token = null;
        try {
            Date expiresAt = new Date(System.currentTimeMillis() + (long)(expiresInSeconds * 1000));
            token = JWT.create().withIssuer("auth0").withClaim("username", userId).withExpiresAt(expiresAt).sign(Algorithm.HMAC256((String)SECRET_KEY));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return token;
    }

    public static String getEmailToken(String userId, Date expiresAt) {
        String token = null;
        try {
            token = JWT.create().withIssuer("auth0").withClaim("username", userId).withExpiresAt(expiresAt).sign(Algorithm.HMAC256((String)SECRET_KEY));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return token;
    }

    public static String encodeToMD5(String s) throws NoSuchAlgorithmException {
        if (s == null) {
            return null;
        }
        StringBuffer digstr = new StringBuffer();
        MessageDigest MD = MessageDigest.getInstance("MD5");
        byte[] oldbyte = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            oldbyte[i] = (byte)s.charAt(i);
        }
        MD.update(oldbyte);
        byte[] newbyte = MD.digest(oldbyte);
        for (int i = 0; i < newbyte.length; ++i) {
            digstr.append(newbyte[i]);
        }
        return digstr.toString();
    }

    public static String encodeToBASE64(String s) {
        if (s == null) {
            return null;
        }
        return Security.encodeToBASE64(s.getBytes());
    }

    public static String encodeToBASE64(byte[] obj) {
        if (obj == null) {
            return null;
        }
        Base64.Encoder encoder = Base64.getEncoder();
        String encode = encoder.encodeToString(obj);
        return encode;
    }

    public static String decodeBASE64(String s) {
        if (s == null) {
            return null;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] buffer = decoder.decode(s);
        return new String(buffer);
    }

    public static String encryptPassword(String password) {
        if (password == null) {
            return null;
        }
        Blowfish cipher = Security.getCipher();
        if (cipher == null) {
            throw new UnsupportedOperationException();
        }
        return cipher.encryptString(password);
    }

    public static String decryptPassword(String encryptedPassword) {
        if (encryptedPassword == null) {
            return null;
        }
        Blowfish cipher = Security.getCipher();
        if (cipher == null) {
            throw new UnsupportedOperationException();
        }
        return cipher.decryptString(encryptedPassword);
    }

    private static synchronized Blowfish getCipher() {
        if (cipher != null) {
            return cipher;
        }
        try {
            String keyString = "obpm";
            if (keyString == null) {
                // empty if block
            }
            cipher = new Blowfish(keyString);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cipher;
    }

    public static byte[] hexStringToByte(String hex) {
        int len = hex.length() / 2;
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(Security.toByte(achar[pos]) << 4 | Security.toByte(achar[pos + 1]));
        }
        return result;
    }

    private static byte toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        for (int i = 0; i < bArray.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static String extractBearerUserId(HttpServletRequest request) {
        Object bearerUserId = request.getAttribute(BEARER_USER_ID);
        if (bearerUserId == null) {
            String authentication = request.getHeader(AUTHENTICATION);
            if (StringUtil.isBlank(authentication) || authentication.length() < 7) {
                bearerUserId = "";
            } else {
                String token = authentication.substring(7);
                bearerUserId = Security.getUserIdFromToken(token);
                request.setAttribute(BEARER_USER_ID, bearerUserId);
            }
        }
        return (String)bearerUserId;
    }
}

