/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.util;

import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
public class PropertiesConfig {
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    @Value(value="${myapps.storage.root}")
    private String storageroot;
    @Value(value="${spring.jpa.properties.hibernate.default_schema:}")
    private String defaultSchema;
    @Value(value="${server.port}")
    private int serverPort;
    @Value(value="${myapps.refresh.cache.monitor.types:}")
    private String[] refreshCacheMonitorTypes;
    @Value(value="${myapps.refresh.cache.profile:}")
    private String refreshCacheProfile;
    @Value(value="${myapps.ignored.count.query.timeout:false}")
    private boolean ignoredCountQueryTimeout;
    @Value(value="${myapps.ignored.count.cacahed.timeoutInSeconds:10}")
    private int cacheCountQueryInSeconds;

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getStorageroot() {
        File root = new File(this.storageroot);
        if (root.exists() && root.isDirectory()) {
            return this.storageroot;
        }
        this.storageroot = System.getProperty("user.dir") + File.separator + ".." + File.separator + "obpm-demo";
        return this.storageroot;
    }

    public void setStorageroot(String storageroot) {
        this.storageroot = storageroot;
    }

    public String[] getRefreshCacheMonitorTypes() {
        return this.refreshCacheMonitorTypes;
    }

    public boolean isIgnoredCountQueryTimeout() {
        return this.ignoredCountQueryTimeout;
    }

    public int getCacheCountQueryInSeconds() {
        return this.cacheCountQueryInSeconds;
    }

    public void setRefreshCacheMonitorTypes(String[] refreshCacheMonitorTypes) {
        this.refreshCacheMonitorTypes = refreshCacheMonitorTypes;
    }

    public boolean isRefreshCache(String type) {
        if (this.getRefreshCacheMonitorTypes() == null || this.getRefreshCacheMonitorTypes().length == 0) {
            return false;
        }
        return Arrays.stream(this.getRefreshCacheMonitorTypes()).collect(Collectors.toList()).contains(type);
    }

    public String getRefreshCacheProfile() {
        return this.refreshCacheProfile;
    }

    public void setRefreshCacheProfile(String refreshCacheProfile) {
        this.refreshCacheProfile = refreshCacheProfile;
    }

    public boolean isEnabledRefreshCached() {
        return StringUtils.hasLength((String)this.getRefreshCacheProfile());
    }
}

