/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.model.table;

import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.model.table.Column;
import cn.myapps.common.model.table.DuplicateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class Table {
    private String name;
    private String formName;
    private Collection<Column> columns = new ArrayList<Column>();

    public Table(String name) {
        this.name = name;
    }

    public Collection<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<Column> columns) {
        this.columns = columns;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public Column findColumn(String name) throws DuplicateException, OBPMValidateException {
        ArrayList<Column> tmp = new ArrayList<Column>();
        for (Column column : this.columns) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            tmp.add(column);
        }
        if (tmp.size() > 1) {
            Column column = (Column)tmp.get(0);
            throw new OBPMValidateException("(" + column.getFieldName() + ") {*[core.field.name.was.duplicate]*}", new DuplicateException("(" + column.getFieldName() + ") {*[core.field.name.was.duplicate]*}"));
        }
        if (tmp.size() > 0) {
            return (Column)tmp.get(0);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Table) {
            Table anTable = (Table)obj;
            if (this.getName().equalsIgnoreCase(anTable.getName())) {
                Iterator<Column> iterator = this.getColumns().iterator();
                while (iterator.hasNext()) {
                    try {
                        Column anColumn;
                        Column column = iterator.next();
                        if (column.equals(anColumn = anTable.findColumn(column.getName()))) continue;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                return true;
            }
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

