/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common.jdbcs.filters;

import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import com.alibaba.druid.filter.FilterAdapter;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteInterceptorFilter
extends FilterAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DeleteInterceptorFilter.class);
    private static DeleteInterceptorFilter singleton = null;

    public DeleteInterceptorFilter() {
        logger.error("\u6ce8\u518cDeleteInterceptorFilter");
    }

    public static synchronized DeleteInterceptorFilter getInstance() {
        if (singleton == null) {
            singleton = new DeleteInterceptorFilter();
        }
        return singleton;
    }

    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        this.doExecute(sql, (Statement)statement);
        return super.statement_execute(chain, statement, sql);
    }

    public boolean statement_execute(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        this.doExecute(sql, (Statement)statement);
        return super.statement_execute(chain, statement, sql, columnNames);
    }

    public boolean preparedStatement_execute(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        this.doExecute(statement.getSql(), (Statement)statement);
        return super.preparedStatement_execute(chain, statement);
    }

    public int preparedStatement_executeUpdate(FilterChain chain, PreparedStatementProxy statement) throws SQLException {
        this.doExecute(statement.getSql(), (Statement)statement);
        return super.preparedStatement_executeUpdate(chain, statement);
    }

    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int autoGeneratedKeys) throws SQLException {
        this.doExecute(sql, (Statement)statement);
        return super.statement_executeUpdate(chain, statement, sql, autoGeneratedKeys);
    }

    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, int[] columnIndexes) throws SQLException {
        this.doExecute(sql, (Statement)statement);
        return super.statement_executeUpdate(chain, statement, sql, columnIndexes);
    }

    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql, String[] columnNames) throws SQLException {
        this.doExecute(sql, (Statement)statement);
        return super.statement_executeUpdate(chain, statement, sql, columnNames);
    }

    public int statement_executeUpdate(FilterChain chain, StatementProxy statement, String sql) throws SQLException {
        this.doExecute(sql, (Statement)statement);
        return super.statement_executeUpdate(chain, statement, sql);
    }

    private void doExecute(String sql, Statement statement) {
        try {
            String actionValue = ThreadContext.get((String)"EXECUTE_ACTION");
            if (!"VALUE_DO_DELETE".equals(actionValue)) {
                return;
            }
            if (sql.contains("INSERT INTO sys_deletion_logs")) {
                return;
            }
            String userId = ThreadContext.get((String)"USER_ID");
            String orgId = ThreadContext.get((String)"ORG_ID");
            String url = ThreadContext.get((String)"URI");
            DataSource defaultSource = SpringApplicationContextUtil.getBean(DataSource.class);
            try (Connection connection = defaultSource.getConnection();
                 PreparedStatement log = connection.prepareStatement("INSERT INTO sys_deletion_logs(user_id,org_id,url,business_id, track_id,content)VALUES(?,?,?,?,?,?)");){
                log.setString(1, userId);
                log.setString(2, orgId);
                log.setString(3, url);
                String businessId = ThreadContext.get((String)"BUSINESS_ID");
                if (StringUtil.isBlank(businessId)) {
                    businessId = "#1";
                }
                log.setString(4, businessId);
                String trackId = ThreadContext.get((String)"LOG_TRACE_ID");
                if (StringUtil.isBlank(trackId)) {
                    trackId = "#1";
                }
                log.setString(5, trackId);
                log.setString(6, sql);
                log.executeUpdate();
            }
        }
        catch (Exception ex) {
            logger.error("\u62e6\u622a\u5220\u9664\u6570\u636e({})\u53d1\u751f\u5f02\u5e38", (Object)sql);
        }
    }
}

