/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common;

import cn.myapps.common.DesignTimeSerializable;
import cn.myapps.common.DesignTimeService;
import cn.myapps.common.Environment;
import cn.myapps.common.RunnableMeta;
import cn.myapps.common.adapters.DateAdapter;
import cn.myapps.common.util.StringUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.sql.Timestamp;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement
public abstract class FileSystemDesignTimeSerializable
implements DesignTimeSerializable,
Comparable<FileSystemDesignTimeSerializable>,
RunnableMeta {
    private static final Logger log = LoggerFactory.getLogger(FileSystemDesignTimeSerializable.class);
    @XmlAttribute
    private String id;
    @XmlTransient
    @JsonIgnore
    private String uri;
    @XmlElement
    private String name;
    @XmlTransient
    @JsonIgnore
    private FileSystemDesignTimeSerializable parent;
    @XmlElement
    @JsonIgnore
    private String parentId;
    @XmlElement
    @JsonIgnore
    private String applicationid;
    @XmlElement
    private String description;
    @XmlElement
    @XmlJavaTypeAdapter(value=DateAdapter.class)
    private Timestamp createdTime;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getUri() {
        if (StringUtils.isBlank((String)this.uri)) {
            if (this.getPath() == null) {
                return null;
            }
            this.uri = this.getPath() + "/" + this.name + "." + this.getFileSuffix();
        }
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getApplicationid() {
        return this.applicationid;
    }

    public void setApplicationid(String applicationid) {
        this.applicationid = applicationid;
    }

    @JsonIgnore
    public String getPath() {
        if (this.getParent() == null) {
            return null;
        }
        if (!StringUtil.isBlank(this.name)) {
            String newName;
            if (this.name.indexOf("/") > 0) {
                this.name = newName = this.name.replace("/", "=47");
            }
            if (this.name.indexOf("%") > 0) {
                this.name = newName = this.name.replace("%", "=37");
            }
        }
        if (this.getPathSuffix().equalsIgnoreCase("datasource") || this.getPathSuffix().equalsIgnoreCase("excelconfig") || this.getPathSuffix().equalsIgnoreCase("macro") || this.getPathSuffix().equalsIgnoreCase("widget") || this.getPathSuffix().equalsIgnoreCase("style") || this.getPathSuffix().equalsIgnoreCase("mulitlang") || this.getPathSuffix().equalsIgnoreCase("valid") || this.getPathSuffix().equalsIgnoreCase("role") || this.getPathSuffix().equalsIgnoreCase("api") || this.getPathSuffix().equalsIgnoreCase("apigroup") || this.getPathSuffix().equalsIgnoreCase("kmRole") || this.getPathSuffix().equalsIgnoreCase("eipconfig")) {
            File file = new File(Environment.getInstance().getWorkspaceRootPath() + this.getParent().getPath() + "/" + this.name + "." + this.getPathSuffix());
            if (file.exists() && file.isDirectory()) {
                return this.getParent().getPath() + "/" + this.name + "." + this.getPathSuffix();
            }
            return this.getParent().getPath();
        }
        return this.getParent().getPath() + "/" + this.name + "." + this.getPathSuffix();
    }

    @JsonIgnore
    public FileSystemDesignTimeSerializable getParent() {
        if (this.parent == null && !StringUtils.isBlank((String)this.parentId)) {
            try {
                this.parent = (FileSystemDesignTimeSerializable)this.getParentService().findById(this.parentId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.parent;
    }

    public void setParent(FileSystemDesignTimeSerializable parent) {
        this.parent = parent;
        this.parentId = parent != null ? parent.getId() : null;
    }

    public String getName() {
        String newName;
        if (!StringUtil.isBlank(this.name) && this.name.indexOf("=47") > 0) {
            newName = this.name.replace("=47", "/");
            if (!StringUtil.isBlank(this.uri)) {
                this.uri = this.uri.replace(this.name, newName);
            }
            this.name = newName;
        }
        if (!StringUtil.isBlank(this.name) && this.name.indexOf("=37") > 0) {
            newName = this.name.replace("=37", "%");
            if (!StringUtil.isBlank(this.uri)) {
                this.uri = this.uri.replace(this.name, newName);
            }
            this.name = newName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        if (this.getPath() == null) {
            return;
        }
        this.uri = this.getPath() + "/" + this.name + "." + this.getFileSuffix();
    }

    @JsonIgnore
    protected abstract DesignTimeService<?> getParentService();

    @JsonIgnore
    public abstract String getPathSuffix();

    @JsonIgnore
    public abstract String getFileSuffix();

    public int hashCode() {
        if (!StringUtil.isBlank(this.getId())) {
            return this.getId().hashCode();
        }
        return (int)Math.random();
    }

    @Override
    public int compareTo(FileSystemDesignTimeSerializable o) {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileSystemDesignTimeSerializable) {
            FileSystemDesignTimeSerializable fss = (FileSystemDesignTimeSerializable)obj;
            return this.getId().equals(fss.getId());
        }
        return false;
    }

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }
}

