/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common;

import cn.myapps.common.util.DefaultProperty;
import cn.myapps.common.util.PropertiesConfig;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.cache.ICacheProvider;
import cn.myapps.common.util.cache.IMyCache;
import cn.myapps.common.util.cache.MyCacheManager;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.StringUtils;

public class Environment
implements Serializable {
    private static final long serialVersionUID = 7874636871392290110L;
    public static final String DESIGNER_APP_TYPE = "designer";
    public static final String RUNTIME_APP_TYPE = "runtime";
    private static String appType;
    private String _wcpath;
    private String _contextPath;
    private String encoding = "UTF-8";
    private String baseUrl;
    private static Object LOCK;
    private static String macAddress;
    private String contextPath;
    public static Map<String, Boolean> documentsOnFlowCommiting;
    public static Map<?, ?> GLOBAL_MAP;
    public static String licenseType;
    private String workspaceRootPath = null;
    private static Environment env;
    public CdnConfig cdnConfig = new CdnConfig();

    public static void setAppType(String appType) {
        Environment.appType = appType;
    }

    public static boolean isDesigner() {
        if (!StringUtils.hasLength((String)appType)) {
            return false;
        }
        return DESIGNER_APP_TYPE.equals(appType);
    }

    public static boolean isRuntimeApp() {
        if (!StringUtils.hasLength((String)appType)) {
            return false;
        }
        return RUNTIME_APP_TYPE.equals(appType);
    }

    public static boolean isDesignTimCacheReadonlyMode() {
        return !Environment.isRuntimeApp();
    }

    public String getWorkspaceRootPath() {
        return this.workspaceRootPath;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public static Environment getInstance() {
        if (env == null) {
            env = new Environment();
        }
        return env;
    }

    private Environment() {
        String workRootPath;
        this.workspaceRootPath = workRootPath = PropertyUtil.getPath() + "/workspace";
        this._wcpath = PropertyUtil.getPath();
        PropertiesConfig config = (PropertiesConfig)SpringApplicationContextUtil.getBean("propertiesConfig");
        this.setContextPath(config.getContextPath());
    }

    public void setApplicationRealPath(String wcpath) {
        this._wcpath = wcpath;
    }

    public String getApplicationRealPath() {
        return this._wcpath != null ? this._wcpath : "";
    }

    public String getRealPath(String path) {
        String realpath = path != null ? this.getApplicationRealPath() + path : "";
        realpath = realpath.replaceAll("\\\\", "/");
        return realpath;
    }

    public String setContextPath(String cpath) {
        this._contextPath = cpath;
        return this._contextPath;
    }

    public String getContextPath() {
        return this._contextPath != null ? this._contextPath : "/";
    }

    public String getContext(String uri) {
        if (this.getContextPath().equals("/")) {
            return uri;
        }
        return this.getContextPath() + uri;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanPermissionMap() {
        Object object = LOCK;
        synchronized (object) {
            ICacheProvider provider = null;
            try {
                provider = MyCacheManager.getProviderInstance("cn.myapps.common.util.cache.EhcacheProvider");
                IMyCache iMyCache = provider.getCache("PERMISSIONS");
                provider.clearByCacheName("PERMISSIONS");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanOperationMap() {
        Object object = LOCK;
        synchronized (object) {
            try {
                ICacheProvider provider = MyCacheManager.getProviderInstance("cn.myapps.common.util.cache.EhcacheProvider");
                IMyCache iMyCache = provider.getCache("OPERATIONS");
                provider.clearByCacheName("OPERATION");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getMACAddress() {
        if (macAddress != null) {
            return macAddress;
        }
        try {
            StringBuffer sb = new StringBuffer();
            byte[] mac = Environment.getHardwareAddress(false, false);
            if (mac.length <= 1) {
                mac = Environment.getHardwareAddress(false, true);
            }
            if (mac.length <= 1) {
                mac = Environment.getHardwareAddress(true, false);
            }
            if (mac.length <= 1) {
                mac = Environment.getHardwareAddress(true, true);
            }
            for (int i = 0; i < mac.length; ++i) {
                int n = mac[i] & 0xFF00 | mac[i++] & 0xFF;
                String s = Integer.toString(n, 35);
                sb.append(s);
            }
            macAddress = "Z" + sb.toString().toUpperCase();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return macAddress;
    }

    private static byte[] getHardwareAddress(boolean includeSoftEther, boolean abs) throws Exception {
        byte[] mac = new byte[]{0};
        InetAddress ia = null;
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> nii = ni.getInetAddresses();
            while (nii.hasMoreElements()) {
                byte[] tempMac;
                ia = nii.nextElement();
                NetworkInterface nf = NetworkInterface.getByInetAddress(ia);
                if (nf == null || nf.getDisplayName() == null || !includeSoftEther && (nf.getDisplayName().indexOf("VMware") != -1 || nf.getDisplayName().indexOf("Microsoft") != -1) || nf.isVirtual() || nf.isLoopback() || nf.isPointToPoint() || (tempMac = nf.getHardwareAddress()) == null) continue;
                if (abs) {
                    if (new BigInteger(tempMac).abs().compareTo(new BigInteger(mac).abs()) < 0) continue;
                    mac = tempMac;
                    continue;
                }
                if (new BigInteger(tempMac).compareTo(new BigInteger(mac)) < 0) continue;
                mac = tempMac;
            }
        }
        return mac;
    }

    static {
        LOCK = new Object();
        macAddress = null;
        documentsOnFlowCommiting = new ConcurrentHashMap<String, Boolean>();
        GLOBAL_MAP = new HashMap();
        licenseType = "S.\u6807\u51c6\u7248";
        env = null;
    }

    public class CdnConfig
    implements Serializable {
        private static final long serialVersionUID = 1958653666631573081L;
        private boolean enable = "true".equalsIgnoreCase(DefaultProperty.getProperty("cdn.config.enable"));
        private String sourceHost = DefaultProperty.getProperty("cdn.config.sourceHost");
        private String resVersion = DefaultProperty.getProperty("cdn.config.resVersion");

        public boolean isEnable() {
            return this.enable;
        }

        public String getSourceHost() {
            return this.sourceHost;
        }

        public String getResVersion() {
            return this.resVersion;
        }
    }
}

