/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.common;

import cn.myapps.common.jdbcs.filters.DeleteInterceptorFilter;
import cn.myapps.common.util.DbUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidDataSourceFactory;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceFactory.class);
    public static final String DRIVERCLASSNAME = "driverClassName";
    public static final String URL = "url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String VALIDATIONQUERY = "validationQuery";

    public static DataSource create(Map<String, String> properties) {
        DruidDataSource ds = null;
        String driver = properties.get(DRIVERCLASSNAME);
        String url = properties.get(URL);
        if (driver.contains("mysql")) {
            driver = "com.mysql.cj.jdbc.Driver";
            properties.put(DRIVERCLASSNAME, driver);
            url = url.replace("&serverTimezone=GMT%2B8", "");
            url = url.replace("&serverTimezone=GMT", "");
            url = url.replace("characterEncoding=UTF-8%2B8", "characterEncoding=UTF-8");
            url = url + "&serverTimezone=GMT%2B8";
            if (!url.contains("allowMultiQueries")) {
                url = url + "&allowMultiQueries=true";
            }
            properties.put(URL, url);
        }
        properties.put("initialSize ", "1");
        properties.put("minIdle ", "10");
        properties.put("maxActive", "10000");
        properties.put("maxWait", String.valueOf(60000));
        properties.put("minEvictableIdleTimeMillis", "300000");
        properties.put("testWhileIdle", "true");
        properties.put("timeBetweenEvictionRunsMillis", "60000");
        properties.put(VALIDATIONQUERY, DbUtil.getValidationQuery(driver));
        properties.put("testOnBorrow", "false");
        properties.put("testOnReturn", "false");
        properties.put("removeAbandoned", "true");
        properties.put("removeAbandonedTimeout", "1800");
        properties.put("logAbandoned", "true");
        properties.put("maxPoolPreparedStatementPerConnectionSize", "200");
        try {
            DruidDataSource druidDataSource = (DruidDataSource)DruidDataSourceFactory.createDataSource(properties);
            druidDataSource.setProxyFilters(Collections.singletonList(DeleteInterceptorFilter.getInstance()));
            ds = druidDataSource;
        }
        catch (Exception e) {
            logger.error("\u521d\u59cb\u5316DataSource(url={})\u53d1\u751f\u5f02\u5e38", (Object)url, (Object)e);
        }
        return ds;
    }
}

