package com.bcxin.tenant.backend.tasks;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.domain.entities.*;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.enums.EventProcessedStatus;
import com.bcxin.tenant.domain.repositories.DepartmentRepository;
import com.bcxin.tenant.domain.repositories.EmployeeRepository;
import com.bcxin.tenant.domain.repositories.OrganizationRepository;
import com.bcxin.tenant.domain.repositories.TenantEventRepository;
import com.bcxin.tenant.domain.snapshots.TenantUserCreatedSnapshot;
import com.bcxin.tenant.domain.v5.dispatches.DataDispatcher;
import com.bcxin.tenant.domain.v5.dispatches.requests.DepartDispatchRequest;
import com.bcxin.tenant.domain.v5.dispatches.requests.DispatchType;
import com.bcxin.tenant.domain.v5.dispatches.requests.DomainDispatchRequest;
import com.bcxin.tenant.domain.v5.dispatches.requests.UserDispatchRequest;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.DepartValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.DomainValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.UserValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.ValueRemovedSnapshot;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

@Component
public class V5TenantEventSyncTask extends TaskAbstract {
    private final TenantEventRepository tenantEventRepository;
    private final EmployeeRepository employeeRepository;
    private final DepartmentRepository departmentRepository;
    private final OrganizationRepository organizationRepository;
    private final JsonProvider jsonProvider;
    private final DataDispatcher dataDispatcher;
    private final UnitWork unitWork;

    public V5TenantEventSyncTask(TenantEventRepository tenantEventRepository,
                                 EmployeeRepository employeeRepository,
                                 DepartmentRepository departmentRepository,
                                 OrganizationRepository organizationRepository,
                                 JsonProvider jsonProvider,
                                 DataDispatcher dataDispatcher, UnitWork unitWork) {
        this.tenantEventRepository = tenantEventRepository;
        this.employeeRepository = employeeRepository;
        this.departmentRepository = departmentRepository;
        this.organizationRepository = organizationRepository;
        this.jsonProvider = jsonProvider;
        this.dataDispatcher = dataDispatcher;
        this.unitWork = unitWork;
    }

    @Override
    protected void runCore() {

    }

    @Override
    public String getTaskName() {
        return "v5.data.exchange";
    }
}