package com.bcxin.tenant.backend.tasks;

import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.EventSubscribedActionLogRepository;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Collection;

@Component
public class DeleteEventSubscribedActionLogTask extends TaskAbstract{
    private final EventSubscribedActionLogRepository eventSubscribedActionLogRepository;
    private final TenantDbReader dbReader;

    public DeleteEventSubscribedActionLogTask(EventSubscribedActionLogRepository eventSubscribedActionLogRepository,
                                              TenantDbReader dbReader) {
        this.eventSubscribedActionLogRepository = eventSubscribedActionLogRepository;
        this.dbReader = dbReader;
    }

    @Override
    protected void runCore() {
        Collection<String> eventLogIds = null;
        int index = 0;
        do {
            if (index > 30) {
                return;
            }

            eventLogIds =
                    this.dbReader.queryCanBeDeletedEventSubscriberLogs(1000);
            this.eventSubscribedActionLogRepository.deleteByIds(eventLogIds);
            index++;
        } while (CollectionUtils.isEmpty(eventLogIds));
    }

    @Override
    public String getTaskName() {
        return "v5.deleted.event.subscribed.logs";
    }
}
