package com.bcxin.tenant.backend.components.handlers.impls;

import com.bcxin.Infrastructures.UnitWork;
import com.bcxin.Infrastructures.components.JsonProvider;
import com.bcxin.Infrastructures.components.RetryProvider;
import com.bcxin.tenant.backend.components.extensions.DirectlyDataExchangeComponent;
import com.bcxin.tenant.domain.entities.EventSubscriberEntity;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.Infrastructures.enums.ProcessedStatus;
import com.bcxin.Infrastructures.enums.UserCheckedStatus;
import com.bcxin.Infrastructures.exceptions.NotFoundTenantException;
import com.bcxin.Infrastructures.utils.ExceptionUtil;
import com.bcxin.tenant.backend.components.handlers.SubscriberEventActionHandler;
import com.bcxin.tenant.domain.entities.*;
import com.bcxin.tenant.domain.enums.EventAction;
import com.bcxin.tenant.domain.readers.TenantDbReader;
import com.bcxin.tenant.domain.repositories.*;
import com.bcxin.tenant.domain.snapshots.TenantEmployeeSnapshot;
import com.bcxin.tenant.domain.utils.ExecuteUtils;
import com.bcxin.tenant.domain.v5.dispatches.DataDispatcher;
import com.bcxin.tenant.domain.v5.dispatches.requests.DepartDispatchRequest;
import com.bcxin.tenant.domain.v5.dispatches.requests.DispatchType;
import com.bcxin.tenant.domain.v5.dispatches.requests.DomainDispatchRequest;
import com.bcxin.tenant.domain.v5.dispatches.requests.UserDispatchRequest;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.DepartValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.DomainValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.UserValueSnapshot;
import com.bcxin.tenant.domain.v5.snapshots.dataexchanges.ValueRemovedSnapshot;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 分发到数据分发
 */
@Component
public class DataExchangeSubscriberEventActonHandlerImpl implements SubscriberEventActionHandler {
    private final TenantEventRepository tenantEventRepository;
    private final EmployeeRepository employeeRepository;
    private final DepartmentRepository departmentRepository;
    private final OrganizationRepository organizationRepository;
    private final JsonProvider jsonProvider;
    private final DataDispatcher dataDispatcher;
    private final UnitWork unitWork;
    private final EventSubscriberRepository subscriberRepository;
    private final EventSubscribedActionLogRepository eventSubscribedActionLogRepository;
    private final TenantDbReader dbReader;
    private final DirectlyDataExchangeComponent directlyDataExchangeComponent;
    private final RetryProvider retryProvider;

    public DataExchangeSubscriberEventActonHandlerImpl(TenantEventRepository tenantEventRepository,
                                                       EmployeeRepository employeeRepository,
                                                       DepartmentRepository departmentRepository,
                                                       OrganizationRepository organizationRepository,
                                                       JsonProvider jsonProvider, DataDispatcher dataDispatcher,
                                                       UnitWork unitWork,
                                                       EventSubscriberRepository subscriberRepository,
                                                       EventSubscribedActionLogRepository eventSubscribedActionLogRepository,
                                                       TenantDbReader dbReader,
                                                       DirectlyDataExchangeComponent directlyDataExchangeComponent,
                                                       RetryProvider retryProvider) {
        this.tenantEventRepository = tenantEventRepository;
        this.employeeRepository = employeeRepository;
        this.departmentRepository = departmentRepository;
        this.organizationRepository = organizationRepository;
        this.jsonProvider = jsonProvider;
        this.dataDispatcher = dataDispatcher;
        this.unitWork = unitWork;
        this.subscriberRepository = subscriberRepository;
        this.eventSubscribedActionLogRepository = eventSubscribedActionLogRepository;
        this.dbReader = dbReader;
        this.directlyDataExchangeComponent = directlyDataExchangeComponent;
        this.retryProvider = retryProvider;
    }

    @Override
    public void execute(EventSubscriberEntity subscriber,Collection<String> eventIds) {
        try {
            dispatchOrganizationData(subscriber, eventIds);
        } catch (Exception ex) {
            System.err.println("dispatchOrganizationData:");
            ex.printStackTrace();
        }

        try {
            dispatchDepartmentData(subscriber, eventIds);
        } catch (Exception ex) {
            System.err.println("dispatchDepartmentData:");
            ex.printStackTrace();
        }

        try {
            dispatchEmployeeData(subscriber, eventIds);
        } catch (Exception ex) {
            System.err.println("dispatchEmployeeData:");
            ex.printStackTrace();
        }
    }

    private static String getCheckStatusLabel(UserCheckedStatus checkedStatus) {
        switch (checkedStatus) {
            case None:
                return "未提交";
            case Commit:
                return "已提交";
            case Matched:
                return "已核验";
        }

        return "";
    }

    private static String getCredentialTypeLabel(CredentialType credentialType) {
        /*
        switch (credentialType) {
            case IdCard:
                return "居民身份证/户口簿";
            case IdCardOfXiangGang:
                return "香港特区护照/身份证";
            case IdCardOfAoMen:
                return "澳门特区护照/身份证明";
            case Passport:
                return "外国护照";
            case Arms:
                return "退伍军人证";
            case PoliceNo:
                return "警号";
        }

         */

        if (credentialType == null) {
            return "";
        }

        return String.valueOf(credentialType.ordinal());
    }

    private void dispatchEmployeeData(EventSubscriberEntity subscriber,Collection<String> eventIds) {
        Collection<String> mapKeys = Stream.of("EmployeeCreated","EmployeeEdited","EmployeeDeleted").collect(Collectors.toList());
        //Collection<String> mapKeys = Stream.of(subscriber.getSelector()).collect(Collectors.toList());
        if(!mapKeys.stream().anyMatch(ix->ix.equals(subscriber.getSelector()))) {
            return;
        }

        Collection<TenantEventEntity> tenantEvents = this.dbReader.getTopNTenantEvents(subscriber.getLastVersion(), mapKeys, eventIds,100);

        for (TenantEventEntity event : tenantEvents) {
            TenantEmployeeSnapshot snapshot = this.jsonProvider.toObject(TenantEmployeeSnapshot.class, event.getContent());
            /*
            if (event.getEventAction() == EventAction.EmployeeDeleted) {
                this.executeEventAction(event,subscriber, () -> {
                    this.dataDispatcher.dispatch(UserDispatchRequest.createDeleted(ValueRemovedSnapshot.create(snapshot.getEmployeeId())));
                });
                return;
            }
             */


            Optional<EmployeeEntity> employeeOptional = this.employeeRepository.findById(snapshot.getEmployeeId());
            this.executeEventAction(event,subscriber, () -> {
                if (!employeeOptional.isPresent()) {
                    throw new NotFoundTenantException(String.format("找不到该职员(%s)信息",snapshot.getEmployeeId()));
                }

                EmployeeEntity employee = employeeOptional.get();
                TenantUserEntity tenantUser = employee.getTenantUser();
                TenantUserCredentialsEntity userCredentials = tenantUser.getSelectedCredential();
                if(userCredentials==null && !CollectionUtils.isEmpty(tenantUser.getCredentials())) {
                    userCredentials = tenantUser.getCredentials().stream().findFirst().get();
                }
                String departId = null;
                if (employee.getDefaultDepartment() != null) {
                    departId = employee.getDefaultDepartment().getId();
                }
                String credentialType ="";
                String credentialNumber ="";
                String headPhoto = "";
                String frontPhoto = "";
                String reversePhoto = "";

                if(userCredentials!=null) {
                    credentialType = userCredentials.getCredentialType() == CredentialType.IdCard?"1":getCredentialTypeLabel(userCredentials.getCredentialType());
                    credentialNumber = userCredentials.getNumber();
                    headPhoto = userCredentials.getHeadPhoto();
                    frontPhoto = userCredentials.getFrontPhoto();
                    reversePhoto = userCredentials.getReversePhoto();
                }

                UserValueSnapshot userValueSnapshot =
                        UserValueSnapshot.create(employee.getId(), tenantUser.getName(), tenantUser.getTelephone(),
                                "", tenantUser.getTelephone(),
                                tenantUser.getEmail(),
                                credentialType,
                                credentialNumber,
                                getCheckStatusLabel(tenantUser.getCheckedStatus()),
                                headPhoto,
                                departId,
                                employee.getOrganization().getId(),
                                frontPhoto,
                                reversePhoto,
                                credentialNumber,
                                "",
                                0, Collections.singleton(departId),
                                "",
                                employee.getHiredDate(),
                                employee.getLeaveTime(),
                                employee.getOccupationType(),
                                employee.getStatus(),
                                employee.getDomainAdmin(),
                                Collections.EMPTY_MAP
                        );
                UserDispatchRequest userDispatchRequest = UserDispatchRequest.create(
                        event.getEventAction() == EventAction.EmployeeCreated ? DispatchType.Created : DispatchType.Edited, userValueSnapshot
                );

                this.directlyDataExchangeComponent.execute(userDispatchRequest);
               // this.dataDispatcher.dispatch(userDispatchRequest);
            });
        }
    }

    private void dispatchDepartmentData(EventSubscriberEntity subscriber,Collection<String> eventIds) {
        Collection<String> mapKeys = Stream.of("DepartmentCreated","DepartmentEdited","DepartmentDeleted").collect(Collectors.toList());
        if(!mapKeys.stream().anyMatch(ix->ix.equals(subscriber.getSelector()))) {
            return;
        }

        //Collection<String> mapKeys = Stream.of(subscriber.getSelector()).collect(Collectors.toList());
        Collection<TenantEventEntity> tenantEvents = this.dbReader.getTopNTenantEvents(subscriber.getLastVersion(), mapKeys, eventIds,100);
        for (TenantEventEntity event : tenantEvents) {
            String departId = event.getContent();
            /*
            if (event.getEventAction() == EventAction.DepartmentDeleted) {
                this.executeEventAction(event,subscriber, () -> {
                    this.dataDispatcher.dispatch(DepartDispatchRequest.create(DispatchType.Deleted, ValueRemovedSnapshot.create(departId)));
                });
                return;
            }

             */

            Optional<DepartmentEntity> departmentOptional = this.departmentRepository.findById(departId);

            this.executeEventAction(event,subscriber, () -> {
                if (!departmentOptional.isPresent()) {
                    throw new NotFoundTenantException(String.format("找不到该部门(%s)信息",departId));
                }
                DepartmentEntity department = departmentOptional.get();
                String parentId = null;
                String organizationId = null;
                if (department.getParent() != null) {
                    parentId = department.getParent().getId();
                }
                if (department.getOrganization() != null) {
                    organizationId = department.getOrganization().getId();
                }

                DepartDispatchRequest departDispatchRequest = DepartDispatchRequest.create(event.getEventAction() == EventAction.DepartmentCreated ? DispatchType.Created : DispatchType.Edited,
                        DepartValueSnapshot.create(
                                department.getId(),organizationId,department.getCode(),
                                department.getName(),
                                parentId, department.getDisplayOrder(),department.getIndexTree()));

                this.directlyDataExchangeComponent.execute(departDispatchRequest);
                //this.dataDispatcher.dispatch(departDispatchRequest);
            });
        }
    }

    private void dispatchOrganizationData(EventSubscriberEntity subscriber,Collection<String> eventIds) {
        Collection<String> mapKeys = Stream.of("OrganizationCreated","OrganizationEdited").collect(Collectors.toList());
        if(!mapKeys.stream().anyMatch(ix->ix.equals(subscriber.getSelector()))) {
            return;
        }
        //Collection<String> mapKeys = Stream.of(subscriber.getSelector()).collect(Collectors.toList());
        Collection<TenantEventEntity> tenantEvents = this.dbReader.getTopNTenantEvents(subscriber.getLastVersion(), mapKeys, eventIds,100);
        if (tenantEvents.size() == 0) {
            return;
        }

        for (TenantEventEntity event : tenantEvents) {
            String organId = event.getContent();
            if (event.getEventAction() == EventAction.OrganizationDeleted) {
                return;
            }
            Optional<OrganizationEntity> organizationOptional = this.organizationRepository.findById(organId);

            this.executeEventAction(event,subscriber, () -> {
                if (!organizationOptional.isPresent()) {
                    throw new NotFoundTenantException(String.format("找不到该企业(%s)信息", organId));
                }

                OrganizationEntity organization = organizationOptional.get();

                DomainDispatchRequest dispatchRequest =  DomainDispatchRequest.create(
                        event.getEventAction() == EventAction.OrganizationCreated ? DispatchType.Created : DispatchType.Edited,
                        DomainValueSnapshot.create(organization));
                this.directlyDataExchangeComponent.executeObpm2ToCydw(dispatchRequest);
                this.directlyDataExchangeComponent.execute(dispatchRequest);
                //this.dataDispatcher.dispatch(dispatchRequest);
            });
        }
    }

    private void executeEventAction(TenantEventEntity event, EventSubscriberEntity subscriber, Runnable runnable) {
        ExecuteUtils.executeTenantEventAction(event, subscriber, () -> {
            runnable.run();
        }, retryProvider, eventSubscribedActionLogRepository, subscriberRepository, tenantEventRepository, unitWork);
    }
}
