package com.bcxin.tenant.backend.components;

import cn.hutool.core.thread.ThreadUtil;
import com.bcxin.tenant.domain.entities.EventSubscriberEntity;
import com.bcxin.tenant.backend.components.handlers.impls.DataExchangeSubscriberEventActonHandlerImpl;
import com.bcxin.tenant.backend.components.handlers.impls.SmsSubscriberEventActionHandlerImpl;
import com.bcxin.tenant.backend.components.handlers.impls.SyncSubscriberEventActionHandlerImpl;
import com.bcxin.tenant.backend.constants.SubscriberHandlerNames;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.Collection;

/**
 * 让不同的订阅者来消费事件
 */
@Component
public class SubscriberEventActionComponent {
    private final DataExchangeSubscriberEventActonHandlerImpl dataExchangeSubscriberEventActonHandler;
    private final SmsSubscriberEventActionHandlerImpl smsSubscriberEventActionHandler;
    private final SyncSubscriberEventActionHandlerImpl syncSubscriberEventActionHandler;

    public SubscriberEventActionComponent(
            DataExchangeSubscriberEventActonHandlerImpl dataExchangeSubscriberEventActonHandler,
                                          SmsSubscriberEventActionHandlerImpl smsSubscriberEventActionHandler,
                                          SyncSubscriberEventActionHandlerImpl syncSubscriberEventActionHandler) {
        this.dataExchangeSubscriberEventActonHandler = dataExchangeSubscriberEventActonHandler;
        this.smsSubscriberEventActionHandler = smsSubscriberEventActionHandler;
        this.syncSubscriberEventActionHandler = syncSubscriberEventActionHandler;
    }

    public void execute(EventSubscriberEntity subscriberEntity, Collection<String> eventIds) {
        if (!StringUtils.hasLength(subscriberEntity.getHandler())) {
            return;
        }

        switch (subscriberEntity.getHandler()) {
            case SubscriberHandlerNames.DATA_EXCHANGE:
                this.dataExchangeSubscriberEventActonHandler.execute(subscriberEntity, eventIds);
                break;
            case SubscriberHandlerNames.SMS:
                this.smsSubscriberEventActionHandler.execute(subscriberEntity, eventIds);
                break;
            case SubscriberHandlerNames.SYNC:
                this.syncSubscriberEventActionHandler.execute(subscriberEntity, eventIds);
                break;
        }
    }
}
