package com.bcxin.tenant.backend;

import com.zaxxer.hikari.HikariDataSource;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

import javax.sql.DataSource;

/**
 * 这个一定要再NacosDataSourceConfig之后引入/执行，否则会报JPA, EntityManager的错误
 */
@Data
@ConfigurationProperties("v5.business.organization")
public class OrganizationDataSourceConfig {
    private String driverClassName;
    private String url;
    private String userName;
    private String password;

    @Bean("directlyOrganizationDataSource")
    public DataSource dataSource() {
        HikariDataSource dataSource = new HikariDataSource();
        dataSource.setJdbcUrl(this.url);
        dataSource.setUsername(userName);
        dataSource.setPassword(password);
        dataSource.setDriverClassName(driverClassName);

        return dataSource;
    }
}
