package com.bcxin.tenant.backend;

import com.bcxin.Infrastructure.messages.MessageConfig;
import com.bcxin.Infrastructures.InitConfig;
import com.bcxin.api.interfaces.ApiConstant;
import com.bcxin.api.interfaces.buses.MessageRpcProvider;
import com.bcxin.api.interfaces.commons.OperateLogRpcProvider;
import com.bcxin.api.interfaces.commons.PlatformOperateLogRpcProvider;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.rbacs.RbacCategoryRpcProvider;
import com.bcxin.api.interfaces.security.AttendSitePersonRpcProvider;
import com.bcxin.api.interfaces.tenants.*;
import com.bcxin.api.interfaces.tenants.OrganizationRpcProvider;
import com.bcxin.api.interfaces.tenants.OrganizationStatisticsRpcProvider;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.registration.nacos.NacosDataSourceConfig;
import com.bcxin.tenant.domain.TenantDomainConfig;
import com.bcxin.tenant.domain.repository.TenantConfig;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.dubbo.config.spring.context.annotation.EnableDubbo;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.HttpClients;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@EnableConfigurationProperties({V5AppConfig.class,NacosDataSourceConfig.class,
        SharedAppDataSourceConfig.class, MessageConfig.class, OrganizationDataSourceConfig.class})
@EnableDubbo
@Configuration
@ComponentScan({
        "com.bcxin.Infrastructures","com.bcxin.api.interfaces.rbacs",
        "com.bcxin.api.interfaces.tenants","com.bcxin.api.interfaces.identities",
        "com.bcxin.api.interfaces.buses"})
@Import({TenantDomainConfig.class, TenantConfig.class, InitConfig.class})
public class BackConfig {
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final RbacCategoryRpcProvider categoryRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final UserRpcProvider userRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final IdentityRpcProvider identityRpcProvider;

    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final MessageRpcProvider messageRpcProvider;

    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final OrganizationRpcProvider organizationRpcProvider;

    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final OperateLogRpcProvider operateLogRpcProvider;

    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final InviteDepartRpcProvider inviteDepartRpcProvider;

    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final InviteAttendSiteRpcProvider inviteAttendSiteRpcProvider;

    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final  EmployeeRpcProvider employeeRpcProvider;

    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final AttendSitePersonRpcProvider attendSitePersonRpcProvider;
    @DubboReference(check = false, version = ApiConstant.VERSION)
    private final OrganizationStatisticsRpcProvider organizationStatisticsRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final PlatformOperateLogRpcProvider platformOperateLogRpcProvider;

    @DubboReference(version = ApiConstant.VERSION, check = false)
    private final TenantDepartmentScheduledDeleteRpcProvider tenantDepartmentScheduledDeleteRpcProvider;


    public BackConfig(RbacCategoryRpcProvider categoryRpcProvider,
                      UserRpcProvider userRpcProvider,
                      IdentityRpcProvider identityRpcProvider,
                      MessageRpcProvider messageRpcProvider,
                      OrganizationRpcProvider organizationRpcProvider,
                      OperateLogRpcProvider operateLogRpcProvider,
                      InviteDepartRpcProvider inviteDepartRpcProvider,
                      InviteAttendSiteRpcProvider inviteAttendSiteRpcProvider,
                      EmployeeRpcProvider employeeRpcProvider,
                      AttendSitePersonRpcProvider attendSitePersonRpcProvider,
                      OrganizationStatisticsRpcProvider organizationStatisticsRpcProvider,
                      PlatformOperateLogRpcProvider platformOperateLogRpcProvider,
                      TenantDepartmentScheduledDeleteRpcProvider tenantDepartmentScheduledDeleteRpcProvider) {
        this.categoryRpcProvider = categoryRpcProvider;
        this.userRpcProvider = userRpcProvider;
        this.identityRpcProvider = identityRpcProvider;
        this.messageRpcProvider = messageRpcProvider;
        this.organizationRpcProvider = organizationRpcProvider;
        this.operateLogRpcProvider = operateLogRpcProvider;
        this.inviteDepartRpcProvider = inviteDepartRpcProvider;
        this.inviteAttendSiteRpcProvider = inviteAttendSiteRpcProvider;
        this.employeeRpcProvider = employeeRpcProvider;
        this.attendSitePersonRpcProvider = attendSitePersonRpcProvider;
        this.organizationStatisticsRpcProvider = organizationStatisticsRpcProvider;
        this.platformOperateLogRpcProvider = platformOperateLogRpcProvider;
        this.tenantDepartmentScheduledDeleteRpcProvider = tenantDepartmentScheduledDeleteRpcProvider;
    }

    @Bean
    public HttpClient httpClient() {
        return HttpClients.createDefault();
    }

/*
    @Bean("directlySharedAppDataSourceProperties")
    @ConfigurationProperties("v5.business.shared")
    public DataSourceProperties directlySharedAppDataSourceProperties() {
        return new DataSourceProperties();
    }

    @Bean("directlySharedAppDataSource")
    public DataSource directlySharedAppDataSource() {
        DataSourceProperties dataSourceProperties = directlySharedAppDataSourceProperties();

        return dataSourceProperties.initializeDataSourceBuilder().build();
    }

 */
}
