package com.bcxin.rest.web.apis.requests;

import com.bcxin.api.interfaces.RequestAbstract;
import com.bcxin.api.interfaces.enums.ExternalMemberInviteType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;

import javax.validation.constraints.NotBlank;

@ApiModel("生成二维码/邀请码请求")
@Getter
public class GenerateExternalInviteCodeRequest extends RequestAbstract {

    @ApiModelProperty(value = "邀请方式: InviteCode=邀请码; QRCode=二维码",required = true)
    @NotBlank(message = "系统参数异常-邀请方式不能为空")
    private final ExternalMemberInviteType inviteType;

    @ApiModelProperty("所在分组Id")
    private final String groupId;

    @ApiModelProperty("所在分组名称")
    private final String groupName;

    public GenerateExternalInviteCodeRequest(ExternalMemberInviteType inviteType, String groupId, String groupName) {
        this.inviteType = inviteType;
        this.groupId = groupId;
        this.groupName = groupName;
    }
}
