package com.bcxin.rest.web.apis.controllers;

import com.bcxin.api.interfaces.tenants.OrganizationTypeRpcProvider;
import com.bcxin.api.interfaces.tenants.requests.organizationType.OrganizationTypeCreateRequest;
import com.bcxin.api.interfaces.tenants.requests.organizationType.OrganizationTypeUpdateRequest;
import com.bcxin.api.interfaces.tenants.responses.OrganizationTypeResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

@RestController
@RequestMapping("/tenant/organizationType")
@Api(value = "集团组织类型api", tags = "集团组织类型api")
public class OrganizationTypeController extends ControllerAbstract{
    private final Logger logger = LoggerFactory.getLogger(OrganizationTypeController.class);

    private final OrganizationTypeRpcProvider organizationTypeProvider;

    public OrganizationTypeController(OrganizationTypeRpcProvider organizationTypeProvider) {
        this.organizationTypeProvider = organizationTypeProvider;
    }


    @ApiOperation(value = "保存组织类型")
    @PostMapping("/save")
    public ResponseEntity save(@Valid @RequestBody OrganizationTypeCreateRequest request){
        this.organizationTypeProvider.create(request);
        return ok();
    }

    @ApiOperation(value = "删除组织类型")
    @DeleteMapping("/delete/{id}")
    public ResponseEntity delete(@PathVariable long id){
        this.organizationTypeProvider.delete(id);
        return ok();
    }

    @ApiOperation(value = "更新组织类型")
    @PutMapping("/update")
    public ResponseEntity update(@Valid @RequestBody OrganizationTypeUpdateRequest request){
        this.organizationTypeProvider.update(request);
        return ok();
    }

    @ApiOperation(value = "查询组织类型")
    @GetMapping("/findById/{id}")
    public ResponseEntity findById(@PathVariable long id){
        OrganizationTypeResponse organizationTypeResponse = this.organizationTypeProvider.findById(id);
        return ok(organizationTypeResponse);
    }

    @ApiOperation(value = "查询所有组织类型")
    @GetMapping("/findByOrganizationId/{organizationId}")
    public ResponseEntity findByOrganizationId(@PathVariable String organizationId){
        return ok(this.organizationTypeProvider.findByOrganizationId(organizationId));
    }


}
