package com.bcxin.rest.web.apis.controllers;

import com.bcxin.api.interfaces.tenants.InviteOrganizationRelationshipRpcProvider;
import com.bcxin.api.interfaces.tenants.responses.CompanyUSCCResponse;
import com.bcxin.api.interfaces.tenants.responses.OrganizationTypeResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/tenant/inviteOrganizationRelationship")
@Api(value = "邀请组织管理api", tags = "邀请组织管理api")
public class InviteOrganizationRelationshipController extends ControllerAbstract{

    private final Logger logger = LoggerFactory.getLogger(InviteOrganizationRelationshipController.class);

    private final InviteOrganizationRelationshipRpcProvider inviteOrganizationRelationshipRpcProvider;


    public InviteOrganizationRelationshipController(InviteOrganizationRelationshipRpcProvider inviteOrganizationRelationshipRpcProvider) {
        this.inviteOrganizationRelationshipRpcProvider = inviteOrganizationRelationshipRpcProvider;
    }

    @ApiOperation(value = "获取企业的集团码")
    @GetMapping("/findGroupCodeByOrganizationId/{organizationId}")
    public ResponseEntity findByOrganizationId(@PathVariable String organizationId){
        String code=inviteOrganizationRelationshipRpcProvider.getGroupCode(organizationId);
        return ok(code);
    }
    @ApiOperation(value = "通过集团码获取企业信息")
    @GetMapping("/findOrganizationInfoByGroupCode/{groupCode}")
    public ResponseEntity findOrganizationInfoByGroupCode(@PathVariable String groupCode){
        CompanyUSCCResponse companyUSCCResponse =inviteOrganizationRelationshipRpcProvider.findCompanyUSCCByGroupCode(groupCode);
        return ok(companyUSCCResponse);
    }
}
