package com.bcxin.rest.web.apis.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.XMLWriter;
import sun.misc.BASE64Encoder;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 旁路报文认证的网关工具类
 *
 * @author weichang_ding
 *
 */
@Slf4j
public class JitGatewayUtil {
	//public static Map configMap = new HashMap();
	public JitGatewayUtilBean jitGatewayUtilBean = new JitGatewayUtilBean();
	public AuthResult authResult = new AuthResult();

	public  String authURL;
	public  String appId;
	public  String randomFrom;
	public  String accessControl;
	public  String generateQRCodeURL;
	public  String queryQRCodeStateURL;


	public JitGatewayUtil(String authURL, String appId, String randomFrom, String accessControl, String generateQRCodeURL,
						  String queryQRCodeStateURL) {
		this.authURL = authURL;
		this.appId = appId;
		this.randomFrom = randomFrom;
		this.accessControl = accessControl;
		this.generateQRCodeURL = generateQRCodeURL;
		this.queryQRCodeStateURL = queryQRCodeStateURL;
	}



	public String generateRandomNum(String randomFrom) {
		String random = "";
		if ("2".equals(randomFrom)) {
			log.info("调用网关生成原文");
			random = this.generateRandomNumFromGagewayServer();
		} else {
			log.info("调用应用服务器生成原文");
			random = this.generateRandomNumByApplication();
		}
		log.info("生成原文结束，原文：" + random);
		return random;
	}

	public String generateRandomNumByApplication() {
		String num = "1234567890abcdefghijklmnopqrstopqrstuvwxyz";
		int size = 6;
		char[] charArray = num.toCharArray();
		StringBuffer sb = new StringBuffer();

		for(int i = 0; i < size; ++i) {
			sb.append(charArray[(int)(Math.random() * 10000.0D) % charArray.length]);
		}

		return sb.toString();
	}

	public String generateRandomNumFromGagewayServer() {
		String errCode = null;
		String errDesc = null;
		byte[] messagexml = null;
		log.info("组装认证原文请求报文数据开始");
		Document reqDocument = DocumentHelper.createDocument();
		Element root = reqDocument.addElement("message");
		Element requestHeadElement = root.addElement("head");
		Element requestBodyElement = root.addElement("body");
		requestHeadElement.addElement("version").setText("1.0");
		requestHeadElement.addElement("serviceType").setText("OriginalService");
		requestBodyElement.addElement("appId").setText(appId);
		StringBuffer reqMessageData = new StringBuffer();

		try {
			ByteArrayOutputStream outStream = new ByteArrayOutputStream();
			XMLWriter writer = new XMLWriter(outStream);
			writer.write(reqDocument);
			messagexml = outStream.toByteArray();
			reqMessageData.append("请求内容开始！\n");
			reqMessageData.append(outStream.toString() + "\n");
			reqMessageData.append("请求内容结束！\n");
			log.info(reqMessageData.toString() + "\n");
		} catch (Exception var28) {
			errDesc = "组装原文请求报文时出现异常";
			log.info("组装原文请求报文时出现异常" + var28.getMessage());
		}

		log.info("组装认证原文请求报文数据结束");
		log.info("创建与网关的HTTP连接，发送认证原文请求报文开始");
		int statusCode = 500;
		HttpClient httpClient = new HttpClient();
		PostMethod postMethod = new PostMethod(authURL);
		postMethod.setRequestHeader("Connection", "close");
		postMethod.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
		postMethod.setRequestBody(new ByteArrayInputStream(messagexml));

		String respMessageXml;
		try {
			URL url = protocol(authURL);
			statusCode = httpClient.executeMethod(postMethod);
			if (url != null && "https".equals(url.getProtocol())) {
				Protocol.unregisterProtocol("https");
			}
		} catch (Exception var29) {
			errCode = String.valueOf(statusCode);
			errDesc = var29.getMessage();
			log.info("发送原文请求报文与网关连接出现异常：" + errDesc);
			postMethod.releaseConnection();
			httpClient.getHttpConnectionManager().closeIdleConnections(0L);
			httpClient = null;
			respMessageXml = errorJdkMess(var29);
			if (respMessageXml != null) {
				;
			}

			var29.printStackTrace();
			return null;
		}

		log.info("创建与网关的HTTP连接，发送认证原文请求报文结束");
		StringBuffer respMessageData = new StringBuffer();
		respMessageXml = null;
		ByteArrayInputStream byteinputStream;
		ByteArrayOutputStream outStream;
		boolean state;
		if (statusCode == 200 || statusCode == 500) {
			try {
				byte[] inputstr = postMethod.getResponseBody();
				byteinputStream = new ByteArrayInputStream(inputstr);
				outStream = new ByteArrayOutputStream();
				state = false;

				int ch;
				try {
					while((ch = byteinputStream.read()) != -1) {
						int upperCh = (char)ch;
						outStream.write(upperCh);
					}
				} catch (Exception var30) {
					errDesc = var30.getMessage();
				}

				if (statusCode == 200) {
					respMessageData.append("响应内容开始！\n");
					respMessageData.append(new String(outStream.toByteArray(), "UTF-8") + "\n");
					respMessageData.append("响应内容开始！\n");
					respMessageXml = new String(outStream.toByteArray(), "UTF-8");
				} else {
					respMessageData.append("响应500内容开始！\n");
					respMessageData.append(new String(outStream.toByteArray()) + "\n");
					respMessageData.append("响应500内容结束！\n");
					errCode = String.valueOf(statusCode);
					new String(outStream.toByteArray());
				}

				log.info("网关返回响应内容：" + respMessageData.toString());
			} catch (IOException var31) {
				errCode = String.valueOf(statusCode);
				errDesc = var31.getMessage();
				log.info("读取原文请求响应报文出现异常：" + errCode + "," + errDesc);
			} finally {
				if (httpClient != null) {
					postMethod.releaseConnection();
					httpClient.getHttpConnectionManager().closeIdleConnections(0L);
				}

			}
		}

		Document respDocument = null;
		byteinputStream = null;
		outStream = null;
		log.info("解析网关服务器返回的原文请求响应报文开始");

		try {
			respDocument = DocumentHelper.parseText(respMessageXml);
		} catch (DocumentException var27) {
			log.info("解析认证返回信息异常：" + var27.getMessage());
		}

		Element headElement = respDocument.getRootElement().element("head");
		Element bodyElement = respDocument.getRootElement().element("body");
		if (headElement != null) {
			state = Boolean.valueOf(headElement.elementTextTrim("messageState"));
			if (state) {
				errCode = headElement.elementTextTrim("messageCode");
				errDesc = headElement.elementTextTrim("messageDesc");
				log.info("向网关请求原文失败：" + errCode + "," + errDesc);
			}
		}

		Element originalElement = bodyElement.element("original");
		String original = "";
		if (originalElement != null) {
			original = originalElement.getStringValue();
			log.info("向网关请求原文成功，生成原文：" + original);
		}

		log.info("解析网关服务器返回的原文请求响应报文结束");
		return original;
	}

	public void auth() {
		boolean isSuccess = true;
		String errCode = null;
		String errDesc = null;
		String original_data_base64 = null;
		log.info("获取authURL:" + this.authURL + "获取appId" + this.appId);
		if (!this.isNotNull(this.appId) || !this.isNotNull(this.authURL)) {
			isSuccess = false;
			errDesc = "应用标识或网关认证地址不可为空";
			log.info("应用标识或网关认证地址不可为空\n");
		}

		log.info("应用标识及网关的认证地址读取成功！\n应用标识：" + this.appId + "\n认证地址：" + this.authURL + "\n");
		if (isSuccess && !"qrcode".equalsIgnoreCase(this.jitGatewayUtilBean.getAuthMode())) {
			log.info("服务端验证认证原文开始");
			if (this.isNotNull(this.jitGatewayUtilBean.original_data) && this.isNotNull(this.jitGatewayUtilBean.signed_data) && this.isNotNull(this.jitGatewayUtilBean.original_jsp)) {
				if (!this.jitGatewayUtilBean.original_data.equalsIgnoreCase(this.jitGatewayUtilBean.original_jsp)) {
					isSuccess = false;
					errDesc = "服务端验证认证原文失败:客户端提供的认证原文与服务端的不一致";
					log.info(errDesc);
				} else {
					original_data_base64 = (new BASE64Encoder()).encode(this.jitGatewayUtilBean.original_jsp.getBytes());
					log.info("服务端验证认证原文:服务端验证认证原文成功！\n认证原文：" + this.jitGatewayUtilBean.original_jsp + "\n认证请求包：" + this.jitGatewayUtilBean.signed_data + "\n");
				}
			} else {
				isSuccess = false;
				errDesc = "服务端验证认证原文失败:证书认证数据不完整";
				log.info("服务端验证认证原文失败:证书认证数据不完整！\n");
			}

			log.info("服务端验证认证原文结束");
		}

		try {
			byte[] messagexml = null;
			Element respDocument1;
			Element headElement;
			Element bodyElement;
			Element authResultElement;
			Element httpClientElement;
			StringBuffer respMessageData;
			if (isSuccess) {
				log.info("组装认证请求报文开始");
				Document reqDocument = DocumentHelper.createDocument();
				Element httpClient1 = reqDocument.addElement("message");
				httpClientElement = httpClient1.addElement("head");
				Element requestBodyElement = httpClient1.addElement("body");
				if ("2".equals(this.randomFrom)) {
					httpClientElement.addElement("version").setText("1.1");
				} else {
					httpClientElement.addElement("version").setText("1.0");
				}

				httpClientElement.addElement("serviceType").setText("AuthenService");
				Element clientInfoElement = requestBodyElement.addElement("clientInfo");
				respDocument1 = clientInfoElement.addElement("clientIP");
				respDocument1.setText(this.jitGatewayUtilBean.remoteAddr);
				requestBodyElement.addElement("appId").setText(this.appId);
				headElement = requestBodyElement.addElement("authen");
				bodyElement = headElement.addElement("authCredential");
				if ("cert".equalsIgnoreCase(this.jitGatewayUtilBean.authMode)) {
					bodyElement.addAttribute("authMode", "cert");
					bodyElement.addElement("detach").setText(this.jitGatewayUtilBean.signed_data);
					bodyElement.addElement("original").setText(original_data_base64);
				} else if ("qrcode".equalsIgnoreCase(this.jitGatewayUtilBean.authMode)) {
					bodyElement.addAttribute("authMode", "qrcode");
					bodyElement.addElement("token").setText(this.jitGatewayUtilBean.token);
					bodyElement.addElement("QRCode").setText(this.jitGatewayUtilBean.qrcode);
				}

				requestBodyElement.addElement("accessControl").setText(this.accessControl);
				authResultElement = requestBodyElement.addElement("attributes");
				authResultElement.addAttribute("attributeType", "all");
				respMessageData = new StringBuffer();

				try {
					ByteArrayOutputStream outStream = new ByteArrayOutputStream();
					XMLWriter writer = new XMLWriter(outStream);
					writer.write(reqDocument);
					messagexml = outStream.toByteArray();
					respMessageData.append("请求内容开始！\n");
					respMessageData.append(outStream.toString() + "\n");
					respMessageData.append("请求内容结束！\n");
					log.info(respMessageData.toString() + "\n");
				} catch (Exception var39) {
					isSuccess = false;
					errDesc = "组装认证请求报文出现异常";
					log.info("组装认证请求报文出现异常" + var39.getMessage());
				}

				log.info("组装认证请求报文结束");
			}

			int statusCode = 500;
			HttpClient httpClient = null;
			PostMethod postMethod = null;
			String respMessageXml;
			if (isSuccess) {
				log.info("向网关发送认证请求开始");
				httpClient = new HttpClient();
				postMethod = new PostMethod(this.authURL);
				postMethod.setRequestHeader("Connection", "close");
				postMethod.setRequestHeader("Content-Type", "text/xml;charset=UTF-8");
				postMethod.setRequestBody(new ByteArrayInputStream(messagexml));

				try {
					URL url = protocol(this.authURL);
					statusCode = httpClient.executeMethod(postMethod);
					if (url != null && "https".equals(url.getProtocol())) {
						Protocol.unregisterProtocol("https");
					}
				} catch (Exception var43) {
					isSuccess = false;
					errCode = String.valueOf(statusCode);
					errDesc = var43.getMessage();
					log.info("向网关发送认证请求失败：与网关连接出现异常:" + errDesc);
					postMethod.releaseConnection();
					httpClient.getHttpConnectionManager().closeIdleConnections(0L);
					httpClient = null;
					respMessageXml = errorJdkMess(var43);
					if (respMessageXml != null) {
					}

					throw var43;
				}

				log.info("向网关发送认证请求结束");
			}

			respMessageData = new StringBuffer();
			respMessageXml = null;
			boolean state;
			if (isSuccess) {
				log.info("读取网关返回的认证响应报文开始");
				if (statusCode == 200 || statusCode == 500) {
					try {
						byte[] inputstr = postMethod.getResponseBody();
						ByteArrayInputStream ByteinputStream = new ByteArrayInputStream(inputstr);
						ByteArrayOutputStream outStream = new ByteArrayOutputStream();
						state = false;

						try {
							int i = 0;
							while((i = ByteinputStream.read()) != -1) {
								int upperCh = (char)i;
								outStream.write(upperCh);
							}
						} catch (Exception var40) {
							isSuccess = false;
							errDesc = var40.getMessage();
						}

						if (isSuccess) {
							if (statusCode == 200) {
								respMessageData.append("响应内容开始！\n");
								respMessageData.append(new String(outStream.toByteArray(), "UTF-8") + "\n");
								respMessageData.append("响应内容结束！\n");
								respMessageXml = new String(outStream.toByteArray(), "UTF-8");
							} else {
								respMessageData.append("响应500内容开始！\n");
								respMessageData.append(new String(outStream.toByteArray()) + "\n");
								respMessageData.append("响应500内容结束！\n");
								isSuccess = false;
								errCode = String.valueOf(statusCode);
								errDesc = new String(outStream.toByteArray());
							}

							log.info(respMessageData.toString());
						}
					} catch (IOException var41) {
						isSuccess = false;
						errCode = String.valueOf(statusCode);
						errDesc = var41.getMessage();
						log.info("读取网关返回的认证响应报文出现异常:" + errDesc);
					} finally {
						if (httpClient != null) {
							postMethod.releaseConnection();
							httpClient.getHttpConnectionManager().closeIdleConnections(0L);
						}

					}
				}

				log.info("读取网关返回的认证响应报文结束");
			}

			respDocument1 = null;
			headElement = null;
			bodyElement = null;
			if (isSuccess) {
				log.info("解析网关返回的认证响应报文开始");
				respMessageXml = respMessageXml.replaceAll("&", "&amp;");
				Document respDocument = DocumentHelper.parseText(respMessageXml);
				headElement = respDocument.getRootElement().element("head");
				bodyElement = respDocument.getRootElement().element("body");
				if (headElement != null) {
					state = Boolean.valueOf(headElement.elementTextTrim("messageState"));
					if (state) {
						isSuccess = false;
						errCode = headElement.elementTextTrim("messageCode");
						errDesc = headElement.elementTextTrim("messageDesc");
						log.info("网关认证业务处理失败！\t" + errDesc + "\n");
					}
				}
			}

			if (isSuccess) {
				log.info("解析报文头成功！\n");
				authResultElement = bodyElement.element("authResultSet").element("authResult");
				isSuccess = Boolean.valueOf(authResultElement.attributeValue("success"));
				if (!isSuccess) {
					errCode = authResultElement.elementTextTrim("authMessageCode");
					errDesc = authResultElement.elementTextTrim("authMessageDesc");
					log.info("身份认证失败，失败原因：" + errDesc);
				}
			}

			if (isSuccess) {
				log.info("身份认证成功！\n");
				String accessControlResult = bodyElement.elementTextTrim("accessControlResult");
				log.info("网关根据规则对该用户计算的访问控制结果:" + accessControlResult);
				this.authResult.setAccessControlResult(accessControlResult);
				if ("Deny".equals(accessControlResult)) {
					isSuccess = false;
					errCode = "-1";
					errDesc = "该用户无权限访问此应用";
				} else {
					Element attrsElement = bodyElement.element("attributes");
					if (attrsElement != null) {
						List<Element> attributeNodeList = attrsElement.elements("attr");
						if (attributeNodeList != null && attributeNodeList.size() > 0) {
							log.info("属性个数：" + attributeNodeList.size());

							for (Element element : attributeNodeList) {
								String arrs = element.attributeValue("namespace");
								log.info(arrs);
							}

							Map<String, String> certAttributeNodeMap = new HashMap<>();
							Map<String, String> childAttributeNodeMap = new HashMap<>();
							Map<String, String> umsAttributeNodeMap = new HashMap<>();
							Map<String, String> pmsAttributeNodeMap = new HashMap<>();
							Map<String, String> customAttributeNodeMap = new HashMap<>();

							for (Element userAttrNode : attributeNodeList) {
								String msgParentName = userAttrNode.attributeValue("parentName");
								String name = userAttrNode.attributeValue("name");
								String value = userAttrNode.getTextTrim();
								String key = name;
								childAttributeNodeMap.clear();
								String arrs = userAttrNode.attributeValue("namespace");
								if (arrs.trim().equals("http://www.jit.com.cn/cinas/ias/ns/saml/saml11/X.509")) {
									if (msgParentName != null && !msgParentName.equals("")) {
										key = key + "__" + msgParentName;
										if (value != null && value.length() > 0) {
											childAttributeNodeMap.put(key, value);
										}
									} else if (value != null && value.length() > 0) {
										certAttributeNodeMap.put(key, value);
									}

									certAttributeNodeMap.putAll(childAttributeNodeMap);
								} else if (arrs.trim().equals("http://www.jit.com.cn/ums/ns/user")) {
									if (msgParentName != null && !msgParentName.equals("")) {
										key = key + "__" + msgParentName;
										if (value != null && value.length() > 0) {
											childAttributeNodeMap.put(key, value);
										}
									} else if (value != null && value.length() > 0) {
										umsAttributeNodeMap.put(key, value);
									}

									umsAttributeNodeMap.putAll(childAttributeNodeMap);
								} else if (arrs.trim().contains("http://www.jit.com.cn/pmi/pms")) {
									if (msgParentName != null && !msgParentName.equals("")) {
										key = key + "__" + msgParentName;
										if (value != null && value.length() > 0) {
											childAttributeNodeMap.put(key, value);
										}
									} else if (value != null && value.length() > 0) {
										pmsAttributeNodeMap.put(key, value);
									}

									pmsAttributeNodeMap.putAll(childAttributeNodeMap);
								} else if (arrs.trim().contains("http://www.jit.com.cn/gw/custom/attribute")) {
									if (msgParentName != null && !msgParentName.equals("")) {
										key = key + "__" + msgParentName;
										if (value != null && value.length() > 0) {
											childAttributeNodeMap.put(key, value);
										}
									} else if (value != null && value.length() > 0) {
										customAttributeNodeMap.put(key, value);
									}

									customAttributeNodeMap.putAll(childAttributeNodeMap);
								} else {
									if (msgParentName != null && !msgParentName.equals("")) {
										key = key + "__" + msgParentName;
										if (value != null && value.length() > 0) {
											childAttributeNodeMap.put(key, value);
										}
									} else if (value != null && value.length() > 0) {
										certAttributeNodeMap.put(key, value);
									}

									certAttributeNodeMap.putAll(childAttributeNodeMap);
								}
							}

							this.authResult.setCertAttributeNodeMap(certAttributeNodeMap);
							this.authResult.setUmsAttributeNodeMap(umsAttributeNodeMap);
							this.authResult.setPmsAttributeNodeMap(pmsAttributeNodeMap);
							this.authResult.setCustomAttributeNodeMap(customAttributeNodeMap);

						}
					}
				}
			}
		} catch (Exception var44) {
			isSuccess = false;
			var44.printStackTrace();
			errDesc = var44.getMessage();
		}

		log.info("解析网关返回的认证响应报文结束");
		this.authResult.setSuccess(isSuccess);
		this.authResult.setErrCode(errCode);
		this.authResult.setErrDesc(errDesc);
	}

	public QRCodeResult gengrateQRCode() {
		QRCodeResult qrCodeResult = new QRCodeResult();
		HttpClient httpClient = new HttpClient();
		PostMethod postMethod = new PostMethod(generateQRCodeURL);
		postMethod.setRequestHeader("appFlag", appId);
		Map propsMap = new HashMap();
		propsMap.put("Service_Type", "qrcode_generate");
		Set keySet = propsMap.keySet();
		NameValuePair[] postData = new NameValuePair[keySet.size()];
		int index = 0;
		Object[] arr$ = keySet.toArray();
		int len$ = arr$.length;

		for(int i$ = 0; i$ < len$; ++i$) {
			Object key = arr$[i$];
			postData[index++] = new NameValuePair(key.toString(), propsMap.get(key).toString());
		}

		postMethod.addParameters(postData);

		try {
			int statusCode = httpClient.executeMethod(postMethod);
			if (statusCode == 200) {
				qrCodeResult.setSuccess(true);
				qrCodeResult.setBytes(postMethod.getResponseBody());
				qrCodeResult.setCookies(httpClient.getState().getCookies());
				log.info("生成二维码成功");
			} else {
				qrCodeResult.setSuccess(false);
				log.info("生成二维码失败,网关返回状态码：" + statusCode);
			}
		} catch (Exception var15) {
			qrCodeResult.setSuccess(false);
			log.info("生成二维码失败，异常信息" + var15.getMessage());
		} finally {
			postMethod.releaseConnection();
		}

		return qrCodeResult;
	}

	public static URL protocol(String authURL) {
		URL url = getUrl(authURL);
		if (url != null && "https".equals(url.getProtocol())) {
			int port = 443;
			if (url.getPort() != -1) {
				port = url.getPort();
			}

			Protocol https = new Protocol("https", new HTTPSSecureProtocolSocketFactory(), port);
			Protocol.registerProtocol("https", https);
		}

		return url;
	}

	private static String errorJdkMess(Exception e) {
		String errDesc = null;
		if ("Received fatal alert: protocol_version".equals(e.getMessage()) || "Remote host closed connection during handshake".equals(e.getMessage())) {
			float weight = Float.parseFloat(getJavaVersion());
			if (weight <= 1.7F) {
				errDesc = "当前运行的服务器jdk版本过低，需要升级jdk到1.8版本以上；或将网关SSL级别调整为低级";
				System.err.println(errDesc);
			}
		}

		return errDesc;
	}

	public static String getJavaVersion() {
		String javaVersion = System.getProperty("java.version");
		String[] array = javaVersion.split("\\.");
		String newVersion = "";

		for(int i = 0; i < 2; ++i) {
			newVersion = newVersion + array[i];
			if (i == 0) {
				newVersion = newVersion + ".";
			}
		}

		return newVersion;
	}

	private static URL getUrl(String urlAddress) {
		URL url = null;

		try {
			url = new URL(urlAddress);
		} catch (MalformedURLException var3) {
			var3.printStackTrace();
		}

		return url;
	}

	public String queryQRCodeState(String code) {
		StringBuffer sb = new StringBuffer();
		HttpClient httpClient = new HttpClient();
		PostMethod postMethod = new PostMethod(queryQRCodeStateURL + code);

		try {
			int statusCode = httpClient.executeMethod(postMethod);
			if (statusCode == 200) {
				InputStream ins = postMethod.getResponseBodyAsStream();
				byte[] b = new byte[1024];
				boolean var8 = false;

				int r_len;
				while((r_len = ins.read(b)) > 0) {
					sb.append(new String(b, 0, r_len, postMethod.getResponseCharSet()));
				}

				log.info("查询二维码状态成功，网关返回信息：" + sb.toString());
			} else {
				log.info("查询二维码状态失败，网关返回状态码：" + statusCode);
			}
		} catch (Exception var12) {
			log.info("查询二维码状态失败，异常信息" + var12.getMessage());
		} finally {
			postMethod.releaseConnection();
		}

		return sb.toString();
	}

	public boolean isNotNull(String str) {
		return str != null && !str.trim().equals("");
	}

	/*private static void setConfigMapValue(Properties props, String key) {
		Object object = props.get(key);
		if (null != object && !object.toString().equals("")) {
			configMap.put(key, (String)props.get(key));
		} else {
			log.info("配置文件中配置项：" + key + " 不存在或值为空");
			configMap.put("configSuccess", "false");
			configMap.put(key, "");
		}

	}*/

	public class QRCodeResult {
		private boolean isSuccess;
		private byte[] bytes;
		private Cookie[] cookies;

		public QRCodeResult() {
		}

		public boolean isSuccess() {
			return this.isSuccess;
		}

		private void setSuccess(boolean isSuccess) {
			this.isSuccess = isSuccess;
		}

		public byte[] getBytes() {
			return this.bytes;
		}

		private void setBytes(byte[] bytes) {
			this.bytes = bytes;
		}

		public Cookie[] getCookies() {
			return this.cookies;
		}

		private void setCookies(Cookie[] cookies) {
			this.cookies = cookies;
		}
	}

	public class AuthResult {
		private boolean isSuccess;
		private String errCode;
		private String errDesc;
		private Map<String, String> certAttributeNodeMap;
		private Map<String, String> umsAttributeNodeMap;
		private Map<String, String> pmsAttributeNodeMap;
		private Map<String, String> customAttributeNodeMap;
		private String customAttrsElement;
		private String accessControlResult;

		public AuthResult() {
		}

		public boolean isSuccess() {
			return this.isSuccess;
		}

		private void setSuccess(boolean isSuccess) {
			this.isSuccess = isSuccess;
		}

		public String getErrCode() {
			return this.errCode;
		}

		private void setErrCode(String errCode) {
			this.errCode = errCode;
		}

		public String getErrDesc() {
			return this.errDesc;
		}

		private void setErrDesc(String errDesc) {
			this.errDesc = errDesc;
		}

		public Map<String, String> getCertAttributeNodeMap() {
			return this.certAttributeNodeMap;
		}

		private void setCertAttributeNodeMap(Map<String, String> certAttributeNodeMap) {
			this.certAttributeNodeMap = certAttributeNodeMap;
		}

		public Map<String, String> getUmsAttributeNodeMap() {
			return this.umsAttributeNodeMap;
		}

		private void setUmsAttributeNodeMap(Map<String, String> umsAttributeNodeMap) {
			this.umsAttributeNodeMap = umsAttributeNodeMap;
		}

		public Map<String, String> getPmsAttributeNodeMap() {
			return this.pmsAttributeNodeMap;
		}

		private void setPmsAttributeNodeMap(Map<String, String> pmsAttributeNodeMap) {
			this.pmsAttributeNodeMap = pmsAttributeNodeMap;
		}

		public String getCustomAttrsElement() {
			return this.customAttrsElement;
		}

		private void setCustomAttrsElement(String customAttrsElement) {
			this.customAttrsElement = customAttrsElement;
		}

		public Map<String, String> getCustomAttributeNodeMap() {
			return this.customAttributeNodeMap;
		}

		public void setCustomAttributeNodeMap(Map<String, String> customAttributeNodeMap) {
			this.customAttributeNodeMap = customAttributeNodeMap;
		}

		public String getAccessControlResult() {
			return this.accessControlResult;
		}

		public void setAccessControlResult(String accessControlResult) {
			this.accessControlResult = accessControlResult;
		}

		@Override
		public String toString() {
			return "AuthResult{" +
					"isSuccess=" + isSuccess +
					", errCode='" + errCode + '\'' +
					", errDesc='" + errDesc + '\'' +
					", certAttributeNodeMap=" + certAttributeNodeMap +
					", umsAttributeNodeMap=" + umsAttributeNodeMap +
					", pmsAttributeNodeMap=" + pmsAttributeNodeMap +
					", customAttributeNodeMap=" + customAttributeNodeMap +
					", customAttrsElement='" + customAttrsElement + '\'' +
					", accessControlResult='" + accessControlResult + '\'' +
					'}';
		}
	}

	public class JitGatewayUtilBean {
		private String authURL;
		private String authMode;
		private String token;
		private String qrcode;
		private String original_data;
		private String signed_data;
		private String original_jsp;
		private String remoteAddr;
		private String generateQRCodeURL;
		private String queryQRCodeStateURL;

		public JitGatewayUtilBean() {
		}

		public String getAuthURL() {
			return authURL;
		}

		public String getAuthMode() {
			return this.authMode;
		}

		public void setAuthMode(String authMode) {
			this.authMode = authMode;
		}

		public String getToken() {
			return this.token;
		}

		public void setToken(String token) {
			this.token = token;
		}

		public String getQrcode() {
			return this.qrcode;
		}

		public void setQrcode(String qrcode) {
			this.qrcode = qrcode;
		}

		public String getOriginal_data() {
			return this.original_data;
		}

		public void setOriginal_data(String original_data) {
			this.original_data = original_data;
		}

		public String getSigned_data() {
			return this.signed_data;
		}

		public void setSigned_data(String signed_data) {
			this.signed_data = signed_data;
		}

		public String getOriginal_jsp() {
			return this.original_jsp;
		}

		public void setOriginal_jsp(String original_jsp) {
			this.original_jsp = original_jsp;
		}

		public String getRemoteAddr() {
			return this.remoteAddr;
		}

		public void setRemoteAddr(String remoteAddr) {
			this.remoteAddr = remoteAddr;
		}

		public String getGenerateQRCodeURL() {
			return this.getGenerateQRCodeURL();
		}

		public String getQueryQRCodeStateURL() {
			return this.getQueryQRCodeStateURL();
		}
	}

	public static class QRConstant {
		public static final String KEY_JIT_QRCODE = "jit_qrcode";
		public static final String KEY_APP_FLAG = "appFlag";
		public static final String KEY_SERVICE_TYPE = "Service_Type";
		public static final String KEY_QRCODE_GENERATE = "qrcode_generate";

		public QRConstant() {
		}
	}

	public static class AuthConstant {
		public static final String MSG_SERVICE_TYPE_VALUE = "AuthenService";
		public static final String MSG_AUTH_MODE = "authMode";
		public static final String MSG_AUTH_MODE_CERT_VALUE = "cert";
		public static final String MSG_AUTH_MODE_PASSWORD_VALUE = "password";
		public static final String MSG_AUTH_MODE_QRCODE_VALUE = "qrcode";
		public static final String MSG_ATTRIBUTES = "attributes";
		public static final String MSG_CUSTOM_ATTRIBUTES = "customAttributes";
		public static final String MSG_ATTRIBUTE = "attr";
		public static final String MSG_NAME = "name";
		public static final String MSG_PARENT_NAME = "parentName";
		public static final String MSG_NAMESPACE = "namespace";
		public static final String MSG_ACCESS_CONTROL = "accessControl";
		public static final String MSG_ACCESS_CONTROL_TRUE = "true";
		public static final String MSG_ACCESS_CONTROL_FALSE = "false";
		public static final String MSG_AUTH = "authen";
		public static final String MSG_AUTHCREDENTIAL = "authCredential";
		public static final String MSG_CLIENT_INFO = "clientInfo";
		public static final String MSG_CERT_INFO = "certInfo";
		public static final String MSG_CLIENT_IP = "clientIP";
		public static final String MSG_DETACH = "detach";
		public static final String MSG_CERTTYPE = "certType";
		public static final String MSG_USERNAME = "username";
		public static final String MSG_PASSWORD = "password";
		public static final String MSG_TOKEN = "token";
		public static final String MSG_QRCODE = "QRCode";
		public static final String MSG_ATTRIBUTE_TYPE = "attributeType";
		public static final String MSG_ATTRIBUTE_TYPE_PORTION = "portion";
		public static final String MSG_ATTRIBUTE_TYPE_ALL = "all";
		public static final String MSG_ATTR_TYPE = "attrType";
		public static final String MSG_AUTH_RESULT_SET = "authResultSet";
		public static final String MSG_AUTH_RESULT = "authResult";
		public static final String MSG_SUCCESS = "success";
		public static final String MSG_AUTH_MESSSAGE_CODE = "authMessageCode";
		public static final String MSG_AUTH_MESSSAGE_DESC = "authMessageDesc";
		public static final String KEY_JIT_QRCODE = "jit_qrcode";
		public static final String KEY_ORIGINAL_DATA = "original_data";
		public static final String KEY_ORIGINAL = "original";
		public static final String KEY_SIGNED_DATA = "signed_data";
		public static final String KEY_NAMESPACE_CINAS = "http://www.jit.com.cn/cinas/ias/ns/saml/saml11/X.509";
		public static final String KEY_NAMESPACE_UMS = "http://www.jit.com.cn/ums/ns/user";
		public static final String KEY_NAMESPACE_PMS = "http://www.jit.com.cn/pmi/pms";
		public static final String KEY_NAMESPACE_CUSTOM = "http://www.jit.com.cn/gw/custom/attribute";

		public AuthConstant() {
		}
	}

	static class RandomConstant {
		public static final String MSG_SERVICE_TYPE_VALUE = "OriginalService";

		RandomConstant() {
		}
	}

	static class CommonConstant {
		public static final String MSG_ROOT = "message";
		public static final String MSG_HEAD = "head";
		public static final String MSG_BODY = "body";
		public static final String MSG_VSERSION = "version";
		public static final String MSG_VSERSION_VALUE_10 = "1.0";
		public static final String MSG_VSERSION_VALUE_11 = "1.1";
		public static final String MSG_SERVICE_TYPE = "serviceType";
		public static final String MSG_APPID = "appId";
		public static final String MSG_MESSAGE_STATE = "messageState";
		public static final String MSG_MESSAGE_CODE = "messageCode";
		public static final String MSG_MESSAGE_DESC = "messageDesc";
		public static final String MSG_ORIGINAL = "original";

		CommonConstant() {
		}
	}

	public static class ConfigConstant {
		public static final String KEY_AUTH_URL = "authURL";
		public static final String KEY_APP_ID = "appId";
		public static final String KEY_QRCODE_AUTH = "QRCodeAuth";
		public static final String KEY_RANDOM_FROM = "randomFrom";
		public static final String KEY_ACCESS_CONTROL = "accessControl";
		public static final String KEY_GENERATEQRCODE_URL = "generateQRCodeURL";
		public static final String KEY_QUERYQRCODESTATE_URL = "queryQRCodeStateURL";
		public static final String KEY_CONFIG_SUCCESS = "configSuccess";

		public ConfigConstant() {
		}
	}
}
