package com.bcxin.rest.web.apis.dubbos;

import com.bcxin.Infrastructures.TenantContext;
import com.bcxin.Infrastructures.TenantUserContext;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.filter.support.ConsumerContextFilter;

/**
 * 隐藏传输当前登入的用户信息
 */
@Activate(group = CommonConstants.CONSUMER,order = -99999)
public class CustomConsumerContextFilter extends ConsumerContextFilter {

    public CustomConsumerContextFilter()
    {
    }

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        TenantUserContext.UserModel userModel = TenantContext.getInstance().getUserContext().get();
        invocation.setAttachment(TenantUserContext.CURRENT_TENANT_USER_INFO, userModel);

        return super.invoke(invoker, invocation);
    }
}
