package com.bcxin.rest.web.apis.controllers;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.bcxin.Infrastructures.Pageable;
import com.bcxin.Infrastructures.components.CacheV2Provider;
import com.bcxin.Infrastructures.enums.CredentialType;
import com.bcxin.api.interfaces.identities.IdentityRpcProvider;
import com.bcxin.api.interfaces.identities.requests.BindWechatRequest;
import com.bcxin.api.interfaces.identities.responses.SignInResponse;
import com.bcxin.api.interfaces.tenants.EmployeeRpcProvider;
import com.bcxin.api.interfaces.tenants.OrganizationRpcProvider;
import com.bcxin.api.interfaces.tenants.UserRpcProvider;
import com.bcxin.api.interfaces.tenants.criterias.OrganizationCriteria;
import com.bcxin.api.interfaces.tenants.requests.tenantUsers.*;
import com.bcxin.api.interfaces.tenants.responses.*;
import com.bcxin.rest.web.apis.requests.CertificateRequest;
import com.bcxin.rest.web.apis.responses.ApiDepartmentTreeGetResponse;
import com.bcxin.rest.web.apis.utils.CacheUtil;
import com.bcxin.rest.web.apis.utils.IPUtils;
import io.swagger.annotations.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 公共查询
 */
@Api("公共查询")
@RestController
@RequestMapping("/public")
public class PublicController extends ControllerAbstract {
    private final UserRpcProvider userRpcProvider;
    private final OrganizationRpcProvider organizationRpcProvider;

    public PublicController(UserRpcProvider userRpcProvider,
                            OrganizationRpcProvider organizationRpcProvider) {
        this.userRpcProvider = userRpcProvider;
        this.organizationRpcProvider = organizationRpcProvider;
    }


    /**
     * 北京监管外网资格证查询
     * @param queryRequest
     * @return
     */
    @PostMapping("/qualification-credentials")
    public ResponseEntity<Collection<QualificationCredentialResponse>> getQualificationCredentials(
            @RequestBody QueryCredentialRequest queryRequest) {
        /**
         * todo: 添加鉴权操作
         */
        if (StringUtils.isEmpty(queryRequest.getAreaCode())) {
            return this.ok(new ArrayList<>());
        }
        if (queryRequest.getCredentialType() == null) {
            queryRequest.setCredentialType(CredentialType.QualificationCer);
        }

        if (StringUtils.isEmpty(queryRequest.getIdnum())) {
            return this.ok(new ArrayList<>());
        }

        List<QualificationCredentialResponse> response =
                this.userRpcProvider.getQualificationCredentials(queryRequest);

        return this.ok(response);
    }

    /**
     * 北京监管外网服务公司查询
     * @param queryRequest
     * @return
     */
    @PostMapping("/company-info")
    public ResponseEntity companyInfo(@RequestBody OrganizationCriteria queryRequest) {
        Pageable<CompanyCredentialResponse> response = this.organizationRpcProvider.getCompanies(queryRequest);
        return this.ok(response);
    }

    /**
     * <b> 默认陕西政务网用于查询资格证，如果其他省用需要传areaCode（省编码标识） </b>
     * @author ZXF
     * @create 2025/11/19 0019 13:32
     * @version
     * @注意事项 </b>
     */
    @ApiOperation(value = "政务网资格证查询", response = SignInResponse.class)
    @PostMapping("/credential/search")
    public @ResponseBody Object publicSearch(@RequestBody CertificateRequest request) {
        String url = "https://v5qy.baibaodun.cn/v3/public/qualification-credentials";
        String areaCode = "61";
        if(StringUtils.isNotEmpty(request.getAreaCode())){
            areaCode = request.getAreaCode();
        }
        String body = String.format("{'idnum':'%s','areaCode':'%s'}",request.getKeyword(),areaCode);
        HttpResponse response = HttpUtil.createPost(url)
                .contentType("application/json")
                .body(body).execute();
        return JSON.parseObject(response.body());
    }

}
